/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMCounter.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsDeprecatedCSSOMCounterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeprecatedCSSOMCounterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeprecatedCSSOMCounterIdentifier(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeprecatedCSSOMCounterListStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeprecatedCSSOMCounterSeparator(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDeprecatedCSSOMCounterPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMCounterPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMCounterPrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMCounterPrototype>(vm.heap)) JSDeprecatedCSSOMCounterPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMCounterPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMCounterPrototype, JSDeprecatedCSSOMCounterPrototype::Base);

using JSDeprecatedCSSOMCounterConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMCounter>;

template<> JSValue JSDeprecatedCSSOMCounterConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDeprecatedCSSOMCounterConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMCounter::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Counter"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDeprecatedCSSOMCounterConstructor::s_info = { "Counter", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMCounterConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMCounterPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMCounterConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeprecatedCSSOMCounterConstructor) } },
    { "identifier", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMCounterIdentifier), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "listStyle", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMCounterListStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "separator", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMCounterSeparator), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSDeprecatedCSSOMCounterPrototype::s_info = { "CounterPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMCounterPrototype) };

void JSDeprecatedCSSOMCounterPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMCounter::info(), JSDeprecatedCSSOMCounterPrototypeTableValues, *this);
}

const ClassInfo JSDeprecatedCSSOMCounter::s_info = { "Counter", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMCounter) };

JSDeprecatedCSSOMCounter::JSDeprecatedCSSOMCounter(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMCounter>&& impl)
    : JSDOMWrapper<DeprecatedCSSOMCounter>(structure, globalObject, WTFMove(impl))
{
}

void JSDeprecatedCSSOMCounter::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DeprecatedCSSOMCounter>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDeprecatedCSSOMCounter::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMCounterPrototype::create(vm, &globalObject, JSDeprecatedCSSOMCounterPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDeprecatedCSSOMCounter::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMCounter>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMCounter::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMCounterConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDeprecatedCSSOMCounter::destroy(JSC::JSCell* cell)
{
    JSDeprecatedCSSOMCounter* thisObject = static_cast<JSDeprecatedCSSOMCounter*>(cell);
    thisObject->JSDeprecatedCSSOMCounter::~JSDeprecatedCSSOMCounter();
}

template<> inline JSDeprecatedCSSOMCounter* IDLAttribute<JSDeprecatedCSSOMCounter>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDeprecatedCSSOMCounter*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsDeprecatedCSSOMCounterConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMCounterPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMCounter::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDeprecatedCSSOMCounterConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMCounterPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDeprecatedCSSOMCounterIdentifierGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMCounter& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.identifier());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMCounterIdentifier(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMCounter>::get<jsDeprecatedCSSOMCounterIdentifierGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "identifier");
}

static inline JSValue jsDeprecatedCSSOMCounterListStyleGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMCounter& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.listStyle());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMCounterListStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMCounter>::get<jsDeprecatedCSSOMCounterListStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "listStyle");
}

static inline JSValue jsDeprecatedCSSOMCounterSeparatorGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMCounter& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.separator());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMCounterSeparator(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMCounter>::get<jsDeprecatedCSSOMCounterSeparatorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "separator");
}

void JSDeprecatedCSSOMCounter::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMCounter*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDeprecatedCSSOMCounterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDeprecatedCSSOMCounterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDeprecatedCSSOMCounter = static_cast<JSDeprecatedCSSOMCounter*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDeprecatedCSSOMCounter->wrapped(), jsDeprecatedCSSOMCounter);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DeprecatedCSSOMCounter>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DeprecatedCSSOMCounter.
    static_assert(!std::is_polymorphic<DeprecatedCSSOMCounter>::value, "DeprecatedCSSOMCounter is polymorphic but the IDL claims it is not");
    return createWrapper<DeprecatedCSSOMCounter>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DeprecatedCSSOMCounter& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DeprecatedCSSOMCounter* JSDeprecatedCSSOMCounter::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDeprecatedCSSOMCounter*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
