/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMRGBColor.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecatedCSSOMPrimitiveValue.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsDeprecatedCSSOMRGBColorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeprecatedCSSOMRGBColorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeprecatedCSSOMRGBColorRed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeprecatedCSSOMRGBColorGreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeprecatedCSSOMRGBColorBlue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeprecatedCSSOMRGBColorAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDeprecatedCSSOMRGBColorPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMRGBColorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMRGBColorPrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMRGBColorPrototype>(vm.heap)) JSDeprecatedCSSOMRGBColorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMRGBColorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMRGBColorPrototype, JSDeprecatedCSSOMRGBColorPrototype::Base);

using JSDeprecatedCSSOMRGBColorConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMRGBColor>;

template<> JSValue JSDeprecatedCSSOMRGBColorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDeprecatedCSSOMRGBColorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMRGBColor::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("RGBColor"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDeprecatedCSSOMRGBColorConstructor::s_info = { "RGBColor", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRGBColorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMRGBColorPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRGBColorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeprecatedCSSOMRGBColorConstructor) } },
    { "red", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRGBColorRed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "green", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRGBColorGreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "blue", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRGBColorBlue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "alpha", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRGBColorAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSDeprecatedCSSOMRGBColorPrototype::s_info = { "RGBColorPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRGBColorPrototype) };

void JSDeprecatedCSSOMRGBColorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMRGBColor::info(), JSDeprecatedCSSOMRGBColorPrototypeTableValues, *this);
}

const ClassInfo JSDeprecatedCSSOMRGBColor::s_info = { "RGBColor", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRGBColor) };

JSDeprecatedCSSOMRGBColor::JSDeprecatedCSSOMRGBColor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMRGBColor>&& impl)
    : JSDOMWrapper<DeprecatedCSSOMRGBColor>(structure, globalObject, WTFMove(impl))
{
}

void JSDeprecatedCSSOMRGBColor::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DeprecatedCSSOMRGBColor>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDeprecatedCSSOMRGBColor::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMRGBColorPrototype::create(vm, &globalObject, JSDeprecatedCSSOMRGBColorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDeprecatedCSSOMRGBColor::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMRGBColor>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMRGBColor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMRGBColorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDeprecatedCSSOMRGBColor::destroy(JSC::JSCell* cell)
{
    JSDeprecatedCSSOMRGBColor* thisObject = static_cast<JSDeprecatedCSSOMRGBColor*>(cell);
    thisObject->JSDeprecatedCSSOMRGBColor::~JSDeprecatedCSSOMRGBColor();
}

template<> inline JSDeprecatedCSSOMRGBColor* IDLAttribute<JSDeprecatedCSSOMRGBColor>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDeprecatedCSSOMRGBColor*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsDeprecatedCSSOMRGBColorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMRGBColorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMRGBColor::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDeprecatedCSSOMRGBColorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMRGBColorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDeprecatedCSSOMRGBColorRedGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRGBColor& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.red());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMRGBColorRed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMRGBColor>::get<jsDeprecatedCSSOMRGBColorRedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "red");
}

static inline JSValue jsDeprecatedCSSOMRGBColorGreenGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRGBColor& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.green());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMRGBColorGreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMRGBColor>::get<jsDeprecatedCSSOMRGBColorGreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "green");
}

static inline JSValue jsDeprecatedCSSOMRGBColorBlueGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRGBColor& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.blue());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMRGBColorBlue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMRGBColor>::get<jsDeprecatedCSSOMRGBColorBlueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "blue");
}

static inline JSValue jsDeprecatedCSSOMRGBColorAlphaGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRGBColor& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.alpha());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMRGBColorAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMRGBColor>::get<jsDeprecatedCSSOMRGBColorAlphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "alpha");
}

void JSDeprecatedCSSOMRGBColor::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMRGBColor*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDeprecatedCSSOMRGBColorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDeprecatedCSSOMRGBColorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDeprecatedCSSOMRGBColor = static_cast<JSDeprecatedCSSOMRGBColor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDeprecatedCSSOMRGBColor->wrapped(), jsDeprecatedCSSOMRGBColor);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DeprecatedCSSOMRGBColor>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DeprecatedCSSOMRGBColor.
    static_assert(!std::is_polymorphic<DeprecatedCSSOMRGBColor>::value, "DeprecatedCSSOMRGBColor is polymorphic but the IDL claims it is not");
    return createWrapper<DeprecatedCSSOMRGBColor>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DeprecatedCSSOMRGBColor& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DeprecatedCSSOMRGBColor* JSDeprecatedCSSOMRGBColor::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDeprecatedCSSOMRGBColor*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
