/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMRect.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecatedCSSOMPrimitiveValue.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsDeprecatedCSSOMRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeprecatedCSSOMRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeprecatedCSSOMRectTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeprecatedCSSOMRectRight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeprecatedCSSOMRectBottom(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeprecatedCSSOMRectLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDeprecatedCSSOMRectPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMRectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMRectPrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMRectPrototype>(vm.heap)) JSDeprecatedCSSOMRectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMRectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMRectPrototype, JSDeprecatedCSSOMRectPrototype::Base);

using JSDeprecatedCSSOMRectConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMRect>;

template<> JSValue JSDeprecatedCSSOMRectConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDeprecatedCSSOMRectConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMRect::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Rect"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDeprecatedCSSOMRectConstructor::s_info = { "Rect", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRectConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMRectPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeprecatedCSSOMRectConstructor) } },
    { "top", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRectTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "right", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRectRight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bottom", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRectBottom), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "left", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMRectLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSDeprecatedCSSOMRectPrototype::s_info = { "RectPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRectPrototype) };

void JSDeprecatedCSSOMRectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMRect::info(), JSDeprecatedCSSOMRectPrototypeTableValues, *this);
}

const ClassInfo JSDeprecatedCSSOMRect::s_info = { "Rect", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMRect) };

JSDeprecatedCSSOMRect::JSDeprecatedCSSOMRect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMRect>&& impl)
    : JSDOMWrapper<DeprecatedCSSOMRect>(structure, globalObject, WTFMove(impl))
{
}

void JSDeprecatedCSSOMRect::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DeprecatedCSSOMRect>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDeprecatedCSSOMRect::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMRectPrototype::create(vm, &globalObject, JSDeprecatedCSSOMRectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDeprecatedCSSOMRect::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMRect>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMRect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMRectConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDeprecatedCSSOMRect::destroy(JSC::JSCell* cell)
{
    JSDeprecatedCSSOMRect* thisObject = static_cast<JSDeprecatedCSSOMRect*>(cell);
    thisObject->JSDeprecatedCSSOMRect::~JSDeprecatedCSSOMRect();
}

template<> inline JSDeprecatedCSSOMRect* IDLAttribute<JSDeprecatedCSSOMRect>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDeprecatedCSSOMRect*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsDeprecatedCSSOMRectConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMRectPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMRect::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDeprecatedCSSOMRectConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMRectPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDeprecatedCSSOMRectTopGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRect& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.top());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMRectTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMRect>::get<jsDeprecatedCSSOMRectTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "top");
}

static inline JSValue jsDeprecatedCSSOMRectRightGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRect& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.right());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMRectRight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMRect>::get<jsDeprecatedCSSOMRectRightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "right");
}

static inline JSValue jsDeprecatedCSSOMRectBottomGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRect& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bottom());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMRectBottom(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMRect>::get<jsDeprecatedCSSOMRectBottomGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bottom");
}

static inline JSValue jsDeprecatedCSSOMRectLeftGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMRect& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DeprecatedCSSOMPrimitiveValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.left());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMRectLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMRect>::get<jsDeprecatedCSSOMRectLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "left");
}

void JSDeprecatedCSSOMRect::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMRect*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDeprecatedCSSOMRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDeprecatedCSSOMRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDeprecatedCSSOMRect = static_cast<JSDeprecatedCSSOMRect*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDeprecatedCSSOMRect->wrapped(), jsDeprecatedCSSOMRect);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DeprecatedCSSOMRect>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DeprecatedCSSOMRect.
    static_assert(!std::is_polymorphic<DeprecatedCSSOMRect>::value, "DeprecatedCSSOMRect is polymorphic but the IDL claims it is not");
    return createWrapper<DeprecatedCSSOMRect>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DeprecatedCSSOMRect& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DeprecatedCSSOMRect* JSDeprecatedCSSOMRect::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDeprecatedCSSOMRect*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
