/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DEVICE_ORIENTATION)

#include "JSDeviceMotionEvent.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(DEVICE_ORIENTATION)
#include "JSDOMOperationReturningPromise.h"
#endif


namespace WebCore {
using namespace JSC;

#if ENABLE(DEVICE_ORIENTATION)

template<> DeviceMotionEvent::Acceleration convertDictionary<DeviceMotionEvent::Acceleration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    DeviceMotionEvent::Acceleration result;
    JSValue xValue;
    if (isNullOrUndefined)
        xValue = jsUndefined();
    else {
        xValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "x"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!xValue.isUndefined()) {
        result.x = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, xValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue yValue;
    if (isNullOrUndefined)
        yValue = jsUndefined();
    else {
        yValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "y"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!yValue.isUndefined()) {
        result.y = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, yValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue zValue;
    if (isNullOrUndefined)
        zValue = jsUndefined();
    else {
        zValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "z"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!zValue.isUndefined()) {
        result.z = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, zValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const DeviceMotionEvent::Acceleration& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLNullable<IDLDouble>::isNullValue(dictionary.x)) {
        auto xValue = toJS<IDLNullable<IDLDouble>>(IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.x));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "x"), xValue);
    }
    if (!IDLNullable<IDLDouble>::isNullValue(dictionary.y)) {
        auto yValue = toJS<IDLNullable<IDLDouble>>(IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.y));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "y"), yValue);
    }
    if (!IDLNullable<IDLDouble>::isNullValue(dictionary.z)) {
        auto zValue = toJS<IDLNullable<IDLDouble>>(IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.z));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "z"), zValue);
    }
    return result;
}

#endif

#if ENABLE(DEVICE_ORIENTATION)

template<> DeviceMotionEvent::RotationRate convertDictionary<DeviceMotionEvent::RotationRate>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    DeviceMotionEvent::RotationRate result;
    JSValue alphaValue;
    if (isNullOrUndefined)
        alphaValue = jsUndefined();
    else {
        alphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alpha"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!alphaValue.isUndefined()) {
        result.alpha = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, alphaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue betaValue;
    if (isNullOrUndefined)
        betaValue = jsUndefined();
    else {
        betaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "beta"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!betaValue.isUndefined()) {
        result.beta = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, betaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue gammaValue;
    if (isNullOrUndefined)
        gammaValue = jsUndefined();
    else {
        gammaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "gamma"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!gammaValue.isUndefined()) {
        result.gamma = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, gammaValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const DeviceMotionEvent::RotationRate& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLNullable<IDLDouble>::isNullValue(dictionary.alpha)) {
        auto alphaValue = toJS<IDLNullable<IDLDouble>>(IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.alpha));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "alpha"), alphaValue);
    }
    if (!IDLNullable<IDLDouble>::isNullValue(dictionary.beta)) {
        auto betaValue = toJS<IDLNullable<IDLDouble>>(IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.beta));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "beta"), betaValue);
    }
    if (!IDLNullable<IDLDouble>::isNullValue(dictionary.gamma)) {
        auto gammaValue = toJS<IDLNullable<IDLDouble>>(IDLNullable<IDLDouble>::extractValueFromNullable(dictionary.gamma));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "gamma"), gammaValue);
    }
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDeviceMotionEventPrototypeFunctionInitDeviceMotionEvent(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(DEVICE_ORIENTATION)
JSC::EncodedJSValue JSC_HOST_CALL jsDeviceMotionEventConstructorFunctionRequestPermission(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif

// Attributes

JSC::EncodedJSValue jsDeviceMotionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeviceMotionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeviceMotionEventAcceleration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeviceMotionEventAccelerationIncludingGravity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeviceMotionEventRotationRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeviceMotionEventInterval(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDeviceMotionEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeviceMotionEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeviceMotionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSDeviceMotionEventPrototype>(vm.heap)) JSDeviceMotionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeviceMotionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeviceMotionEventPrototype, JSDeviceMotionEventPrototype::Base);

using JSDeviceMotionEventConstructor = JSDOMConstructorNotConstructable<JSDeviceMotionEvent>;

/* Hash table for constructor */

static const HashTableValue JSDeviceMotionEventConstructorTableValues[] =
{
#if ENABLE(DEVICE_ORIENTATION)
    { "requestPermission", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeviceMotionEventConstructorFunctionRequestPermission), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

template<> JSValue JSDeviceMotionEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSDeviceMotionEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDeviceMotionEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DeviceMotionEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDeviceMotionEvent::info(), JSDeviceMotionEventConstructorTableValues, *this);
#if ENABLE(DEVICE_ORIENTATION)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settings().deviceOrientationPermissionAPIEnabled()) {
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("requestPermission"), strlen("requestPermission"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, &globalObject, propertyName);
    }
#endif
}

template<> const ClassInfo JSDeviceMotionEventConstructor::s_info = { "DeviceMotionEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeviceMotionEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDeviceMotionEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeviceMotionEventConstructor) } },
    { "acceleration", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventAcceleration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "accelerationIncludingGravity", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventAccelerationIncludingGravity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rotationRate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventRotationRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "interval", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventInterval), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initDeviceMotionEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeviceMotionEventPrototypeFunctionInitDeviceMotionEvent), (intptr_t) (0) } },
};

const ClassInfo JSDeviceMotionEventPrototype::s_info = { "DeviceMotionEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeviceMotionEventPrototype) };

void JSDeviceMotionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeviceMotionEvent::info(), JSDeviceMotionEventPrototypeTableValues, *this);
}

const ClassInfo JSDeviceMotionEvent::s_info = { "DeviceMotionEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeviceMotionEvent) };

JSDeviceMotionEvent::JSDeviceMotionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeviceMotionEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSDeviceMotionEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DeviceMotionEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDeviceMotionEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDeviceMotionEventPrototype::create(vm, &globalObject, JSDeviceMotionEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSDeviceMotionEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeviceMotionEvent>(vm, globalObject);
}

JSValue JSDeviceMotionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeviceMotionEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSDeviceMotionEvent* IDLAttribute<JSDeviceMotionEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDeviceMotionEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDeviceMotionEvent* IDLOperation<JSDeviceMotionEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDeviceMotionEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDeviceMotionEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeviceMotionEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeviceMotionEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDeviceMotionEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeviceMotionEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDeviceMotionEventAccelerationGetter(JSGlobalObject& lexicalGlobalObject, JSDeviceMotionEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDictionary<DeviceMotionEvent::Acceleration>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.acceleration());
    return result;
}

EncodedJSValue jsDeviceMotionEventAcceleration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeviceMotionEvent>::get<jsDeviceMotionEventAccelerationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "acceleration");
}

static inline JSValue jsDeviceMotionEventAccelerationIncludingGravityGetter(JSGlobalObject& lexicalGlobalObject, JSDeviceMotionEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDictionary<DeviceMotionEvent::Acceleration>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.accelerationIncludingGravity());
    return result;
}

EncodedJSValue jsDeviceMotionEventAccelerationIncludingGravity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeviceMotionEvent>::get<jsDeviceMotionEventAccelerationIncludingGravityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "accelerationIncludingGravity");
}

static inline JSValue jsDeviceMotionEventRotationRateGetter(JSGlobalObject& lexicalGlobalObject, JSDeviceMotionEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDictionary<DeviceMotionEvent::RotationRate>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rotationRate());
    return result;
}

EncodedJSValue jsDeviceMotionEventRotationRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeviceMotionEvent>::get<jsDeviceMotionEventRotationRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rotationRate");
}

static inline JSValue jsDeviceMotionEventIntervalGetter(JSGlobalObject& lexicalGlobalObject, JSDeviceMotionEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.interval());
    return result;
}

EncodedJSValue jsDeviceMotionEventInterval(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeviceMotionEvent>::get<jsDeviceMotionEventIntervalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "interval");
}

static inline JSC::EncodedJSValue jsDeviceMotionEventPrototypeFunctionInitDeviceMotionEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeviceMotionEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto type = callFrame->argument(0).isUndefined() ? emptyString() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto bubbles = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cancelable = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto acceleration = callFrame->argument(3).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLDictionary<DeviceMotionEvent::Acceleration>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto accelerationIncludingGravity = callFrame->argument(4).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLDictionary<DeviceMotionEvent::Acceleration>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotationRate = callFrame->argument(5).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLDictionary<DeviceMotionEvent::RotationRate>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto interval = callFrame->argument(6).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLUnrestrictedDouble>>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.initDeviceMotionEvent(WTFMove(type), WTFMove(bubbles), WTFMove(cancelable), WTFMove(acceleration), WTFMove(accelerationIncludingGravity), WTFMove(rotationRate), WTFMove(interval));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDeviceMotionEventPrototypeFunctionInitDeviceMotionEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeviceMotionEvent>::call<jsDeviceMotionEventPrototypeFunctionInitDeviceMotionEventBody>(*lexicalGlobalObject, *callFrame, "initDeviceMotionEvent");
}

#if ENABLE(DEVICE_ORIENTATION)
static inline JSC::EncodedJSValue jsDeviceMotionEventConstructorFunctionRequestPermissionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    DeviceMotionEvent::requestPermission(document, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDeviceMotionEventConstructorFunctionRequestPermission(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSDeviceMotionEvent>::callStatic<jsDeviceMotionEventConstructorFunctionRequestPermissionBody>(*lexicalGlobalObject, *callFrame, "requestPermission");
}

#endif

void JSDeviceMotionEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeviceMotionEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(DEVICE_ORIENTATION)
