/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DEVICE_ORIENTATION)

#include "JSDeviceOrientationEvent.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(DEVICE_ORIENTATION)
#include "JSDOMOperationReturningPromise.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDeviceOrientationEventPrototypeFunctionInitDeviceOrientationEvent(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(DEVICE_ORIENTATION)
JSC::EncodedJSValue JSC_HOST_CALL jsDeviceOrientationEventConstructorFunctionRequestPermission(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif

// Attributes

JSC::EncodedJSValue jsDeviceOrientationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeviceOrientationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeviceOrientationEventAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeviceOrientationEventBeta(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeviceOrientationEventGamma(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDeviceOrientationEventAbsolute(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDeviceOrientationEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeviceOrientationEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeviceOrientationEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSDeviceOrientationEventPrototype>(vm.heap)) JSDeviceOrientationEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeviceOrientationEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeviceOrientationEventPrototype, JSDeviceOrientationEventPrototype::Base);

using JSDeviceOrientationEventConstructor = JSDOMConstructorNotConstructable<JSDeviceOrientationEvent>;

/* Hash table for constructor */

static const HashTableValue JSDeviceOrientationEventConstructorTableValues[] =
{
#if ENABLE(DEVICE_ORIENTATION)
    { "requestPermission", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeviceOrientationEventConstructorFunctionRequestPermission), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

template<> JSValue JSDeviceOrientationEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSDeviceOrientationEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDeviceOrientationEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DeviceOrientationEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDeviceOrientationEvent::info(), JSDeviceOrientationEventConstructorTableValues, *this);
#if ENABLE(DEVICE_ORIENTATION)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settings().deviceOrientationPermissionAPIEnabled()) {
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("requestPermission"), strlen("requestPermission"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, &globalObject, propertyName);
    }
#endif
}

template<> const ClassInfo JSDeviceOrientationEventConstructor::s_info = { "DeviceOrientationEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeviceOrientationEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDeviceOrientationEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeviceOrientationEventConstructor) } },
    { "alpha", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "beta", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventBeta), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "gamma", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventGamma), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "absolute", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventAbsolute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initDeviceOrientationEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeviceOrientationEventPrototypeFunctionInitDeviceOrientationEvent), (intptr_t) (0) } },
};

const ClassInfo JSDeviceOrientationEventPrototype::s_info = { "DeviceOrientationEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeviceOrientationEventPrototype) };

void JSDeviceOrientationEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeviceOrientationEvent::info(), JSDeviceOrientationEventPrototypeTableValues, *this);
}

const ClassInfo JSDeviceOrientationEvent::s_info = { "DeviceOrientationEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeviceOrientationEvent) };

JSDeviceOrientationEvent::JSDeviceOrientationEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeviceOrientationEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSDeviceOrientationEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DeviceOrientationEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDeviceOrientationEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDeviceOrientationEventPrototype::create(vm, &globalObject, JSDeviceOrientationEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSDeviceOrientationEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeviceOrientationEvent>(vm, globalObject);
}

JSValue JSDeviceOrientationEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeviceOrientationEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSDeviceOrientationEvent* IDLAttribute<JSDeviceOrientationEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDeviceOrientationEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDeviceOrientationEvent* IDLOperation<JSDeviceOrientationEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDeviceOrientationEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDeviceOrientationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeviceOrientationEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeviceOrientationEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDeviceOrientationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeviceOrientationEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDeviceOrientationEventAlphaGetter(JSGlobalObject& lexicalGlobalObject, JSDeviceOrientationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.alpha());
    return result;
}

EncodedJSValue jsDeviceOrientationEventAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeviceOrientationEvent>::get<jsDeviceOrientationEventAlphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "alpha");
}

static inline JSValue jsDeviceOrientationEventBetaGetter(JSGlobalObject& lexicalGlobalObject, JSDeviceOrientationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.beta());
    return result;
}

EncodedJSValue jsDeviceOrientationEventBeta(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeviceOrientationEvent>::get<jsDeviceOrientationEventBetaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "beta");
}

static inline JSValue jsDeviceOrientationEventGammaGetter(JSGlobalObject& lexicalGlobalObject, JSDeviceOrientationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.gamma());
    return result;
}

EncodedJSValue jsDeviceOrientationEventGamma(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeviceOrientationEvent>::get<jsDeviceOrientationEventGammaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "gamma");
}

static inline JSValue jsDeviceOrientationEventAbsoluteGetter(JSGlobalObject& lexicalGlobalObject, JSDeviceOrientationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, impl.absolute());
    return result;
}

EncodedJSValue jsDeviceOrientationEventAbsolute(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeviceOrientationEvent>::get<jsDeviceOrientationEventAbsoluteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "absolute");
}

static inline JSC::EncodedJSValue jsDeviceOrientationEventPrototypeFunctionInitDeviceOrientationEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeviceOrientationEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto type = callFrame->argument(0).isUndefined() ? emptyString() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto bubbles = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cancelable = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = callFrame->argument(3).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLUnrestrictedDouble>>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto beta = callFrame->argument(4).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLUnrestrictedDouble>>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto gamma = callFrame->argument(5).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLUnrestrictedDouble>>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto absolute = callFrame->argument(6).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLBoolean>>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.initDeviceOrientationEvent(WTFMove(type), WTFMove(bubbles), WTFMove(cancelable), WTFMove(alpha), WTFMove(beta), WTFMove(gamma), WTFMove(absolute));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDeviceOrientationEventPrototypeFunctionInitDeviceOrientationEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeviceOrientationEvent>::call<jsDeviceOrientationEventPrototypeFunctionInitDeviceOrientationEventBody>(*lexicalGlobalObject, *callFrame, "initDeviceOrientationEvent");
}

#if ENABLE(DEVICE_ORIENTATION)
static inline JSC::EncodedJSValue jsDeviceOrientationEventConstructorFunctionRequestPermissionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    DeviceOrientationEvent::requestPermission(document, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDeviceOrientationEventConstructorFunctionRequestPermission(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSDeviceOrientationEvent>::callStatic<jsDeviceOrientationEventConstructorFunctionRequestPermissionBody>(*lexicalGlobalObject, *callFrame, "requestPermission");
}

#endif

void JSDeviceOrientationEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeviceOrientationEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(DEVICE_ORIENTATION)
