/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTsRGB.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSEXTsRGBPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTsRGBPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTsRGBPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTsRGBPrototype>(vm.heap)) JSEXTsRGBPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTsRGBPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTsRGBPrototype, JSEXTsRGBPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTsRGBPrototypeTableValues[] =
{
    { "SRGB_EXT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C40) } },
    { "SRGB_ALPHA_EXT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C42) } },
    { "SRGB8_ALPHA8_EXT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8C43) } },
    { "FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x8210) } },
};

const ClassInfo JSEXTsRGBPrototype::s_info = { "EXTsRGBPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTsRGBPrototype) };

void JSEXTsRGBPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTsRGB::info(), JSEXTsRGBPrototypeTableValues, *this);
}

const ClassInfo JSEXTsRGB::s_info = { "EXTsRGB", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTsRGB) };

JSEXTsRGB::JSEXTsRGB(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTsRGB>&& impl)
    : JSDOMWrapper<EXTsRGB>(structure, globalObject, WTFMove(impl))
{
}

void JSEXTsRGB::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, EXTsRGB>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSEXTsRGB::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSEXTsRGBPrototype::create(vm, &globalObject, JSEXTsRGBPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSEXTsRGB::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTsRGB>(vm, globalObject);
}

void JSEXTsRGB::destroy(JSC::JSCell* cell)
{
    JSEXTsRGB* thisObject = static_cast<JSEXTsRGB*>(cell);
    thisObject->JSEXTsRGB::~JSEXTsRGB();
}

void JSEXTsRGB::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTsRGB*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTsRGBOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsEXTsRGB = jsCast<JSEXTsRGB*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsEXTsRGB->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from EXTsRGB";
    return visitor.containsOpaqueRoot(root);
}

void JSEXTsRGBOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTsRGB = static_cast<JSEXTsRGB*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTsRGB->wrapped(), jsEXTsRGB);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTsRGB@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7EXTsRGBE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTsRGB>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7EXTsRGB@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore7EXTsRGBE[2];
#endif

    // If this fails EXTsRGB does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<EXTsRGB>::value, "EXTsRGB is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // EXTsRGB has subclasses. If EXTsRGB has subclasses that get passed
    // to toJS() we currently require EXTsRGB you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<EXTsRGB>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTsRGB& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTsRGB* JSEXTsRGB::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTsRGB*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
