/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PICTURE_IN_PICTURE_API)

#include "JSEnterPictureInPictureEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSPictureInPictureWindow.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(PICTURE_IN_PICTURE_API)
#include "JSDOMConvertStrings.h"
#endif


namespace WebCore {
using namespace JSC;

#if ENABLE(PICTURE_IN_PICTURE_API)

template<> EnterPictureInPictureEvent::Init convertDictionary<EnterPictureInPictureEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    EnterPictureInPictureEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue pictureInPictureWindowValue;
    if (isNullOrUndefined)
        pictureInPictureWindowValue = jsUndefined();
    else {
        pictureInPictureWindowValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pictureInPictureWindow"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pictureInPictureWindowValue.isUndefined()) {
        result.pictureInPictureWindow = convert<IDLInterface<PictureInPictureWindow>>(lexicalGlobalObject, pictureInPictureWindowValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "pictureInPictureWindow", "EnterPictureInPictureEventInit", "PictureInPictureWindow");
        return { };
    }
    return result;
}

#endif

// Attributes

JSC::EncodedJSValue jsEnterPictureInPictureEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSEnterPictureInPictureEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEnterPictureInPictureEventPictureInPictureWindow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSEnterPictureInPictureEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEnterPictureInPictureEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEnterPictureInPictureEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSEnterPictureInPictureEventPrototype>(vm.heap)) JSEnterPictureInPictureEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEnterPictureInPictureEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEnterPictureInPictureEventPrototype, JSEnterPictureInPictureEventPrototype::Base);

using JSEnterPictureInPictureEventConstructor = JSDOMConstructor<JSEnterPictureInPictureEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSEnterPictureInPictureEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSEnterPictureInPictureEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<EnterPictureInPictureEvent::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = EnterPictureInPictureEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<EnterPictureInPictureEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSEnterPictureInPictureEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSEnterPictureInPictureEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSEnterPictureInPictureEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("EnterPictureInPictureEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSEnterPictureInPictureEventConstructor::s_info = { "EnterPictureInPictureEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEnterPictureInPictureEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSEnterPictureInPictureEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEnterPictureInPictureEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEnterPictureInPictureEventConstructor) } },
    { "pictureInPictureWindow", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEnterPictureInPictureEventPictureInPictureWindow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSEnterPictureInPictureEventPrototype::s_info = { "EnterPictureInPictureEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEnterPictureInPictureEventPrototype) };

void JSEnterPictureInPictureEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEnterPictureInPictureEvent::info(), JSEnterPictureInPictureEventPrototypeTableValues, *this);
}

const ClassInfo JSEnterPictureInPictureEvent::s_info = { "EnterPictureInPictureEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEnterPictureInPictureEvent) };

JSEnterPictureInPictureEvent::JSEnterPictureInPictureEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EnterPictureInPictureEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSEnterPictureInPictureEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, EnterPictureInPictureEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSEnterPictureInPictureEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSEnterPictureInPictureEventPrototype::create(vm, &globalObject, JSEnterPictureInPictureEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSEnterPictureInPictureEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEnterPictureInPictureEvent>(vm, globalObject);
}

JSValue JSEnterPictureInPictureEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEnterPictureInPictureEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSEnterPictureInPictureEvent* IDLAttribute<JSEnterPictureInPictureEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSEnterPictureInPictureEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsEnterPictureInPictureEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSEnterPictureInPictureEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSEnterPictureInPictureEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSEnterPictureInPictureEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSEnterPictureInPictureEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsEnterPictureInPictureEventPictureInPictureWindowGetter(JSGlobalObject& lexicalGlobalObject, JSEnterPictureInPictureEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<PictureInPictureWindow>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pictureInPictureWindow());
    return result;
}

EncodedJSValue jsEnterPictureInPictureEventPictureInPictureWindow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSEnterPictureInPictureEvent>::get<jsEnterPictureInPictureEventPictureInPictureWindowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pictureInPictureWindow");
}

void JSEnterPictureInPictureEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEnterPictureInPictureEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EnterPictureInPictureEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26EnterPictureInPictureEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EnterPictureInPictureEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7EnterPictureInPictureEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore26EnterPictureInPictureEventE[2];
#endif

    // If this fails EnterPictureInPictureEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<EnterPictureInPictureEvent>::value, "EnterPictureInPictureEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // EnterPictureInPictureEvent has subclasses. If EnterPictureInPictureEvent has subclasses that get passed
    // to toJS() we currently require EnterPictureInPictureEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<EnterPictureInPictureEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EnterPictureInPictureEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(PICTURE_IN_PICTURE_API)
