/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequest.h"

#include "ActiveDOMObject.h"
#include "JSAbortSignal.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchHeaders.h"
#include "JSFetchReferrerPolicy.h"
#include "JSFetchRequest.h"
#include "JSFetchRequestCache.h"
#include "JSFetchRequestCredentials.h"
#include "JSFetchRequestInit.h"
#include "JSFetchRequestMode.h"
#include "JSFetchRequestRedirect.h"
#include "JSReadableStream.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchRequest::Destination enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("audio"),
        MAKE_STATIC_STRING_IMPL("document"),
        MAKE_STATIC_STRING_IMPL("embed"),
        MAKE_STATIC_STRING_IMPL("font"),
        MAKE_STATIC_STRING_IMPL("image"),
        MAKE_STATIC_STRING_IMPL("manifest"),
        MAKE_STATIC_STRING_IMPL("object"),
        MAKE_STATIC_STRING_IMPL("report"),
        MAKE_STATIC_STRING_IMPL("script"),
        MAKE_STATIC_STRING_IMPL("serviceworker"),
        MAKE_STATIC_STRING_IMPL("sharedworker"),
        MAKE_STATIC_STRING_IMPL("style"),
        MAKE_STATIC_STRING_IMPL("track"),
        MAKE_STATIC_STRING_IMPL("video"),
        MAKE_STATIC_STRING_IMPL("worker"),
        MAKE_STATIC_STRING_IMPL("xslt"),
    };
    static_assert(static_cast<size_t>(FetchRequest::Destination::EmptyString) == 0, "FetchRequest::Destination::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Audio) == 1, "FetchRequest::Destination::Audio is not 1 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Document) == 2, "FetchRequest::Destination::Document is not 2 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Embed) == 3, "FetchRequest::Destination::Embed is not 3 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Font) == 4, "FetchRequest::Destination::Font is not 4 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Image) == 5, "FetchRequest::Destination::Image is not 5 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Manifest) == 6, "FetchRequest::Destination::Manifest is not 6 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Object) == 7, "FetchRequest::Destination::Object is not 7 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Report) == 8, "FetchRequest::Destination::Report is not 8 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Script) == 9, "FetchRequest::Destination::Script is not 9 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Serviceworker) == 10, "FetchRequest::Destination::Serviceworker is not 10 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Sharedworker) == 11, "FetchRequest::Destination::Sharedworker is not 11 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Style) == 12, "FetchRequest::Destination::Style is not 12 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Track) == 13, "FetchRequest::Destination::Track is not 13 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Video) == 14, "FetchRequest::Destination::Video is not 14 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Worker) == 15, "FetchRequest::Destination::Worker is not 15 as expected");
    static_assert(static_cast<size_t>(FetchRequest::Destination::Xslt) == 16, "FetchRequest::Destination::Xslt is not 16 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, FetchRequest::Destination enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<FetchRequest::Destination> parseEnumeration<FetchRequest::Destination>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue.isEmpty())
        return FetchRequest::Destination::EmptyString;
    if (stringValue == "audio")
        return FetchRequest::Destination::Audio;
    if (stringValue == "document")
        return FetchRequest::Destination::Document;
    if (stringValue == "embed")
        return FetchRequest::Destination::Embed;
    if (stringValue == "font")
        return FetchRequest::Destination::Font;
    if (stringValue == "image")
        return FetchRequest::Destination::Image;
    if (stringValue == "manifest")
        return FetchRequest::Destination::Manifest;
    if (stringValue == "object")
        return FetchRequest::Destination::Object;
    if (stringValue == "report")
        return FetchRequest::Destination::Report;
    if (stringValue == "script")
        return FetchRequest::Destination::Script;
    if (stringValue == "serviceworker")
        return FetchRequest::Destination::Serviceworker;
    if (stringValue == "sharedworker")
        return FetchRequest::Destination::Sharedworker;
    if (stringValue == "style")
        return FetchRequest::Destination::Style;
    if (stringValue == "track")
        return FetchRequest::Destination::Track;
    if (stringValue == "video")
        return FetchRequest::Destination::Video;
    if (stringValue == "worker")
        return FetchRequest::Destination::Worker;
    if (stringValue == "xslt")
        return FetchRequest::Destination::Xslt;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<FetchRequest::Destination>()
{
    return "\"\", \"audio\", \"document\", \"embed\", \"font\", \"image\", \"manifest\", \"object\", \"report\", \"script\", \"serviceworker\", \"sharedworker\", \"style\", \"track\", \"video\", \"worker\", \"xslt\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionClone(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionArrayBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionBlob(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionFormData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionJson(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionText(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFetchRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFetchRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFetchRequestMethod(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestUrl(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestHeaders(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestDestination(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestReferrer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestReferrerPolicy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestCredentials(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestCache(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestRedirect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestIntegrity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestKeepalive(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestSignal(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestBody(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchRequestBodyUsed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSFetchRequestPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFetchRequestPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFetchRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSFetchRequestPrototype>(vm.heap)) JSFetchRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFetchRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFetchRequestPrototype, JSFetchRequestPrototype::Base);

using JSFetchRequestConstructor = JSDOMConstructor<JSFetchRequest>;

template<> EncodedJSValue JSC_HOST_CALL JSFetchRequestConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSFetchRequestConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "Request");
    auto input = convert<IDLUnion<IDLInterface<FetchRequest>, IDLUSVString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto init = convert<IDLDictionary<FetchRequestInit>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = FetchRequest::create(*context, WTFMove(input), WTFMove(init));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FetchRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSFetchRequestConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFetchRequestConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFetchRequest::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Request"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSFetchRequestConstructor::s_info = { "Request", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchRequestConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFetchRequestPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFetchRequestConstructor) } },
    { "method", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestMethod), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "url", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "headers", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestHeaders), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "destination", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestDestination), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referrer", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestReferrer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referrerPolicy", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestReferrerPolicy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "mode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "credentials", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestCredentials), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cache", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestCache), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirect", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestRedirect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "integrity", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestIntegrity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "keepalive", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestKeepalive), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "signal", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestSignal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "body", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestBody), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bodyUsed", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchRequestBodyUsed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clone", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchRequestPrototypeFunctionClone), (intptr_t) (0) } },
    { "arrayBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchRequestPrototypeFunctionArrayBuffer), (intptr_t) (0) } },
    { "blob", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchRequestPrototypeFunctionBlob), (intptr_t) (0) } },
    { "formData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchRequestPrototypeFunctionFormData), (intptr_t) (0) } },
    { "json", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchRequestPrototypeFunctionJson), (intptr_t) (0) } },
    { "text", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchRequestPrototypeFunctionText), (intptr_t) (0) } },
};

const ClassInfo JSFetchRequestPrototype::s_info = { "RequestPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchRequestPrototype) };

void JSFetchRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFetchRequest::info(), JSFetchRequestPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("arrayBuffer"), strlen("arrayBuffer"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("blob"), strlen("blob"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("formData"), strlen("formData"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("json"), strlen("json"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("text"), strlen("text"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIKeepAliveEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("keepalive"), strlen("keepalive"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("body"), strlen("body"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("bodyUsed"), strlen("bodyUsed"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSFetchRequest::s_info = { "Request", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchRequest) };

JSFetchRequest::JSFetchRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FetchRequest>&& impl)
    : JSDOMWrapper<FetchRequest>(structure, globalObject, WTFMove(impl))
{
}

void JSFetchRequest::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, FetchRequest>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSFetchRequest::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFetchRequestPrototype::create(vm, &globalObject, JSFetchRequestPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSFetchRequest::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFetchRequest>(vm, globalObject);
}

JSValue JSFetchRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFetchRequestConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFetchRequest::destroy(JSC::JSCell* cell)
{
    JSFetchRequest* thisObject = static_cast<JSFetchRequest*>(cell);
    thisObject->JSFetchRequest::~JSFetchRequest();
}

template<> inline JSFetchRequest* IDLAttribute<JSFetchRequest>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSFetchRequest*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSFetchRequest* IDLOperation<JSFetchRequest>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFetchRequest*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFetchRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFetchRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFetchRequest::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFetchRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFetchRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsFetchRequestMethodGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLByteString>(lexicalGlobalObject, throwScope, impl.method());
    return result;
}

EncodedJSValue jsFetchRequestMethod(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestMethodGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "method");
}

static inline JSValue jsFetchRequestUrlGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.urlString());
    return result;
}

EncodedJSValue jsFetchRequestUrl(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestUrlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "url");
}

static inline JSValue jsFetchRequestHeadersGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<FetchHeaders>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.headers());
    return result;
}

EncodedJSValue jsFetchRequestHeaders(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestHeadersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "headers");
}

static inline JSValue jsFetchRequestDestinationGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FetchRequest::Destination>>(lexicalGlobalObject, throwScope, impl.destination());
    return result;
}

EncodedJSValue jsFetchRequestDestination(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestDestinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "destination");
}

static inline JSValue jsFetchRequestReferrerGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.referrer());
    return result;
}

EncodedJSValue jsFetchRequestReferrer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestReferrerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "referrer");
}

static inline JSValue jsFetchRequestReferrerPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FetchReferrerPolicy>>(lexicalGlobalObject, throwScope, impl.referrerPolicy());
    return result;
}

EncodedJSValue jsFetchRequestReferrerPolicy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestReferrerPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "referrerPolicy");
}

static inline JSValue jsFetchRequestModeGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FetchRequestMode>>(lexicalGlobalObject, throwScope, impl.mode());
    return result;
}

EncodedJSValue jsFetchRequestMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mode");
}

static inline JSValue jsFetchRequestCredentialsGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FetchRequestCredentials>>(lexicalGlobalObject, throwScope, impl.credentials());
    return result;
}

EncodedJSValue jsFetchRequestCredentials(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestCredentialsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "credentials");
}

static inline JSValue jsFetchRequestCacheGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FetchRequestCache>>(lexicalGlobalObject, throwScope, impl.cache());
    return result;
}

EncodedJSValue jsFetchRequestCache(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestCacheGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "cache");
}

static inline JSValue jsFetchRequestRedirectGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FetchRequestRedirect>>(lexicalGlobalObject, throwScope, impl.redirect());
    return result;
}

EncodedJSValue jsFetchRequestRedirect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestRedirectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "redirect");
}

static inline JSValue jsFetchRequestIntegrityGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.integrity());
    return result;
}

EncodedJSValue jsFetchRequestIntegrity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestIntegrityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "integrity");
}

static inline JSValue jsFetchRequestKeepaliveGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.keepalive());
    return result;
}

EncodedJSValue jsFetchRequestKeepalive(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestKeepaliveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "keepalive");
}

static inline JSValue jsFetchRequestSignalGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AbortSignal>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.signal());
    return result;
}

EncodedJSValue jsFetchRequestSignal(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestSignalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "signal");
}

static inline JSValue jsFetchRequestBodyGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<ReadableStream>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.readableStream(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)));
    return result;
}

EncodedJSValue jsFetchRequestBody(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestBodyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "body");
}

static inline JSValue jsFetchRequestBodyUsedGetter(JSGlobalObject& lexicalGlobalObject, JSFetchRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.bodyUsed());
    return result;
}

EncodedJSValue jsFetchRequestBodyUsed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchRequest>::get<jsFetchRequestBodyUsedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bodyUsed");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunctionCloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFetchRequest>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FetchRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clone(*context)));
}

EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionClone(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFetchRequest>::call<jsFetchRequestPrototypeFunctionCloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunctionArrayBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.arrayBuffer(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionArrayBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunctionArrayBufferBody>(*lexicalGlobalObject, *callFrame, "arrayBuffer");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunctionBlobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.blob(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionBlob(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunctionBlobBody>(*lexicalGlobalObject, *callFrame, "blob");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunctionFormDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.formData(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionFormData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunctionFormDataBody>(*lexicalGlobalObject, *callFrame, "formData");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunctionJsonBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.json(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionJson(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunctionJsonBody>(*lexicalGlobalObject, *callFrame, "json");
}

static inline JSC::EncodedJSValue jsFetchRequestPrototypeFunctionTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchRequest>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.text(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchRequestPrototypeFunctionText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchRequest>::call<jsFetchRequestPrototypeFunctionTextBody>(*lexicalGlobalObject, *callFrame, "text");
}

void JSFetchRequest::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFetchRequest*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFetchRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsFetchRequest = jsCast<JSFetchRequest*>(handle.slot()->asCell());
    if (jsFetchRequest->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    FetchRequest* root = &jsFetchRequest->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from FetchRequest";
    return visitor.containsOpaqueRoot(root);
}

void JSFetchRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFetchRequest = static_cast<JSFetchRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFetchRequest->wrapped(), jsFetchRequest);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FetchRequest@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12FetchRequestE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FetchRequest>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7FetchRequest@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12FetchRequestE[2];
#endif

    // If this fails FetchRequest does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<FetchRequest>::value, "FetchRequest is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // FetchRequest has subclasses. If FetchRequest has subclasses that get passed
    // to toJS() we currently require FetchRequest you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<FetchRequest>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FetchRequest& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FetchRequest* JSFetchRequest::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFetchRequest*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
