/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequestCache.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchRequestCache enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("default"),
        MAKE_STATIC_STRING_IMPL("no-store"),
        MAKE_STATIC_STRING_IMPL("reload"),
        MAKE_STATIC_STRING_IMPL("no-cache"),
        MAKE_STATIC_STRING_IMPL("force-cache"),
        MAKE_STATIC_STRING_IMPL("only-if-cached"),
    };
    static_assert(static_cast<size_t>(FetchRequestCache::Default) == 0, "FetchRequestCache::Default is not 0 as expected");
    static_assert(static_cast<size_t>(FetchRequestCache::NoStore) == 1, "FetchRequestCache::NoStore is not 1 as expected");
    static_assert(static_cast<size_t>(FetchRequestCache::Reload) == 2, "FetchRequestCache::Reload is not 2 as expected");
    static_assert(static_cast<size_t>(FetchRequestCache::NoCache) == 3, "FetchRequestCache::NoCache is not 3 as expected");
    static_assert(static_cast<size_t>(FetchRequestCache::ForceCache) == 4, "FetchRequestCache::ForceCache is not 4 as expected");
    static_assert(static_cast<size_t>(FetchRequestCache::OnlyIfCached) == 5, "FetchRequestCache::OnlyIfCached is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, FetchRequestCache enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<FetchRequestCache> parseEnumeration<FetchRequestCache>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "default")
        return FetchRequestCache::Default;
    if (stringValue == "no-store")
        return FetchRequestCache::NoStore;
    if (stringValue == "reload")
        return FetchRequestCache::Reload;
    if (stringValue == "no-cache")
        return FetchRequestCache::NoCache;
    if (stringValue == "force-cache")
        return FetchRequestCache::ForceCache;
    if (stringValue == "only-if-cached")
        return FetchRequestCache::OnlyIfCached;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<FetchRequestCache>()
{
    return "\"default\", \"no-store\", \"reload\", \"no-cache\", \"force-cache\", \"only-if-cached\"";
}

} // namespace WebCore
