/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequestInit.h"

#include "JSBlob.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMFormData.h"
#include "JSFetchReferrerPolicy.h"
#include "JSFetchRequestCache.h"
#include "JSFetchRequestCredentials.h"
#include "JSFetchRequestMode.h"
#include "JSFetchRequestRedirect.h"
#include "JSReadableStream.h"
#include "JSURLSearchParams.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

template<> FetchRequestInit convertDictionary<FetchRequestInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FetchRequestInit result;
    JSValue bodyValue;
    if (isNullOrUndefined)
        bodyValue = jsUndefined();
    else {
        bodyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "body"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bodyValue.isUndefined()) {
        result.body = convert<IDLNullable<IDLUnion<IDLInterface<Blob>, IDLArrayBufferView, IDLArrayBuffer, IDLInterface<DOMFormData>, IDLInterface<URLSearchParams>, IDLInterface<ReadableStream>, IDLUSVString>>>(lexicalGlobalObject, bodyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue cacheValue;
    if (isNullOrUndefined)
        cacheValue = jsUndefined();
    else {
        cacheValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cache"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cacheValue.isUndefined()) {
        result.cache = convert<IDLEnumeration<FetchRequestCache>>(lexicalGlobalObject, cacheValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue credentialsValue;
    if (isNullOrUndefined)
        credentialsValue = jsUndefined();
    else {
        credentialsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "credentials"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!credentialsValue.isUndefined()) {
        result.credentials = convert<IDLEnumeration<FetchRequestCredentials>>(lexicalGlobalObject, credentialsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue headersValue;
    if (isNullOrUndefined)
        headersValue = jsUndefined();
    else {
        headersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headers"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!headersValue.isUndefined()) {
        result.headers = convert<IDLUnion<IDLSequence<IDLSequence<IDLByteString>>, IDLRecord<IDLByteString, IDLByteString>>>(lexicalGlobalObject, headersValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue integrityValue;
    if (isNullOrUndefined)
        integrityValue = jsUndefined();
    else {
        integrityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "integrity"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!integrityValue.isUndefined()) {
        result.integrity = convert<IDLDOMString>(lexicalGlobalObject, integrityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue keepaliveValue;
    if (isNullOrUndefined)
        keepaliveValue = jsUndefined();
    else {
        keepaliveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keepalive"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!keepaliveValue.isUndefined()) {
        result.keepalive = convert<IDLBoolean>(lexicalGlobalObject, keepaliveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue methodValue;
    if (isNullOrUndefined)
        methodValue = jsUndefined();
    else {
        methodValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "method"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!methodValue.isUndefined()) {
        result.method = convert<IDLByteString>(lexicalGlobalObject, methodValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue modeValue;
    if (isNullOrUndefined)
        modeValue = jsUndefined();
    else {
        modeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modeValue.isUndefined()) {
        result.mode = convert<IDLEnumeration<FetchRequestMode>>(lexicalGlobalObject, modeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue redirectValue;
    if (isNullOrUndefined)
        redirectValue = jsUndefined();
    else {
        redirectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "redirect"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!redirectValue.isUndefined()) {
        result.redirect = convert<IDLEnumeration<FetchRequestRedirect>>(lexicalGlobalObject, redirectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue referrerValue;
    if (isNullOrUndefined)
        referrerValue = jsUndefined();
    else {
        referrerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "referrer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!referrerValue.isUndefined()) {
        result.referrer = convert<IDLUSVString>(lexicalGlobalObject, referrerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue referrerPolicyValue;
    if (isNullOrUndefined)
        referrerPolicyValue = jsUndefined();
    else {
        referrerPolicyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "referrerPolicy"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!referrerPolicyValue.isUndefined()) {
        result.referrerPolicy = convert<IDLEnumeration<FetchReferrerPolicy>>(lexicalGlobalObject, referrerPolicyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!signalValue.isUndefined()) {
        result.signal = convert<IDLAny>(lexicalGlobalObject, signalValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.signal = jsUndefined();
    JSValue windowValue;
    if (isNullOrUndefined)
        windowValue = jsUndefined();
    else {
        windowValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "window"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!windowValue.isUndefined()) {
        result.window = convert<IDLAny>(lexicalGlobalObject, windowValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.window = jsUndefined();
    return result;
}

} // namespace WebCore
