/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemDirectoryEntry.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorCallback.h"
#include "JSFileSystemDirectoryReader.h"
#include "JSFileSystemEntryCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> FileSystemDirectoryEntry::Flags convertDictionary<FileSystemDirectoryEntry::Flags>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FileSystemDirectoryEntry::Flags result;
    JSValue createValue;
    if (isNullOrUndefined)
        createValue = jsUndefined();
    else {
        createValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "create"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!createValue.isUndefined()) {
        result.create = convert<IDLBoolean>(lexicalGlobalObject, createValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.create = false;
    JSValue exclusiveValue;
    if (isNullOrUndefined)
        exclusiveValue = jsUndefined();
    else {
        exclusiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exclusive"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!exclusiveValue.isUndefined()) {
        result.exclusive = convert<IDLBoolean>(lexicalGlobalObject, exclusiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.exclusive = false;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFileSystemDirectoryEntryPrototypeFunctionCreateReader(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFileSystemDirectoryEntryPrototypeFunctionGetFile(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFileSystemDirectoryEntryPrototypeFunctionGetDirectory(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFileSystemDirectoryEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFileSystemDirectoryEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFileSystemDirectoryEntryPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemDirectoryEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemDirectoryEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemDirectoryEntryPrototype>(vm.heap)) JSFileSystemDirectoryEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemDirectoryEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemDirectoryEntryPrototype, JSFileSystemDirectoryEntryPrototype::Base);

using JSFileSystemDirectoryEntryConstructor = JSDOMConstructorNotConstructable<JSFileSystemDirectoryEntry>;

template<> JSValue JSFileSystemDirectoryEntryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSFileSystemEntry::getConstructor(vm, &globalObject);
}

template<> void JSFileSystemDirectoryEntryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemDirectoryEntry::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("FileSystemDirectoryEntry"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSFileSystemDirectoryEntryConstructor::s_info = { "FileSystemDirectoryEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryEntryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFileSystemDirectoryEntryPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemDirectoryEntryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFileSystemDirectoryEntryConstructor) } },
    { "createReader", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFileSystemDirectoryEntryPrototypeFunctionCreateReader), (intptr_t) (0) } },
    { "getFile", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFileSystemDirectoryEntryPrototypeFunctionGetFile), (intptr_t) (0) } },
    { "getDirectory", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFileSystemDirectoryEntryPrototypeFunctionGetDirectory), (intptr_t) (0) } },
};

const ClassInfo JSFileSystemDirectoryEntryPrototype::s_info = { "FileSystemDirectoryEntryPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryEntryPrototype) };

void JSFileSystemDirectoryEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemDirectoryEntry::info(), JSFileSystemDirectoryEntryPrototypeTableValues, *this);
}

const ClassInfo JSFileSystemDirectoryEntry::s_info = { "FileSystemDirectoryEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryEntry) };

JSFileSystemDirectoryEntry::JSFileSystemDirectoryEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemDirectoryEntry>&& impl)
    : JSFileSystemEntry(structure, globalObject, WTFMove(impl))
{
}

void JSFileSystemDirectoryEntry::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, FileSystemDirectoryEntry>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSFileSystemDirectoryEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFileSystemDirectoryEntryPrototype::create(vm, &globalObject, JSFileSystemDirectoryEntryPrototype::createStructure(vm, &globalObject, JSFileSystemEntry::prototype(vm, globalObject)));
}

JSObject* JSFileSystemDirectoryEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemDirectoryEntry>(vm, globalObject);
}

JSValue JSFileSystemDirectoryEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemDirectoryEntryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSFileSystemDirectoryEntry* IDLOperation<JSFileSystemDirectoryEntry>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFileSystemDirectoryEntry*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFileSystemDirectoryEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemDirectoryEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemDirectoryEntry::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFileSystemDirectoryEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemDirectoryEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryEntryPrototypeFunctionCreateReaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemDirectoryEntry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(toJS<IDLInterface<FileSystemDirectoryReader>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createReader(*context)));
}

EncodedJSValue JSC_HOST_CALL jsFileSystemDirectoryEntryPrototypeFunctionCreateReader(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFileSystemDirectoryEntry>::call<jsFileSystemDirectoryEntryPrototypeFunctionCreateReaderBody>(*lexicalGlobalObject, *callFrame, "createReader");
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryEntryPrototypeFunctionGetFileBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemDirectoryEntry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto path = callFrame->argument(0).isUndefined() ? String() : convert<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<FileSystemDirectoryEntry::Flags>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto successCallback = convert<IDLNullable<IDLCallbackFunction<JSFileSystemEntryCallback>>>(*lexicalGlobalObject, callFrame->argument(2), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "successCallback", "FileSystemDirectoryEntry", "getFile"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto errorCallback = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, callFrame->argument(3), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 3, "errorCallback", "FileSystemDirectoryEntry", "getFile"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getFile(*context, WTFMove(path), WTFMove(options), WTFMove(successCallback), WTFMove(errorCallback));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileSystemDirectoryEntryPrototypeFunctionGetFile(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFileSystemDirectoryEntry>::call<jsFileSystemDirectoryEntryPrototypeFunctionGetFileBody>(*lexicalGlobalObject, *callFrame, "getFile");
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryEntryPrototypeFunctionGetDirectoryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemDirectoryEntry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto path = callFrame->argument(0).isUndefined() ? String() : convert<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<FileSystemDirectoryEntry::Flags>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto successCallback = convert<IDLNullable<IDLCallbackFunction<JSFileSystemEntryCallback>>>(*lexicalGlobalObject, callFrame->argument(2), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "successCallback", "FileSystemDirectoryEntry", "getDirectory"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto errorCallback = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, callFrame->argument(3), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 3, "errorCallback", "FileSystemDirectoryEntry", "getDirectory"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getDirectory(*context, WTFMove(path), WTFMove(options), WTFMove(successCallback), WTFMove(errorCallback));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileSystemDirectoryEntryPrototypeFunctionGetDirectory(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFileSystemDirectoryEntry>::call<jsFileSystemDirectoryEntryPrototypeFunctionGetDirectoryBody>(*lexicalGlobalObject, *callFrame, "getDirectory");
}

void JSFileSystemDirectoryEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemDirectoryEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemDirectoryEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsFileSystemDirectoryEntry = jsCast<JSFileSystemDirectoryEntry*>(handle.slot()->asCell());
    if (jsFileSystemDirectoryEntry->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemDirectoryEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemDirectoryEntry = static_cast<JSFileSystemDirectoryEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFileSystemDirectoryEntry->wrapped(), jsFileSystemDirectoryEntry);
}


}
