/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemEntry.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFileSystem.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorCallback.h"
#include "JSFileSystemEntryCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFileSystemEntryPrototypeFunctionGetParent(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFileSystemEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFileSystemEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFileSystemEntryIsFile(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFileSystemEntryIsDirectory(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFileSystemEntryName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFileSystemEntryFullPath(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFileSystemEntryFilesystem(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSFileSystemEntryPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemEntryPrototype>(vm.heap)) JSFileSystemEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemEntryPrototype, JSFileSystemEntryPrototype::Base);

using JSFileSystemEntryConstructor = JSDOMConstructorNotConstructable<JSFileSystemEntry>;

template<> JSValue JSFileSystemEntryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFileSystemEntryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemEntry::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("FileSystemEntry"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSFileSystemEntryConstructor::s_info = { "FileSystemEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemEntryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFileSystemEntryPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemEntryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFileSystemEntryConstructor) } },
    { "isFile", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemEntryIsFile), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isDirectory", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemEntryIsDirectory), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemEntryName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "fullPath", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemEntryFullPath), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "filesystem", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemEntryFilesystem), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getParent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFileSystemEntryPrototypeFunctionGetParent), (intptr_t) (0) } },
};

const ClassInfo JSFileSystemEntryPrototype::s_info = { "FileSystemEntryPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemEntryPrototype) };

void JSFileSystemEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemEntry::info(), JSFileSystemEntryPrototypeTableValues, *this);
}

const ClassInfo JSFileSystemEntry::s_info = { "FileSystemEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemEntry) };

JSFileSystemEntry::JSFileSystemEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemEntry>&& impl)
    : JSDOMWrapper<FileSystemEntry>(structure, globalObject, WTFMove(impl))
{
}

void JSFileSystemEntry::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, FileSystemEntry>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSFileSystemEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFileSystemEntryPrototype::create(vm, &globalObject, JSFileSystemEntryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSFileSystemEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemEntry>(vm, globalObject);
}

JSValue JSFileSystemEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemEntryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFileSystemEntry::destroy(JSC::JSCell* cell)
{
    JSFileSystemEntry* thisObject = static_cast<JSFileSystemEntry*>(cell);
    thisObject->JSFileSystemEntry::~JSFileSystemEntry();
}

template<> inline JSFileSystemEntry* IDLAttribute<JSFileSystemEntry>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSFileSystemEntry*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSFileSystemEntry* IDLOperation<JSFileSystemEntry>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFileSystemEntry*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFileSystemEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemEntry::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFileSystemEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsFileSystemEntryIsFileGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isFile());
    return result;
}

EncodedJSValue jsFileSystemEntryIsFile(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntryIsFileGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isFile");
}

static inline JSValue jsFileSystemEntryIsDirectoryGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isDirectory());
    return result;
}

EncodedJSValue jsFileSystemEntryIsDirectory(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntryIsDirectoryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isDirectory");
}

static inline JSValue jsFileSystemEntryNameGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.name());
    return result;
}

EncodedJSValue jsFileSystemEntryName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntryNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline JSValue jsFileSystemEntryFullPathGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.virtualPath());
    return result;
}

EncodedJSValue jsFileSystemEntryFullPath(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntryFullPathGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fullPath");
}

static inline JSValue jsFileSystemEntryFilesystemGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMFileSystem>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.filesystem());
    return result;
}

EncodedJSValue jsFileSystemEntryFilesystem(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntryFilesystemGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "filesystem");
}

static inline JSC::EncodedJSValue jsFileSystemEntryPrototypeFunctionGetParentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemEntry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto successCallback = convert<IDLNullable<IDLCallbackFunction<JSFileSystemEntryCallback>>>(*lexicalGlobalObject, callFrame->argument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "successCallback", "FileSystemEntry", "getParent"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto errorCallback = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, callFrame->argument(1), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback", "FileSystemEntry", "getParent"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getParent(*context, WTFMove(successCallback), WTFMove(errorCallback));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileSystemEntryPrototypeFunctionGetParent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFileSystemEntry>::call<jsFileSystemEntryPrototypeFunctionGetParentBody>(*lexicalGlobalObject, *callFrame, "getParent");
}

void JSFileSystemEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsFileSystemEntry = jsCast<JSFileSystemEntry*>(handle.slot()->asCell());
    if (jsFileSystemEntry->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemEntry = static_cast<JSFileSystemEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFileSystemEntry->wrapped(), jsFileSystemEntry);
}

FileSystemEntry* JSFileSystemEntry::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFileSystemEntry*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
