/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemFileEntry.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorCallback.h"
#include "JSFileCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFileSystemFileEntryPrototypeFunctionFile(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFileSystemFileEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFileSystemFileEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFileSystemFileEntryPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemFileEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemFileEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemFileEntryPrototype>(vm.heap)) JSFileSystemFileEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemFileEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemFileEntryPrototype, JSFileSystemFileEntryPrototype::Base);

using JSFileSystemFileEntryConstructor = JSDOMConstructorNotConstructable<JSFileSystemFileEntry>;

template<> JSValue JSFileSystemFileEntryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSFileSystemEntry::getConstructor(vm, &globalObject);
}

template<> void JSFileSystemFileEntryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemFileEntry::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("FileSystemFileEntry"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSFileSystemFileEntryConstructor::s_info = { "FileSystemFileEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileEntryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFileSystemFileEntryPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemFileEntryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFileSystemFileEntryConstructor) } },
    { "file", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFileSystemFileEntryPrototypeFunctionFile), (intptr_t) (1) } },
};

const ClassInfo JSFileSystemFileEntryPrototype::s_info = { "FileSystemFileEntryPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileEntryPrototype) };

void JSFileSystemFileEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemFileEntry::info(), JSFileSystemFileEntryPrototypeTableValues, *this);
}

const ClassInfo JSFileSystemFileEntry::s_info = { "FileSystemFileEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileEntry) };

JSFileSystemFileEntry::JSFileSystemFileEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemFileEntry>&& impl)
    : JSFileSystemEntry(structure, globalObject, WTFMove(impl))
{
}

void JSFileSystemFileEntry::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, FileSystemFileEntry>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSFileSystemFileEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFileSystemFileEntryPrototype::create(vm, &globalObject, JSFileSystemFileEntryPrototype::createStructure(vm, &globalObject, JSFileSystemEntry::prototype(vm, globalObject)));
}

JSObject* JSFileSystemFileEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemFileEntry>(vm, globalObject);
}

JSValue JSFileSystemFileEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemFileEntryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSFileSystemFileEntry* IDLOperation<JSFileSystemFileEntry>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFileSystemFileEntry*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFileSystemFileEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemFileEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemFileEntry::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFileSystemFileEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemFileEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsFileSystemFileEntryPrototypeFunctionFileBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemFileEntry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto successCallback = convert<IDLCallbackFunction<JSFileCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "successCallback", "FileSystemFileEntry", "file"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto errorCallback = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, callFrame->argument(1), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback", "FileSystemFileEntry", "file"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.file(successCallback.releaseNonNull(), WTFMove(errorCallback));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileSystemFileEntryPrototypeFunctionFile(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFileSystemFileEntry>::call<jsFileSystemFileEntryPrototypeFunctionFileBody>(*lexicalGlobalObject, *callFrame, "file");
}

void JSFileSystemFileEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemFileEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemFileEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsFileSystemFileEntry = jsCast<JSFileSystemFileEntry*>(handle.slot()->asCell());
    if (jsFileSystemFileEntry->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemFileEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemFileEntry = static_cast<JSFileSystemFileEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFileSystemFileEntry->wrapped(), jsFileSystemFileEntry);
}


}
