/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFontFace.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFontFace.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FontFace::LoadStatus enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("unloaded"),
        MAKE_STATIC_STRING_IMPL("loading"),
        MAKE_STATIC_STRING_IMPL("loaded"),
        MAKE_STATIC_STRING_IMPL("error"),
    };
    static_assert(static_cast<size_t>(FontFace::LoadStatus::Unloaded) == 0, "FontFace::LoadStatus::Unloaded is not 0 as expected");
    static_assert(static_cast<size_t>(FontFace::LoadStatus::Loading) == 1, "FontFace::LoadStatus::Loading is not 1 as expected");
    static_assert(static_cast<size_t>(FontFace::LoadStatus::Loaded) == 2, "FontFace::LoadStatus::Loaded is not 2 as expected");
    static_assert(static_cast<size_t>(FontFace::LoadStatus::Error) == 3, "FontFace::LoadStatus::Error is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, FontFace::LoadStatus enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<FontFace::LoadStatus> parseEnumeration<FontFace::LoadStatus>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "unloaded")
        return FontFace::LoadStatus::Unloaded;
    if (stringValue == "loading")
        return FontFace::LoadStatus::Loading;
    if (stringValue == "loaded")
        return FontFace::LoadStatus::Loaded;
    if (stringValue == "error")
        return FontFace::LoadStatus::Error;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<FontFace::LoadStatus>()
{
    return "\"unloaded\", \"loading\", \"loaded\", \"error\"";
}

template<> FontFace::Descriptors convertDictionary<FontFace::Descriptors>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FontFace::Descriptors result;
    JSValue displayValue;
    if (isNullOrUndefined)
        displayValue = jsUndefined();
    else {
        displayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "display"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displayValue.isUndefined()) {
        result.display = convert<IDLDOMString>(lexicalGlobalObject, displayValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.display = "auto"_s;
    JSValue featureSettingsValue;
    if (isNullOrUndefined)
        featureSettingsValue = jsUndefined();
    else {
        featureSettingsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "featureSettings"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!featureSettingsValue.isUndefined()) {
        result.featureSettings = convert<IDLDOMString>(lexicalGlobalObject, featureSettingsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.featureSettings = "normal"_s;
    JSValue stretchValue;
    if (isNullOrUndefined)
        stretchValue = jsUndefined();
    else {
        stretchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stretch"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stretchValue.isUndefined()) {
        result.stretch = convert<IDLDOMString>(lexicalGlobalObject, stretchValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stretch = "normal"_s;
    JSValue styleValue;
    if (isNullOrUndefined)
        styleValue = jsUndefined();
    else {
        styleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "style"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!styleValue.isUndefined()) {
        result.style = convert<IDLDOMString>(lexicalGlobalObject, styleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.style = "normal"_s;
    JSValue unicodeRangeValue;
    if (isNullOrUndefined)
        unicodeRangeValue = jsUndefined();
    else {
        unicodeRangeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "unicodeRange"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!unicodeRangeValue.isUndefined()) {
        result.unicodeRange = convert<IDLDOMString>(lexicalGlobalObject, unicodeRangeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.unicodeRange = "U+0-10FFFF"_s;
    JSValue weightValue;
    if (isNullOrUndefined)
        weightValue = jsUndefined();
    else {
        weightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "weight"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!weightValue.isUndefined()) {
        result.weight = convert<IDLDOMString>(lexicalGlobalObject, weightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.weight = "normal"_s;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFontFacePrototypeFunctionLoad(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFontFaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceFamily(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceFamily(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceWeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceWeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceStretch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceStretch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceUnicodeRange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceUnicodeRange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceFeatureSettings(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceFeatureSettings(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceDisplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceDisplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFontFaceLoaded(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSFontFacePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFontFacePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFontFacePrototype* ptr = new (NotNull, JSC::allocateCell<JSFontFacePrototype>(vm.heap)) JSFontFacePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFontFacePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFontFacePrototype, JSFontFacePrototype::Base);

using JSFontFaceConstructor = JSDOMConstructor<JSFontFace>;

template<> EncodedJSValue JSC_HOST_CALL JSFontFaceConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSFontFaceConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "FontFace");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto family = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto source = convert<IDLUnion<IDLDOMString, IDLArrayBuffer, IDLArrayBufferView>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto descriptors = convert<IDLDictionary<FontFace::Descriptors>>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = FontFace::create(document, WTFMove(family), WTFMove(source), WTFMove(descriptors));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FontFace>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSFontFaceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFontFaceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFontFace::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("FontFace"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSFontFaceConstructor::s_info = { "FontFace", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFaceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFontFacePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceConstructor) } },
    { "family", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceFamily), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceFamily) } },
    { "style", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceStyle) } },
    { "weight", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceWeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceWeight) } },
    { "stretch", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceStretch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceStretch) } },
    { "unicodeRange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceUnicodeRange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceUnicodeRange) } },
    { "featureSettings", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceFeatureSettings), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceFeatureSettings) } },
    { "display", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceDisplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceDisplay) } },
    { "status", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loaded", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceLoaded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "load", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFacePrototypeFunctionLoad), (intptr_t) (0) } },
};

const ClassInfo JSFontFacePrototype::s_info = { "FontFacePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFacePrototype) };

void JSFontFacePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFontFace::info(), JSFontFacePrototypeTableValues, *this);
}

const ClassInfo JSFontFace::s_info = { "FontFace", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFace) };

JSFontFace::JSFontFace(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FontFace>&& impl)
    : JSDOMWrapper<FontFace>(structure, globalObject, WTFMove(impl))
{
}

void JSFontFace::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, FontFace>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSFontFace::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFontFacePrototype::create(vm, &globalObject, JSFontFacePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSFontFace::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFontFace>(vm, globalObject);
}

JSValue JSFontFace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFontFaceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFontFace::destroy(JSC::JSCell* cell)
{
    JSFontFace* thisObject = static_cast<JSFontFace*>(cell);
    thisObject->JSFontFace::~JSFontFace();
}

template<> inline JSFontFace* IDLAttribute<JSFontFace>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSFontFace*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSFontFace* IDLOperation<JSFontFace>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFontFace*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFontFaceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFontFacePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFontFace::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFontFaceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFontFacePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsFontFaceFamilyGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.family());
    return result;
}

EncodedJSValue jsFontFaceFamily(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceFamilyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "family");
}

static inline bool setJSFontFaceFamilySetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFamily(document, WTFMove(nativeValue));
    });
    return true;
}

bool setJSFontFaceFamily(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFace>::set<setJSFontFaceFamilySetter>(*lexicalGlobalObject, thisValue, encodedValue, "family");
}

static inline JSValue jsFontFaceStyleGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.style());
    return result;
}

EncodedJSValue jsFontFaceStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "style");
}

static inline bool setJSFontFaceStyleSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setStyle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSFontFaceStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFace>::set<setJSFontFaceStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "style");
}

static inline JSValue jsFontFaceWeightGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.weight());
    return result;
}

EncodedJSValue jsFontFaceWeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceWeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "weight");
}

static inline bool setJSFontFaceWeightSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setWeight(WTFMove(nativeValue));
    });
    return true;
}

bool setJSFontFaceWeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFace>::set<setJSFontFaceWeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "weight");
}

static inline JSValue jsFontFaceStretchGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.stretch());
    return result;
}

EncodedJSValue jsFontFaceStretch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceStretchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "stretch");
}

static inline bool setJSFontFaceStretchSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setStretch(WTFMove(nativeValue));
    });
    return true;
}

bool setJSFontFaceStretch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFace>::set<setJSFontFaceStretchSetter>(*lexicalGlobalObject, thisValue, encodedValue, "stretch");
}

static inline JSValue jsFontFaceUnicodeRangeGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.unicodeRange());
    return result;
}

EncodedJSValue jsFontFaceUnicodeRange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceUnicodeRangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "unicodeRange");
}

static inline bool setJSFontFaceUnicodeRangeSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnicodeRange(WTFMove(nativeValue));
    });
    return true;
}

bool setJSFontFaceUnicodeRange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFace>::set<setJSFontFaceUnicodeRangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "unicodeRange");
}

static inline JSValue jsFontFaceFeatureSettingsGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.featureSettings());
    return result;
}

EncodedJSValue jsFontFaceFeatureSettings(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceFeatureSettingsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "featureSettings");
}

static inline bool setJSFontFaceFeatureSettingsSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFeatureSettings(WTFMove(nativeValue));
    });
    return true;
}

bool setJSFontFaceFeatureSettings(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFace>::set<setJSFontFaceFeatureSettingsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "featureSettings");
}

static inline JSValue jsFontFaceDisplayGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.display());
    return result;
}

EncodedJSValue jsFontFaceDisplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceDisplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "display");
}

static inline bool setJSFontFaceDisplaySetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDisplay(WTFMove(nativeValue));
    });
    return true;
}

bool setJSFontFaceDisplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFace>::set<setJSFontFaceDisplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "display");
}

static inline JSValue jsFontFaceStatusGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FontFace::LoadStatus>>(lexicalGlobalObject, throwScope, impl.status());
    return result;
}

EncodedJSValue jsFontFaceStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceStatusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "status");
}

static inline JSValue jsFontFaceLoadedGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLPromise<IDLInterface<FontFace>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.loaded());
    return result;
}

EncodedJSValue jsFontFaceLoaded(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFace>::get<jsFontFaceLoadedGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, "loaded");
}

static inline JSC::EncodedJSValue jsFontFacePrototypeFunctionLoadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFontFace>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLPromise<IDLInterface<FontFace>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.load()));
}

EncodedJSValue JSC_HOST_CALL jsFontFacePrototypeFunctionLoad(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFontFace>::callReturningOwnPromise<jsFontFacePrototypeFunctionLoadBody>(*lexicalGlobalObject, *callFrame, "load");
}

void JSFontFace::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFontFace*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFontFaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFontFaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFontFace = static_cast<JSFontFace*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFontFace->wrapped(), jsFontFace);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FontFace@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8FontFaceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FontFace>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7FontFace@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore8FontFaceE[2];
#endif

    // If this fails FontFace does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<FontFace>::value, "FontFace is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // FontFace has subclasses. If FontFace has subclasses that get passed
    // to toJS() we currently require FontFace you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<FontFace>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FontFace& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FontFace* JSFontFace::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFontFace*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
