/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGCObservation.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsGCObservationWasCollected(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSGCObservationPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGCObservationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGCObservationPrototype* ptr = new (NotNull, JSC::allocateCell<JSGCObservationPrototype>(vm.heap)) JSGCObservationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGCObservationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGCObservationPrototype, JSGCObservationPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSGCObservationPrototypeTableValues[] =
{
    { "wasCollected", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGCObservationWasCollected), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSGCObservationPrototype::s_info = { "GCObservationPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGCObservationPrototype) };

void JSGCObservationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGCObservation::info(), JSGCObservationPrototypeTableValues, *this);
}

const ClassInfo JSGCObservation::s_info = { "GCObservation", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGCObservation) };

JSGCObservation::JSGCObservation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GCObservation>&& impl)
    : JSDOMWrapper<GCObservation>(structure, globalObject, WTFMove(impl))
{
}

void JSGCObservation::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, GCObservation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSGCObservation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSGCObservationPrototype::create(vm, &globalObject, JSGCObservationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSGCObservation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGCObservation>(vm, globalObject);
}

void JSGCObservation::destroy(JSC::JSCell* cell)
{
    JSGCObservation* thisObject = static_cast<JSGCObservation*>(cell);
    thisObject->JSGCObservation::~JSGCObservation();
}

template<> inline JSGCObservation* IDLAttribute<JSGCObservation>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSGCObservation*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

static inline JSValue jsGCObservationWasCollectedGetter(JSGlobalObject& lexicalGlobalObject, JSGCObservation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.wasCollected());
    return result;
}

EncodedJSValue jsGCObservationWasCollected(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGCObservation>::get<jsGCObservationWasCollectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "wasCollected");
}

void JSGCObservation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGCObservation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGCObservationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGCObservationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGCObservation = static_cast<JSGCObservation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGCObservation->wrapped(), jsGCObservation);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GCObservation>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to GCObservation.
    static_assert(!std::is_polymorphic<GCObservation>::value, "GCObservation is polymorphic but the IDL claims it is not");
    return createWrapper<GCObservation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GCObservation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GCObservation* JSGCObservation::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGCObservation*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
