/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUBlendDescriptor.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUBlendDescriptor convertDictionary<GPUBlendDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUBlendDescriptor result;
    JSValue dstFactorValue;
    if (isNullOrUndefined)
        dstFactorValue = jsUndefined();
    else {
        dstFactorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dstFactor"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dstFactorValue.isUndefined()) {
        result.dstFactor = convert<IDLEnumeration<GPUBlendFactor>>(lexicalGlobalObject, dstFactorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.dstFactor = GPUBlendFactor::Zero;
    JSValue operationValue;
    if (isNullOrUndefined)
        operationValue = jsUndefined();
    else {
        operationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "operation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!operationValue.isUndefined()) {
        result.operation = convert<IDLEnumeration<GPUBlendOperation>>(lexicalGlobalObject, operationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.operation = GPUBlendOperation::Add;
    JSValue srcFactorValue;
    if (isNullOrUndefined)
        srcFactorValue = jsUndefined();
    else {
        srcFactorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "srcFactor"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!srcFactorValue.isUndefined()) {
        result.srcFactor = convert<IDLEnumeration<GPUBlendFactor>>(lexicalGlobalObject, srcFactorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.srcFactor = GPUBlendFactor::One;
    return result;
}

#endif

String convertEnumerationToString(GPUBlendFactor enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("zero"),
        MAKE_STATIC_STRING_IMPL("one"),
        MAKE_STATIC_STRING_IMPL("src-color"),
        MAKE_STATIC_STRING_IMPL("one-minus-src-color"),
        MAKE_STATIC_STRING_IMPL("src-alpha"),
        MAKE_STATIC_STRING_IMPL("one-minus-src-alpha"),
        MAKE_STATIC_STRING_IMPL("dst-color"),
        MAKE_STATIC_STRING_IMPL("one-minus-dst-color"),
        MAKE_STATIC_STRING_IMPL("dst-alpha"),
        MAKE_STATIC_STRING_IMPL("one-minus-dst-alpha"),
        MAKE_STATIC_STRING_IMPL("src-alpha-saturated"),
        MAKE_STATIC_STRING_IMPL("blend-color"),
        MAKE_STATIC_STRING_IMPL("one-minus-blend-color"),
    };
    static_assert(static_cast<size_t>(GPUBlendFactor::Zero) == 0, "GPUBlendFactor::Zero is not 0 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::One) == 1, "GPUBlendFactor::One is not 1 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::SrcColor) == 2, "GPUBlendFactor::SrcColor is not 2 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusSrcColor) == 3, "GPUBlendFactor::OneMinusSrcColor is not 3 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::SrcAlpha) == 4, "GPUBlendFactor::SrcAlpha is not 4 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusSrcAlpha) == 5, "GPUBlendFactor::OneMinusSrcAlpha is not 5 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::DstColor) == 6, "GPUBlendFactor::DstColor is not 6 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusDstColor) == 7, "GPUBlendFactor::OneMinusDstColor is not 7 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::DstAlpha) == 8, "GPUBlendFactor::DstAlpha is not 8 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusDstAlpha) == 9, "GPUBlendFactor::OneMinusDstAlpha is not 9 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::SrcAlphaSaturated) == 10, "GPUBlendFactor::SrcAlphaSaturated is not 10 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::BlendColor) == 11, "GPUBlendFactor::BlendColor is not 11 as expected");
    static_assert(static_cast<size_t>(GPUBlendFactor::OneMinusBlendColor) == 12, "GPUBlendFactor::OneMinusBlendColor is not 12 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUBlendFactor enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUBlendFactor> parseEnumeration<GPUBlendFactor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "zero")
        return GPUBlendFactor::Zero;
    if (stringValue == "one")
        return GPUBlendFactor::One;
    if (stringValue == "src-color")
        return GPUBlendFactor::SrcColor;
    if (stringValue == "one-minus-src-color")
        return GPUBlendFactor::OneMinusSrcColor;
    if (stringValue == "src-alpha")
        return GPUBlendFactor::SrcAlpha;
    if (stringValue == "one-minus-src-alpha")
        return GPUBlendFactor::OneMinusSrcAlpha;
    if (stringValue == "dst-color")
        return GPUBlendFactor::DstColor;
    if (stringValue == "one-minus-dst-color")
        return GPUBlendFactor::OneMinusDstColor;
    if (stringValue == "dst-alpha")
        return GPUBlendFactor::DstAlpha;
    if (stringValue == "one-minus-dst-alpha")
        return GPUBlendFactor::OneMinusDstAlpha;
    if (stringValue == "src-alpha-saturated")
        return GPUBlendFactor::SrcAlphaSaturated;
    if (stringValue == "blend-color")
        return GPUBlendFactor::BlendColor;
    if (stringValue == "one-minus-blend-color")
        return GPUBlendFactor::OneMinusBlendColor;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUBlendFactor>()
{
    return "\"zero\", \"one\", \"src-color\", \"one-minus-src-color\", \"src-alpha\", \"one-minus-src-alpha\", \"dst-color\", \"one-minus-dst-color\", \"dst-alpha\", \"one-minus-dst-alpha\", \"src-alpha-saturated\", \"blend-color\", \"one-minus-blend-color\"";
}

String convertEnumerationToString(GPUBlendOperation enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("add"),
        MAKE_STATIC_STRING_IMPL("subtract"),
        MAKE_STATIC_STRING_IMPL("reverse-subtract"),
        MAKE_STATIC_STRING_IMPL("min"),
        MAKE_STATIC_STRING_IMPL("max"),
    };
    static_assert(static_cast<size_t>(GPUBlendOperation::Add) == 0, "GPUBlendOperation::Add is not 0 as expected");
    static_assert(static_cast<size_t>(GPUBlendOperation::Subtract) == 1, "GPUBlendOperation::Subtract is not 1 as expected");
    static_assert(static_cast<size_t>(GPUBlendOperation::ReverseSubtract) == 2, "GPUBlendOperation::ReverseSubtract is not 2 as expected");
    static_assert(static_cast<size_t>(GPUBlendOperation::Min) == 3, "GPUBlendOperation::Min is not 3 as expected");
    static_assert(static_cast<size_t>(GPUBlendOperation::Max) == 4, "GPUBlendOperation::Max is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUBlendOperation enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUBlendOperation> parseEnumeration<GPUBlendOperation>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "add")
        return GPUBlendOperation::Add;
    if (stringValue == "subtract")
        return GPUBlendOperation::Subtract;
    if (stringValue == "reverse-subtract")
        return GPUBlendOperation::ReverseSubtract;
    if (stringValue == "min")
        return GPUBlendOperation::Min;
    if (stringValue == "max")
        return GPUBlendOperation::Max;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUBlendOperation>()
{
    return "\"add\", \"subtract\", \"reverse-subtract\", \"min\", \"max\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
