/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUBufferDescriptor.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUBufferDescriptor convertDictionary<GPUBufferDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUBufferDescriptor result;
    JSValue sizeValue;
    if (isNullOrUndefined)
        sizeValue = jsUndefined();
    else {
        sizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "size"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sizeValue.isUndefined()) {
        result.size = convert<IDLUnsignedLongLong>(lexicalGlobalObject, sizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "size", "GPUBufferDescriptor", "unsigned long long");
        return { };
    }
    JSValue usageValue;
    if (isNullOrUndefined)
        usageValue = jsUndefined();
    else {
        usageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usage"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!usageValue.isUndefined()) {
        result.usage = convert<IDLUnsignedLong>(lexicalGlobalObject, usageValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "usage", "GPUBufferDescriptor", "unsigned long");
        return { };
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEBGPU)
