/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUColor.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUColor convertDictionary<GPUColor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUColor result;
    JSValue aValue;
    if (isNullOrUndefined)
        aValue = jsUndefined();
    else {
        aValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "a"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aValue.isUndefined()) {
        result.a = convert<IDLFloat>(lexicalGlobalObject, aValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "a", "GPUColor", "float");
        return { };
    }
    JSValue bValue;
    if (isNullOrUndefined)
        bValue = jsUndefined();
    else {
        bValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "b"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bValue.isUndefined()) {
        result.b = convert<IDLFloat>(lexicalGlobalObject, bValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "b", "GPUColor", "float");
        return { };
    }
    JSValue gValue;
    if (isNullOrUndefined)
        gValue = jsUndefined();
    else {
        gValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "g"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!gValue.isUndefined()) {
        result.g = convert<IDLFloat>(lexicalGlobalObject, gValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "g", "GPUColor", "float");
        return { };
    }
    JSValue rValue;
    if (isNullOrUndefined)
        rValue = jsUndefined();
    else {
        rValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "r"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rValue.isUndefined()) {
        result.r = convert<IDLFloat>(lexicalGlobalObject, rValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "r", "GPUColor", "float");
        return { };
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEBGPU)
