/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUOrigin3D.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUOrigin3D convertDictionary<GPUOrigin3D>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUOrigin3D result;
    JSValue xValue;
    if (isNullOrUndefined)
        xValue = jsUndefined();
    else {
        xValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "x"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!xValue.isUndefined()) {
        result.x = convert<IDLUnsignedLong>(lexicalGlobalObject, xValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.x = 0;
    JSValue yValue;
    if (isNullOrUndefined)
        yValue = jsUndefined();
    else {
        yValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "y"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!yValue.isUndefined()) {
        result.y = convert<IDLUnsignedLong>(lexicalGlobalObject, yValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.y = 0;
    JSValue zValue;
    if (isNullOrUndefined)
        zValue = jsUndefined();
    else {
        zValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "z"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!zValue.isUndefined()) {
        result.z = convert<IDLUnsignedLong>(lexicalGlobalObject, zValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.z = 0;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEBGPU)
