/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUOutOfMemoryError.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsGPUOutOfMemoryErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSGPUOutOfMemoryErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSGPUOutOfMemoryErrorPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUOutOfMemoryErrorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUOutOfMemoryErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUOutOfMemoryErrorPrototype>(vm.heap)) JSGPUOutOfMemoryErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUOutOfMemoryErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUOutOfMemoryErrorPrototype, JSGPUOutOfMemoryErrorPrototype::Base);

using JSGPUOutOfMemoryErrorConstructor = JSDOMConstructor<JSGPUOutOfMemoryError>;

template<> EncodedJSValue JSC_HOST_CALL JSGPUOutOfMemoryErrorConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSGPUOutOfMemoryErrorConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto object = GPUOutOfMemoryError::create();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<GPUOutOfMemoryError>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSGPUOutOfMemoryErrorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUOutOfMemoryErrorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSGPUOutOfMemoryError::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUOutOfMemoryError"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSGPUOutOfMemoryErrorConstructor::s_info = { "GPUOutOfMemoryError", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUOutOfMemoryErrorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSGPUOutOfMemoryErrorPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGPUOutOfMemoryErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSGPUOutOfMemoryErrorConstructor) } },
};

const ClassInfo JSGPUOutOfMemoryErrorPrototype::s_info = { "GPUOutOfMemoryErrorPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUOutOfMemoryErrorPrototype) };

void JSGPUOutOfMemoryErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUOutOfMemoryError::info(), JSGPUOutOfMemoryErrorPrototypeTableValues, *this);
}

const ClassInfo JSGPUOutOfMemoryError::s_info = { "GPUOutOfMemoryError", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUOutOfMemoryError) };

JSGPUOutOfMemoryError::JSGPUOutOfMemoryError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUOutOfMemoryError>&& impl)
    : JSDOMWrapper<GPUOutOfMemoryError>(structure, globalObject, WTFMove(impl))
{
}

void JSGPUOutOfMemoryError::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, GPUOutOfMemoryError>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSGPUOutOfMemoryError::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSGPUOutOfMemoryErrorPrototype::create(vm, &globalObject, JSGPUOutOfMemoryErrorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSGPUOutOfMemoryError::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUOutOfMemoryError>(vm, globalObject);
}

JSValue JSGPUOutOfMemoryError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUOutOfMemoryErrorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUOutOfMemoryError::destroy(JSC::JSCell* cell)
{
    JSGPUOutOfMemoryError* thisObject = static_cast<JSGPUOutOfMemoryError*>(cell);
    thisObject->JSGPUOutOfMemoryError::~JSGPUOutOfMemoryError();
}

EncodedJSValue jsGPUOutOfMemoryErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUOutOfMemoryErrorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUOutOfMemoryError::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSGPUOutOfMemoryErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUOutOfMemoryErrorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

void JSGPUOutOfMemoryError::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUOutOfMemoryError*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUOutOfMemoryErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUOutOfMemoryErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUOutOfMemoryError = static_cast<JSGPUOutOfMemoryError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUOutOfMemoryError->wrapped(), jsGPUOutOfMemoryError);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUOutOfMemoryError>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to GPUOutOfMemoryError.
    static_assert(!std::is_polymorphic<GPUOutOfMemoryError>::value, "GPUOutOfMemoryError is polymorphic but the IDL claims it is not");
    return createWrapper<GPUOutOfMemoryError>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUOutOfMemoryError& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUOutOfMemoryError* JSGPUOutOfMemoryError::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUOutOfMemoryError*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
