/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUSamplerDescriptor.h"

#include "JSDOMConvertNumbers.h"
#include "JSGPUCompareFunction.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUSamplerDescriptor convertDictionary<GPUSamplerDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUSamplerDescriptor result;
    JSValue addressModeUValue;
    if (isNullOrUndefined)
        addressModeUValue = jsUndefined();
    else {
        addressModeUValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeU"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!addressModeUValue.isUndefined()) {
        result.addressModeU = convert<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeUValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.addressModeU = GPUAddressMode::ClampToEdge;
    JSValue addressModeVValue;
    if (isNullOrUndefined)
        addressModeVValue = jsUndefined();
    else {
        addressModeVValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeV"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!addressModeVValue.isUndefined()) {
        result.addressModeV = convert<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeVValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.addressModeV = GPUAddressMode::ClampToEdge;
    JSValue addressModeWValue;
    if (isNullOrUndefined)
        addressModeWValue = jsUndefined();
    else {
        addressModeWValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressModeW"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!addressModeWValue.isUndefined()) {
        result.addressModeW = convert<IDLEnumeration<GPUAddressMode>>(lexicalGlobalObject, addressModeWValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.addressModeW = GPUAddressMode::ClampToEdge;
    JSValue compareFunctionValue;
    if (isNullOrUndefined)
        compareFunctionValue = jsUndefined();
    else {
        compareFunctionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "compareFunction"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compareFunctionValue.isUndefined()) {
        result.compareFunction = convert<IDLEnumeration<GPUCompareFunction>>(lexicalGlobalObject, compareFunctionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.compareFunction = GPUCompareFunction::Never;
    JSValue lodMaxClampValue;
    if (isNullOrUndefined)
        lodMaxClampValue = jsUndefined();
    else {
        lodMaxClampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lodMaxClamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!lodMaxClampValue.isUndefined()) {
        result.lodMaxClamp = convert<IDLFloat>(lexicalGlobalObject, lodMaxClampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.lodMaxClamp = 0xffffffff;
    JSValue lodMinClampValue;
    if (isNullOrUndefined)
        lodMinClampValue = jsUndefined();
    else {
        lodMinClampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lodMinClamp"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!lodMinClampValue.isUndefined()) {
        result.lodMinClamp = convert<IDLFloat>(lexicalGlobalObject, lodMinClampValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.lodMinClamp = 0;
    JSValue magFilterValue;
    if (isNullOrUndefined)
        magFilterValue = jsUndefined();
    else {
        magFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "magFilter"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!magFilterValue.isUndefined()) {
        result.magFilter = convert<IDLEnumeration<GPUFilterMode>>(lexicalGlobalObject, magFilterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.magFilter = GPUFilterMode::Nearest;
    JSValue maxAnisotropyValue;
    if (isNullOrUndefined)
        maxAnisotropyValue = jsUndefined();
    else {
        maxAnisotropyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxAnisotropy"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxAnisotropyValue.isUndefined()) {
        result.maxAnisotropy = convert<IDLUnsignedLong>(lexicalGlobalObject, maxAnisotropyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.maxAnisotropy = 1;
    JSValue minFilterValue;
    if (isNullOrUndefined)
        minFilterValue = jsUndefined();
    else {
        minFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minFilter"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!minFilterValue.isUndefined()) {
        result.minFilter = convert<IDLEnumeration<GPUFilterMode>>(lexicalGlobalObject, minFilterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.minFilter = GPUFilterMode::Nearest;
    JSValue mipmapFilterValue;
    if (isNullOrUndefined)
        mipmapFilterValue = jsUndefined();
    else {
        mipmapFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipmapFilter"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mipmapFilterValue.isUndefined()) {
        result.mipmapFilter = convert<IDLEnumeration<GPUFilterMode>>(lexicalGlobalObject, mipmapFilterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.mipmapFilter = GPUFilterMode::Nearest;
    return result;
}

#endif

String convertEnumerationToString(GPUAddressMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("clamp-to-edge"),
        MAKE_STATIC_STRING_IMPL("repeat"),
        MAKE_STATIC_STRING_IMPL("mirror-repeat"),
    };
    static_assert(static_cast<size_t>(GPUAddressMode::ClampToEdge) == 0, "GPUAddressMode::ClampToEdge is not 0 as expected");
    static_assert(static_cast<size_t>(GPUAddressMode::Repeat) == 1, "GPUAddressMode::Repeat is not 1 as expected");
    static_assert(static_cast<size_t>(GPUAddressMode::MirrorRepeat) == 2, "GPUAddressMode::MirrorRepeat is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUAddressMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUAddressMode> parseEnumeration<GPUAddressMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "clamp-to-edge")
        return GPUAddressMode::ClampToEdge;
    if (stringValue == "repeat")
        return GPUAddressMode::Repeat;
    if (stringValue == "mirror-repeat")
        return GPUAddressMode::MirrorRepeat;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUAddressMode>()
{
    return "\"clamp-to-edge\", \"repeat\", \"mirror-repeat\"";
}

String convertEnumerationToString(GPUFilterMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("nearest"),
        MAKE_STATIC_STRING_IMPL("linear"),
    };
    static_assert(static_cast<size_t>(GPUFilterMode::Nearest) == 0, "GPUFilterMode::Nearest is not 0 as expected");
    static_assert(static_cast<size_t>(GPUFilterMode::Linear) == 1, "GPUFilterMode::Linear is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUFilterMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUFilterMode> parseEnumeration<GPUFilterMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "nearest")
        return GPUFilterMode::Nearest;
    if (stringValue == "linear")
        return GPUFilterMode::Linear;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUFilterMode>()
{
    return "\"nearest\", \"linear\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
