/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUTextureFormat.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUTextureFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("rgba8unorm"),
        MAKE_STATIC_STRING_IMPL("rgba8uint"),
        MAKE_STATIC_STRING_IMPL("bgra8unorm"),
        MAKE_STATIC_STRING_IMPL("depth32float-stencil8"),
        MAKE_STATIC_STRING_IMPL("bgra8unorm-srgb"),
        MAKE_STATIC_STRING_IMPL("rgba16float"),
    };
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba8unorm) == 0, "GPUTextureFormat::Rgba8unorm is not 0 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba8uint) == 1, "GPUTextureFormat::Rgba8uint is not 1 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bgra8unorm) == 2, "GPUTextureFormat::Bgra8unorm is not 2 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Depth32floatStencil8) == 3, "GPUTextureFormat::Depth32floatStencil8 is not 3 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Bgra8unormSRGB) == 4, "GPUTextureFormat::Bgra8unormSRGB is not 4 as expected");
    static_assert(static_cast<size_t>(GPUTextureFormat::Rgba16float) == 5, "GPUTextureFormat::Rgba16float is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUTextureFormat enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUTextureFormat> parseEnumeration<GPUTextureFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "rgba8unorm")
        return GPUTextureFormat::Rgba8unorm;
    if (stringValue == "rgba8uint")
        return GPUTextureFormat::Rgba8uint;
    if (stringValue == "bgra8unorm")
        return GPUTextureFormat::Bgra8unorm;
    if (stringValue == "depth32float-stencil8")
        return GPUTextureFormat::Depth32floatStencil8;
    if (stringValue == "bgra8unorm-srgb")
        return GPUTextureFormat::Bgra8unormSRGB;
    if (stringValue == "rgba16float")
        return GPUTextureFormat::Rgba16float;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUTextureFormat>()
{
    return "\"rgba8unorm\", \"rgba8uint\", \"bgra8unorm\", \"depth32float-stencil8\", \"bgra8unorm-srgb\", \"rgba16float\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
