/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUVertexAttributeDescriptor.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUVertexAttributeDescriptor convertDictionary<GPUVertexAttributeDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUVertexAttributeDescriptor result;
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUVertexFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "GPUVertexAttributeDescriptor", "GPUVertexFormat");
        return { };
    }
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLUnsignedLongLong>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.offset = 0;
    JSValue shaderLocationValue;
    if (isNullOrUndefined)
        shaderLocationValue = jsUndefined();
    else {
        shaderLocationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shaderLocation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shaderLocationValue.isUndefined()) {
        result.shaderLocation = convert<IDLUnsignedLong>(lexicalGlobalObject, shaderLocationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "shaderLocation", "GPUVertexAttributeDescriptor", "unsigned long");
        return { };
    }
    return result;
}

#endif

String convertEnumerationToString(GPUVertexFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("float"),
        MAKE_STATIC_STRING_IMPL("float2"),
        MAKE_STATIC_STRING_IMPL("float3"),
        MAKE_STATIC_STRING_IMPL("float4"),
    };
    static_assert(static_cast<size_t>(GPUVertexFormat::Float) == 0, "GPUVertexFormat::Float is not 0 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float2) == 1, "GPUVertexFormat::Float2 is not 1 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float3) == 2, "GPUVertexFormat::Float3 is not 2 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float4) == 3, "GPUVertexFormat::Float4 is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUVertexFormat enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUVertexFormat> parseEnumeration<GPUVertexFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "float")
        return GPUVertexFormat::Float;
    if (stringValue == "float2")
        return GPUVertexFormat::Float2;
    if (stringValue == "float3")
        return GPUVertexFormat::Float3;
    if (stringValue == "float4")
        return GPUVertexFormat::Float4;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUVertexFormat>()
{
    return "\"float\", \"float2\", \"float3\", \"float4\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
