/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUVertexInputDescriptor.h"

#include "JSDOMConvertNullable.h"
#include "JSDOMConvertSequences.h"
#include "JSGPUVertexBufferDescriptor.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUVertexInputDescriptor convertDictionary<GPUVertexInputDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUVertexInputDescriptor result;
    JSValue indexFormatValue;
    if (isNullOrUndefined)
        indexFormatValue = jsUndefined();
    else {
        indexFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "indexFormat"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!indexFormatValue.isUndefined()) {
        result.indexFormat = convert<IDLEnumeration<GPUIndexFormat>>(lexicalGlobalObject, indexFormatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.indexFormat = GPUIndexFormat::Uint32;
    JSValue vertexBuffersValue;
    if (isNullOrUndefined)
        vertexBuffersValue = jsUndefined();
    else {
        vertexBuffersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "vertexBuffers"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!vertexBuffersValue.isUndefined()) {
        result.vertexBuffers = convert<IDLSequence<IDLNullable<IDLDictionary<GPUVertexBufferDescriptor>>>>(lexicalGlobalObject, vertexBuffersValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "vertexBuffers", "GPUVertexInputDescriptor", "sequence");
        return { };
    }
    return result;
}

#endif

String convertEnumerationToString(GPUIndexFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("uint16"),
        MAKE_STATIC_STRING_IMPL("uint32"),
    };
    static_assert(static_cast<size_t>(GPUIndexFormat::Uint16) == 0, "GPUIndexFormat::Uint16 is not 0 as expected");
    static_assert(static_cast<size_t>(GPUIndexFormat::Uint32) == 1, "GPUIndexFormat::Uint32 is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUIndexFormat enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUIndexFormat> parseEnumeration<GPUIndexFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "uint16")
        return GPUIndexFormat::Uint16;
    if (stringValue == "uint32")
        return GPUIndexFormat::Uint32;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUIndexFormat>()
{
    return "\"uint16\", \"uint32\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
