/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocationPositionError.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsGeolocationPositionErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSGeolocationPositionErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsGeolocationPositionErrorCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationPositionErrorMessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSGeolocationPositionErrorPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGeolocationPositionErrorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeolocationPositionErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeolocationPositionErrorPrototype>(vm.heap)) JSGeolocationPositionErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeolocationPositionErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationPositionErrorPrototype, JSGeolocationPositionErrorPrototype::Base);

using JSGeolocationPositionErrorConstructor = JSDOMConstructorNotConstructable<JSGeolocationPositionError>;

/* Hash table for constructor */

static const HashTableValue JSGeolocationPositionErrorConstructorTableValues[] =
{
    { "PERMISSION_DENIED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "POSITION_UNAVAILABLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TIMEOUT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

static_assert(GeolocationPositionError::PERMISSION_DENIED == 1, "PERMISSION_DENIED in GeolocationPositionError does not match value from IDL");
static_assert(GeolocationPositionError::POSITION_UNAVAILABLE == 2, "POSITION_UNAVAILABLE in GeolocationPositionError does not match value from IDL");
static_assert(GeolocationPositionError::TIMEOUT == 3, "TIMEOUT in GeolocationPositionError does not match value from IDL");

template<> JSValue JSGeolocationPositionErrorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGeolocationPositionErrorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSGeolocationPositionError::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GeolocationPositionError"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSGeolocationPositionError::info(), JSGeolocationPositionErrorConstructorTableValues, *this);
}

template<> const ClassInfo JSGeolocationPositionErrorConstructor::s_info = { "GeolocationPositionError", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionErrorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSGeolocationPositionErrorPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationPositionErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSGeolocationPositionErrorConstructor) } },
    { "code", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationPositionErrorCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "message", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationPositionErrorMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "PERMISSION_DENIED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "POSITION_UNAVAILABLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TIMEOUT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSGeolocationPositionErrorPrototype::s_info = { "GeolocationPositionErrorPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionErrorPrototype) };

void JSGeolocationPositionErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeolocationPositionError::info(), JSGeolocationPositionErrorPrototypeTableValues, *this);
}

const ClassInfo JSGeolocationPositionError::s_info = { "GeolocationPositionError", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionError) };

JSGeolocationPositionError::JSGeolocationPositionError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GeolocationPositionError>&& impl)
    : JSDOMWrapper<GeolocationPositionError>(structure, globalObject, WTFMove(impl))
{
}

void JSGeolocationPositionError::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, GeolocationPositionError>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSGeolocationPositionError::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSGeolocationPositionErrorPrototype::create(vm, &globalObject, JSGeolocationPositionErrorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSGeolocationPositionError::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGeolocationPositionError>(vm, globalObject);
}

JSValue JSGeolocationPositionError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGeolocationPositionErrorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGeolocationPositionError::destroy(JSC::JSCell* cell)
{
    JSGeolocationPositionError* thisObject = static_cast<JSGeolocationPositionError*>(cell);
    thisObject->JSGeolocationPositionError::~JSGeolocationPositionError();
}

template<> inline JSGeolocationPositionError* IDLAttribute<JSGeolocationPositionError>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSGeolocationPositionError*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsGeolocationPositionErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationPositionErrorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGeolocationPositionError::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSGeolocationPositionErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationPositionErrorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsGeolocationPositionErrorCodeGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationPositionError& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.code());
    return result;
}

EncodedJSValue jsGeolocationPositionErrorCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationPositionError>::get<jsGeolocationPositionErrorCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "code");
}

static inline JSValue jsGeolocationPositionErrorMessageGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationPositionError& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message());
    return result;
}

EncodedJSValue jsGeolocationPositionErrorMessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationPositionError>::get<jsGeolocationPositionErrorMessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "message");
}

void JSGeolocationPositionError::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGeolocationPositionError*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGeolocationPositionErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGeolocationPositionErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeolocationPositionError = static_cast<JSGeolocationPositionError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGeolocationPositionError->wrapped(), jsGeolocationPositionError);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GeolocationPositionError>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to GeolocationPositionError.
    static_assert(!std::is_polymorphic<GeolocationPositionError>::value, "GeolocationPositionError is polymorphic but the IDL claims it is not");
    return createWrapper<GeolocationPositionError>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GeolocationPositionError& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GeolocationPositionError* JSGeolocationPositionError::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeolocationPositionError*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
