/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLBodyElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "EventNames.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsHTMLBodyElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementALink(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementALink(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementBackground(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementBackground(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementBgColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementBgColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementLink(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementLink(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementVLink(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementVLink(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnfocusin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnfocusin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnfocusout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnfocusout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnwebkitmouseforcechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnwebkitmouseforcedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcewillbegin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnwebkitmouseforcewillbegin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitmouseforceup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnwebkitmouseforceup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLBodyElementOnselectionchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnselectionchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnafterprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnafterprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnbeforeprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnbeforeprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnbeforeunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnbeforeunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnhashchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnhashchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnlanguagechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnlanguagechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnoffline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnoffline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnonline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnonline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnpagehide(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnpagehide(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnpageshow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnpageshow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnpopstate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnpopstate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnstorage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnstorage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(ORIENTATION_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnorientationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLBodyElementOnorientationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif

class JSHTMLBodyElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLBodyElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLBodyElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLBodyElementPrototype>(vm.heap)) JSHTMLBodyElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLBodyElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLBodyElementPrototype, JSHTMLBodyElementPrototype::Base);

using JSHTMLBodyElementConstructor = JSDOMConstructorNotConstructable<JSHTMLBodyElement>;

template<> JSValue JSHTMLBodyElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLBodyElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLBodyElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLBodyElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLBodyElementConstructor::s_info = { "HTMLBodyElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLBodyElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLBodyElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementConstructor) } },
    { "aLink", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementALink), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementALink) } },
    { "background", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementBackground), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementBackground) } },
    { "bgColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementBgColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementBgColor) } },
    { "link", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementLink), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementLink) } },
    { "text", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementText) } },
    { "vLink", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementVLink), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementVLink) } },
    { "onblur", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnblur) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnerror) } },
    { "onfocus", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnfocus) } },
    { "onfocusin", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnfocusin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnfocusin) } },
    { "onfocusout", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnfocusout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnfocusout) } },
    { "onload", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnload) } },
    { "onresize", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnresize) } },
    { "onscroll", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnscroll) } },
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcechanged", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitmouseforcechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitmouseforcechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcedown", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitmouseforcedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitmouseforcedown) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcewillbegin", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitmouseforcewillbegin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitmouseforcewillbegin) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforceup", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitmouseforceup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitmouseforceup) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onselectionchange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnselectionchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnselectionchange) } },
    { "onafterprint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnafterprint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnafterprint) } },
    { "onbeforeprint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnbeforeprint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnbeforeprint) } },
    { "onbeforeunload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnbeforeunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnbeforeunload) } },
    { "onhashchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnhashchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnhashchange) } },
    { "onlanguagechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnlanguagechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnlanguagechange) } },
    { "onmessage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnmessage) } },
    { "onoffline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnoffline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnoffline) } },
    { "ononline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnonline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnonline) } },
    { "onpagehide", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnpagehide), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnpagehide) } },
    { "onpageshow", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnpageshow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnpageshow) } },
    { "onpopstate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnpopstate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnpopstate) } },
    { "onstorage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnstorage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnstorage) } },
    { "onunload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnunload) } },
#if ENABLE(ORIENTATION_EVENTS)
    { "onorientationchange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnorientationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnorientationchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSHTMLBodyElementPrototype::s_info = { "HTMLBodyElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLBodyElementPrototype) };

void JSHTMLBodyElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLBodyElement::info(), JSHTMLBodyElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLBodyElement::s_info = { "HTMLBodyElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLBodyElement) };

JSHTMLBodyElement::JSHTMLBodyElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLBodyElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLBodyElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLBodyElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLBodyElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLBodyElementPrototype::create(vm, &globalObject, JSHTMLBodyElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLBodyElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLBodyElement>(vm, globalObject);
}

JSValue JSHTMLBodyElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLBodyElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLBodyElement* IDLAttribute<JSHTMLBodyElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLBodyElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsHTMLBodyElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLBodyElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLBodyElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLBodyElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLBodyElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLBodyElementALinkGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::alinkAttr));
    return result;
}

EncodedJSValue jsHTMLBodyElementALink(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementALinkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "aLink");
}

static inline bool setJSHTMLBodyElementALinkSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alinkAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLBodyElementALink(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementALinkSetter>(*lexicalGlobalObject, thisValue, encodedValue, "aLink");
}

static inline JSValue jsHTMLBodyElementBackgroundGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::backgroundAttr));
    return result;
}

EncodedJSValue jsHTMLBodyElementBackground(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementBackgroundGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "background");
}

static inline bool setJSHTMLBodyElementBackgroundSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::backgroundAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLBodyElementBackground(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementBackgroundSetter>(*lexicalGlobalObject, thisValue, encodedValue, "background");
}

static inline JSValue jsHTMLBodyElementBgColorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::bgcolorAttr));
    return result;
}

EncodedJSValue jsHTMLBodyElementBgColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementBgColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bgColor");
}

static inline bool setJSHTMLBodyElementBgColorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::bgcolorAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLBodyElementBgColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementBgColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "bgColor");
}

static inline JSValue jsHTMLBodyElementLinkGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::linkAttr));
    return result;
}

EncodedJSValue jsHTMLBodyElementLink(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementLinkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "link");
}

static inline bool setJSHTMLBodyElementLinkSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::linkAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLBodyElementLink(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementLinkSetter>(*lexicalGlobalObject, thisValue, encodedValue, "link");
}

static inline JSValue jsHTMLBodyElementTextGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::textAttr));
    return result;
}

EncodedJSValue jsHTMLBodyElementText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "text");
}

static inline bool setJSHTMLBodyElementTextSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::textAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLBodyElementText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "text");
}

static inline JSValue jsHTMLBodyElementVLinkGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::vlinkAttr));
    return result;
}

EncodedJSValue jsHTMLBodyElementVLink(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementVLinkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "vLink");
}

static inline bool setJSHTMLBodyElementVLinkSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::vlinkAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLBodyElementVLink(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementVLinkSetter>(*lexicalGlobalObject, thisValue, encodedValue, "vLink");
}

static inline JSValue jsHTMLBodyElementOnblurGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onblur");
}

static inline bool setJSHTMLBodyElementOnblurSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().blurEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onblur");
}

static inline JSValue jsHTMLBodyElementOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSHTMLBodyElementOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsHTMLBodyElementOnfocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocus");
}

static inline bool setJSHTMLBodyElementOnfocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocus");
}

static inline JSValue jsHTMLBodyElementOnfocusinGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusinEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnfocusin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnfocusinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocusin");
}

static inline bool setJSHTMLBodyElementOnfocusinSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusinEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnfocusin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnfocusinSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocusin");
}

static inline JSValue jsHTMLBodyElementOnfocusoutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusoutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnfocusout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnfocusoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocusout");
}

static inline bool setJSHTMLBodyElementOnfocusoutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusoutEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnfocusout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnfocusoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocusout");
}

static inline JSValue jsHTMLBodyElementOnloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onload");
}

static inline bool setJSHTMLBodyElementOnloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onload");
}

static inline JSValue jsHTMLBodyElementOnresizeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onresize");
}

static inline bool setJSHTMLBodyElementOnresizeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resizeEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onresize");
}

static inline JSValue jsHTMLBodyElementOnscrollGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onscroll");
}

static inline bool setJSHTMLBodyElementOnscrollSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().scrollEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onscroll");
}

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsHTMLBodyElementOnwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnwebkitmouseforcechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcechanged");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSHTMLBodyElementOnwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnwebkitmouseforcechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcechanged");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsHTMLBodyElementOnwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnwebkitmouseforcedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcedown");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSHTMLBodyElementOnwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnwebkitmouseforcedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcedown");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsHTMLBodyElementOnwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcewillbegin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnwebkitmouseforcewillbeginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcewillbegin");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSHTMLBodyElementOnwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnwebkitmouseforcewillbegin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcewillbegin");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsHTMLBodyElementOnwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnwebkitmouseforceup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnwebkitmouseforceupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforceup");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSHTMLBodyElementOnwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforceupEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnwebkitmouseforceup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforceup");
}

#endif

static inline JSValue jsHTMLBodyElementOnselectionchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return documentEventHandlerAttribute(thisObject.wrapped(), eventNames().selectionchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnselectionchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnselectionchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onselectionchange");
}

static inline bool setJSHTMLBodyElementOnselectionchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setDocumentEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().selectionchangeEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnselectionchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnselectionchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onselectionchange");
}

static inline JSValue jsHTMLBodyElementOnafterprintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().afterprintEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnafterprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnafterprintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onafterprint");
}

static inline bool setJSHTMLBodyElementOnafterprintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().afterprintEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnafterprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnafterprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onafterprint");
}

static inline JSValue jsHTMLBodyElementOnbeforeprintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().beforeprintEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnbeforeprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnbeforeprintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforeprint");
}

static inline bool setJSHTMLBodyElementOnbeforeprintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeprintEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnbeforeprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnbeforeprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeprint");
}

static inline JSValue jsHTMLBodyElementOnbeforeunloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().beforeunloadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnbeforeunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnbeforeunloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforeunload");
}

static inline bool setJSHTMLBodyElementOnbeforeunloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeunloadEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnbeforeunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnbeforeunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeunload");
}

static inline JSValue jsHTMLBodyElementOnhashchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().hashchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnhashchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnhashchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onhashchange");
}

static inline bool setJSHTMLBodyElementOnhashchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().hashchangeEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnhashchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnhashchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onhashchange");
}

static inline JSValue jsHTMLBodyElementOnlanguagechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().languagechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnlanguagechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnlanguagechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onlanguagechange");
}

static inline bool setJSHTMLBodyElementOnlanguagechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().languagechangeEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnlanguagechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnlanguagechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onlanguagechange");
}

static inline JSValue jsHTMLBodyElementOnmessageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnmessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmessage");
}

static inline bool setJSHTMLBodyElementOnmessageSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessage");
}

static inline JSValue jsHTMLBodyElementOnofflineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().offlineEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnoffline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnofflineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onoffline");
}

static inline bool setJSHTMLBodyElementOnofflineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().offlineEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnoffline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnofflineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onoffline");
}

static inline JSValue jsHTMLBodyElementOnonlineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().onlineEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnonline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnonlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ononline");
}

static inline bool setJSHTMLBodyElementOnonlineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().onlineEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnonline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnonlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ononline");
}

static inline JSValue jsHTMLBodyElementOnpagehideGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().pagehideEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnpagehide(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnpagehideGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpagehide");
}

static inline bool setJSHTMLBodyElementOnpagehideSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pagehideEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnpagehide(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnpagehideSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpagehide");
}

static inline JSValue jsHTMLBodyElementOnpageshowGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().pageshowEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnpageshow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnpageshowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpageshow");
}

static inline bool setJSHTMLBodyElementOnpageshowSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pageshowEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnpageshow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnpageshowSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpageshow");
}

static inline JSValue jsHTMLBodyElementOnpopstateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().popstateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnpopstate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnpopstateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpopstate");
}

static inline bool setJSHTMLBodyElementOnpopstateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().popstateEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnpopstate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnpopstateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpopstate");
}

static inline JSValue jsHTMLBodyElementOnstorageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().storageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnstorage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnstorageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onstorage");
}

static inline bool setJSHTMLBodyElementOnstorageSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().storageEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnstorage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnstorageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstorage");
}

static inline JSValue jsHTMLBodyElementOnunloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().unloadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnunloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onunload");
}

static inline bool setJSHTMLBodyElementOnunloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().unloadEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onunload");
}

#if ENABLE(ORIENTATION_EVENTS)
static inline JSValue jsHTMLBodyElementOnorientationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().orientationchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLBodyElementOnorientationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLBodyElement>::get<jsHTMLBodyElementOnorientationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onorientationchange");
}

#endif

#if ENABLE(ORIENTATION_EVENTS)
static inline bool setJSHTMLBodyElementOnorientationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLBodyElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().orientationchangeEvent, value);
    return true;
}

bool setJSHTMLBodyElementOnorientationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLBodyElement>::set<setJSHTMLBodyElementOnorientationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onorientationchange");
}

#endif

void JSHTMLBodyElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLBodyElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
