/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLButtonElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionCheckValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionReportValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionSetCustomValidity(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsHTMLButtonElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementAutofocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementAutofocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementForm(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLButtonElementFormAction(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementFormAction(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementFormEnctype(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementFormEnctype(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementFormMethod(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementFormMethod(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementFormNoValidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementFormNoValidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementFormTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementFormTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLButtonElementValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLButtonElementWillValidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLButtonElementValidity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLButtonElementValidationMessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLButtonElementLabels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSHTMLButtonElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLButtonElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLButtonElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLButtonElementPrototype>(vm.heap)) JSHTMLButtonElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLButtonElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLButtonElementPrototype, JSHTMLButtonElementPrototype::Base);

using JSHTMLButtonElementConstructor = JSDOMConstructorNotConstructable<JSHTMLButtonElement>;

template<> JSValue JSHTMLButtonElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLButtonElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLButtonElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLButtonElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLButtonElementConstructor::s_info = { "HTMLButtonElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLButtonElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLButtonElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementConstructor) } },
    { "autofocus", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementAutofocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementAutofocus) } },
    { "disabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementDisabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementDisabled) } },
    { "form", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementForm), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "formAction", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormAction), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementFormAction) } },
    { "formEnctype", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormEnctype), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementFormEnctype) } },
    { "formMethod", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormMethod), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementFormMethod) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementType) } },
    { "formNoValidate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormNoValidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementFormNoValidate) } },
    { "formTarget", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementFormTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementFormTarget) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementName) } },
    { "value", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLButtonElementValue) } },
    { "willValidate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementWillValidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validity", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValidity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validationMessage", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementValidationMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "labels", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLButtonElementLabels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "checkValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLButtonElementPrototypeFunctionCheckValidity), (intptr_t) (0) } },
    { "reportValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLButtonElementPrototypeFunctionReportValidity), (intptr_t) (0) } },
    { "setCustomValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLButtonElementPrototypeFunctionSetCustomValidity), (intptr_t) (1) } },
};

const ClassInfo JSHTMLButtonElementPrototype::s_info = { "HTMLButtonElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLButtonElementPrototype) };

void JSHTMLButtonElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLButtonElement::info(), JSHTMLButtonElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().interactiveFormValidationEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("reportValidity"), strlen("reportValidity"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLButtonElement::s_info = { "HTMLButtonElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLButtonElement) };

JSHTMLButtonElement::JSHTMLButtonElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLButtonElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLButtonElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLButtonElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLButtonElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLButtonElementPrototype::create(vm, &globalObject, JSHTMLButtonElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLButtonElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLButtonElement>(vm, globalObject);
}

JSValue JSHTMLButtonElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLButtonElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLButtonElement* IDLAttribute<JSHTMLButtonElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLButtonElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLButtonElement* IDLOperation<JSHTMLButtonElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLButtonElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLButtonElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLButtonElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLButtonElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLButtonElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLButtonElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLButtonElementAutofocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autofocusAttr));
    return result;
}

EncodedJSValue jsHTMLButtonElementAutofocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementAutofocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autofocus");
}

static inline bool setJSHTMLButtonElementAutofocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementAutofocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementAutofocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "autofocus");
}

static inline JSValue jsHTMLButtonElementDisabledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::disabledAttr));
    return result;
}

EncodedJSValue jsHTMLButtonElementDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementDisabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "disabled");
}

static inline bool setJSHTMLButtonElementDisabledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::disabledAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementDisabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "disabled");
}

static inline JSValue jsHTMLButtonElementFormGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLFormElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.form());
    return result;
}

EncodedJSValue jsHTMLButtonElementForm(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementFormGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "form");
}

static inline JSValue jsHTMLButtonElementFormActionGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.formAction());
    return result;
}

EncodedJSValue jsHTMLButtonElementFormAction(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementFormActionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "formAction");
}

static inline bool setJSHTMLButtonElementFormActionSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFormAction(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementFormAction(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementFormActionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "formAction");
}

static inline JSValue jsHTMLButtonElementFormEnctypeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.formEnctype());
    return result;
}

EncodedJSValue jsHTMLButtonElementFormEnctype(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementFormEnctypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "formEnctype");
}

static inline bool setJSHTMLButtonElementFormEnctypeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFormEnctype(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementFormEnctype(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementFormEnctypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "formEnctype");
}

static inline JSValue jsHTMLButtonElementFormMethodGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.formMethod());
    return result;
}

EncodedJSValue jsHTMLButtonElementFormMethod(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementFormMethodGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "formMethod");
}

static inline bool setJSHTMLButtonElementFormMethodSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFormMethod(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementFormMethod(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementFormMethodSetter>(*lexicalGlobalObject, thisValue, encodedValue, "formMethod");
}

static inline JSValue jsHTMLButtonElementTypeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsHTMLButtonElementType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline bool setJSHTMLButtonElementTypeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setType(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementTypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "type");
}

static inline JSValue jsHTMLButtonElementFormNoValidateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::formnovalidateAttr));
    return result;
}

EncodedJSValue jsHTMLButtonElementFormNoValidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementFormNoValidateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "formNoValidate");
}

static inline bool setJSHTMLButtonElementFormNoValidateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::formnovalidateAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementFormNoValidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementFormNoValidateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "formNoValidate");
}

static inline JSValue jsHTMLButtonElementFormTargetGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::formtargetAttr));
    return result;
}

EncodedJSValue jsHTMLButtonElementFormTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementFormTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "formTarget");
}

static inline bool setJSHTMLButtonElementFormTargetSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::formtargetAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementFormTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementFormTargetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "formTarget");
}

static inline JSValue jsHTMLButtonElementNameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.getNameAttribute());
    return result;
}

EncodedJSValue jsHTMLButtonElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSHTMLButtonElementNameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsHTMLButtonElementValueGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::valueAttr));
    return result;
}

EncodedJSValue jsHTMLButtonElementValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "value");
}

static inline bool setJSHTMLButtonElementValueSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::valueAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLButtonElementValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLButtonElement>::set<setJSHTMLButtonElementValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "value");
}

static inline JSValue jsHTMLButtonElementWillValidateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.willValidate());
    return result;
}

EncodedJSValue jsHTMLButtonElementWillValidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementWillValidateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "willValidate");
}

static inline JSValue jsHTMLButtonElementValidityGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<ValidityState>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.validity());
    return result;
}

EncodedJSValue jsHTMLButtonElementValidity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementValidityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validity");
}

static inline JSValue jsHTMLButtonElementValidationMessageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.validationMessage());
    return result;
}

EncodedJSValue jsHTMLButtonElementValidationMessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementValidationMessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validationMessage");
}

static inline JSValue jsHTMLButtonElementLabelsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLButtonElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<NodeList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.labels());
    return result;
}

EncodedJSValue jsHTMLButtonElementLabels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLButtonElement>::get<jsHTMLButtonElementLabelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "labels");
}

static inline JSC::EncodedJSValue jsHTMLButtonElementPrototypeFunctionCheckValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLButtonElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.checkValidity()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionCheckValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLButtonElement>::call<jsHTMLButtonElementPrototypeFunctionCheckValidityBody>(*lexicalGlobalObject, *callFrame, "checkValidity");
}

static inline JSC::EncodedJSValue jsHTMLButtonElementPrototypeFunctionReportValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLButtonElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.reportValidity()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionReportValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLButtonElement>::call<jsHTMLButtonElementPrototypeFunctionReportValidityBody>(*lexicalGlobalObject, *callFrame, "reportValidity");
}

static inline JSC::EncodedJSValue jsHTMLButtonElementPrototypeFunctionSetCustomValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLButtonElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto error = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setCustomValidity(WTFMove(error));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLButtonElementPrototypeFunctionSetCustomValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLButtonElement>::call<jsHTMLButtonElementPrototypeFunctionSetCustomValidityBody>(*lexicalGlobalObject, *callFrame, "setCustomValidity");
}

void JSHTMLButtonElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLButtonElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
