/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "EventNames.h"
#include "HTMLNames.h"
#include "JSCSSStyleDeclaration.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMStringMap.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(CSS_TYPED_OM)
#include "JSStylePropertyMap.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionClick(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionFocus(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionBlur(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsHTMLElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementTitle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementTitle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementLang(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementLang(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementTranslate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementTranslate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementDir(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementDir(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementHidden(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementHidden(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementAccessKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementAccessKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementDraggable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementDraggable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementSpellcheck(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementSpellcheck(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementInnerText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementInnerText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementContentEditable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementContentEditable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementIsContentEditable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLElementOffsetParent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLElementOffsetTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLElementOffsetLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLElementOffsetWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLElementOffsetHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLElementOuterText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOuterText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(AUTOCORRECT)
JSC::EncodedJSValue jsHTMLElementAutocorrect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementAutocorrect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(AUTOCAPITALIZE)
JSC::EncodedJSValue jsHTMLElementAutocapitalize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementAutocapitalize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLElementWebkitdropzone(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementWebkitdropzone(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementInputMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementInputMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementEnterKeyHint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementEnterKeyHint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsHTMLElementAttributeStyleMap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsHTMLElementOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOncanplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOncanplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOncanplaythrough(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOncanplaythrough(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOncontextmenu(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOncontextmenu(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOncuechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOncuechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndblclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndblclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndrag(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndrag(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndragend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndragend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndragenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndragenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndragleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndragleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndragover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndragover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndragstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndragstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndrop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndrop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOndurationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOndurationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnemptied(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnemptied(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOninput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOninput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOninvalid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOninvalid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnkeydown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnkeydown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnkeypress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnkeypress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnkeyup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnkeyup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnloadeddata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnloadeddata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnloadedmetadata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnloadedmetadata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnloadstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnloadstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnmousedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnmousedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnmouseenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnmouseenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnmouseleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnmouseleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnmousemove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnmousemove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnmouseout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnmouseout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnmouseover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnmouseover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnmouseup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnmouseup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnmousewheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnmousewheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpause(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpause(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnplaying(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnplaying(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnratechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnratechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnrejectionhandled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnrejectionhandled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnreset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnreset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnseeked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnseeked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnseeking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnseeking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnselect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnselect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnstalled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnstalled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnsubmit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnsubmit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnsuspend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnsuspend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOntimeupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntimeupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOntoggle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntoggle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnunhandledrejection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnunhandledrejection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnvolumechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnvolumechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnwaiting(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnwaiting(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOntransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOntransitionrun(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntransitionrun(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOntransitionstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntransitionstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOntransitioncancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntransitioncancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnanimationcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnanimationcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOngotpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOngotpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnlostpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnlostpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpointerdown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpointerdown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpointermove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpointermove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpointerup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpointerup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpointercancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpointercancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpointerover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpointerover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpointerout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpointerout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpointerenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpointerenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnpointerleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnpointerleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnsearch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnsearch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLElementOnwheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnwheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsHTMLElementOntouchcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntouchcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsHTMLElementOntouchend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntouchend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsHTMLElementOntouchmove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntouchmove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsHTMLElementOntouchstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntouchstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsHTMLElementOntouchforcechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOntouchforcechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLElementOnwebkitmouseforcechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnwebkitmouseforcechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLElementOnwebkitmouseforcedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnwebkitmouseforcedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLElementOnwebkitmouseforcewillbegin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnwebkitmouseforcewillbegin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLElementOnwebkitmouseforceup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementOnwebkitmouseforceup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLElementDataset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLElementTabIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLElementTabIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLElementPrototype>(vm.heap)) JSHTMLElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLElementPrototype, JSHTMLElementPrototype::Base);

using JSHTMLElementConstructor = JSDOMConstructor<JSHTMLElement>;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSHTMLElementConstructor::construct(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    ASSERT(callFrame);
    return constructJSHTMLElement(lexicalGlobalObject, *callFrame);
}

template<> JSValue JSHTMLElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLElementConstructor::s_info = { "HTMLElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementConstructor) } },
    { "title", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTitle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementTitle) } },
    { "lang", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementLang), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementLang) } },
    { "translate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTranslate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementTranslate) } },
    { "dir", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDir), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementDir) } },
    { "hidden", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementHidden), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementHidden) } },
    { "accessKey", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementAccessKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementAccessKey) } },
    { "draggable", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDraggable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementDraggable) } },
    { "spellcheck", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementSpellcheck), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementSpellcheck) } },
    { "innerText", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementInnerText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementInnerText) } },
    { "contentEditable", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementContentEditable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementContentEditable) } },
    { "isContentEditable", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementIsContentEditable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetParent", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOffsetParent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetTop", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOffsetTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetLeft", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOffsetLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetWidth", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOffsetWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "offsetHeight", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOffsetHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "outerText", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOuterText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOuterText) } },
#if ENABLE(AUTOCORRECT)
    { "autocorrect", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementAutocorrect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementAutocorrect) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(AUTOCAPITALIZE)
    { "autocapitalize", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementAutocapitalize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementAutocapitalize) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "webkitdropzone", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementWebkitdropzone), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementWebkitdropzone) } },
    { "inputMode", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementInputMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementInputMode) } },
    { "enterKeyHint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementEnterKeyHint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementEnterKeyHint) } },
    { "style", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementStyle) } },
#if ENABLE(CSS_TYPED_OM)
    { "attributeStyleMap", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementAttributeStyleMap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onabort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnabort) } },
    { "onblur", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnblur) } },
    { "oncanplay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOncanplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOncanplay) } },
    { "oncanplaythrough", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOncanplaythrough), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOncanplaythrough) } },
    { "onchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnchange) } },
    { "onclick", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnclick) } },
    { "oncontextmenu", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOncontextmenu), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOncontextmenu) } },
    { "oncuechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOncuechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOncuechange) } },
    { "ondblclick", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndblclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndblclick) } },
    { "ondrag", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndrag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndrag) } },
    { "ondragend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndragend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndragend) } },
    { "ondragenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndragenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndragenter) } },
    { "ondragleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndragleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndragleave) } },
    { "ondragover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndragover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndragover) } },
    { "ondragstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndragstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndragstart) } },
    { "ondrop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndrop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndrop) } },
    { "ondurationchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOndurationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOndurationchange) } },
    { "onemptied", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnemptied), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnemptied) } },
    { "onended", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnended) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnerror) } },
    { "onfocus", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnfocus) } },
    { "oninput", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOninput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOninput) } },
    { "oninvalid", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOninvalid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOninvalid) } },
    { "onkeydown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnkeydown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnkeydown) } },
    { "onkeypress", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnkeypress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnkeypress) } },
    { "onkeyup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnkeyup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnkeyup) } },
    { "onload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnload) } },
    { "onloadeddata", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnloadeddata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnloadeddata) } },
    { "onloadedmetadata", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnloadedmetadata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnloadedmetadata) } },
    { "onloadstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnloadstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnloadstart) } },
    { "onmousedown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnmousedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnmousedown) } },
    { "onmouseenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnmouseenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnmouseenter) } },
    { "onmouseleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnmouseleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnmouseleave) } },
    { "onmousemove", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnmousemove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnmousemove) } },
    { "onmouseout", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnmouseout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnmouseout) } },
    { "onmouseover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnmouseover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnmouseover) } },
    { "onmouseup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnmouseup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnmouseup) } },
    { "onmousewheel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnmousewheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnmousewheel) } },
    { "onpause", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpause), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpause) } },
    { "onplay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnplay) } },
    { "onplaying", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnplaying), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnplaying) } },
    { "onprogress", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnprogress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnprogress) } },
    { "onratechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnratechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnratechange) } },
    { "onrejectionhandled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnrejectionhandled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnrejectionhandled) } },
    { "onreset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnreset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnreset) } },
    { "onresize", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnresize) } },
    { "onscroll", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnscroll) } },
    { "onseeked", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnseeked), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnseeked) } },
    { "onseeking", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnseeking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnseeking) } },
    { "onselect", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnselect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnselect) } },
    { "onstalled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnstalled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnstalled) } },
    { "onsubmit", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnsubmit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnsubmit) } },
    { "onsuspend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnsuspend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnsuspend) } },
    { "ontimeupdate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntimeupdate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntimeupdate) } },
    { "ontoggle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntoggle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntoggle) } },
    { "onunhandledrejection", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnunhandledrejection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnunhandledrejection) } },
    { "onvolumechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnvolumechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnvolumechange) } },
    { "onwaiting", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnwaiting), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnwaiting) } },
    { "ontransitionend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntransitionend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntransitionend) } },
    { "ontransitionrun", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntransitionrun), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntransitionrun) } },
    { "ontransitionstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntransitionstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntransitionstart) } },
    { "ontransitioncancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntransitioncancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntransitioncancel) } },
    { "onanimationend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnanimationend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnanimationend) } },
    { "onanimationiteration", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnanimationiteration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnanimationiteration) } },
    { "onanimationstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnanimationstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnanimationstart) } },
    { "onanimationcancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnanimationcancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnanimationcancel) } },
    { "ongotpointercapture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOngotpointercapture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOngotpointercapture) } },
    { "onlostpointercapture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnlostpointercapture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnlostpointercapture) } },
    { "onpointerdown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpointerdown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpointerdown) } },
    { "onpointermove", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpointermove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpointermove) } },
    { "onpointerup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpointerup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpointerup) } },
    { "onpointercancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpointercancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpointercancel) } },
    { "onpointerover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpointerover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpointerover) } },
    { "onpointerout", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpointerout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpointerout) } },
    { "onpointerenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpointerenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpointerenter) } },
    { "onpointerleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnpointerleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnpointerleave) } },
    { "onsearch", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnsearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnsearch) } },
    { "onwheel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnwheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnwheel) } },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntouchcancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntouchcancel) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntouchend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntouchend) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntouchmove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntouchmove) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntouchstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntouchstart) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchforcechange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOntouchforcechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOntouchforcechange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcechanged", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnwebkitmouseforcechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnwebkitmouseforcechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcedown", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnwebkitmouseforcedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnwebkitmouseforcedown) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcewillbegin", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnwebkitmouseforcewillbegin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnwebkitmouseforcewillbegin) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforceup", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOnwebkitmouseforceup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementOnwebkitmouseforceup) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "dataset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDataset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tabIndex", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTabIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLElementTabIndex) } },
    { "click", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLElementPrototypeFunctionClick), (intptr_t) (0) } },
    { "focus", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLElementPrototypeFunctionFocus), (intptr_t) (0) } },
    { "blur", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLElementPrototypeFunctionBlur), (intptr_t) (0) } },
};

const ClassInfo JSHTMLElementPrototype::s_info = { "HTMLElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLElementPrototype) };

void JSHTMLElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLElement::info(), JSHTMLElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().enterKeyHintEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("enterKeyHint"), strlen("enterKeyHint"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#if ENABLE(CSS_TYPED_OM)
    if (!RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("attributeStyleMap"), strlen("attributeStyleMap"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchcancel"), strlen("ontouchcancel"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchend"), strlen("ontouchend"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchmove"), strlen("ontouchmove"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchstart"), strlen("ontouchstart"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchforcechange"), strlen("ontouchforcechange"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLElement::s_info = { "HTMLElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLElement) };

JSHTMLElement::JSHTMLElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLElement>&& impl)
    : JSElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLElementPrototype::create(vm, &globalObject, JSHTMLElementPrototype::createStructure(vm, &globalObject, JSElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLElement>(vm, globalObject);
}

JSValue JSHTMLElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLElement* IDLAttribute<JSHTMLElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLElement* IDLOperation<JSHTMLElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLElementTitleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::titleAttr));
    return result;
}

EncodedJSValue jsHTMLElementTitle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementTitleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "title");
}

static inline bool setJSHTMLElementTitleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::titleAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementTitle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementTitleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "title");
}

static inline JSValue jsHTMLElementLangGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::langAttr));
    return result;
}

EncodedJSValue jsHTMLElementLang(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementLangGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lang");
}

static inline bool setJSHTMLElementLangSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::langAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementLang(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementLangSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lang");
}

static inline JSValue jsHTMLElementTranslateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.translate());
    return result;
}

EncodedJSValue jsHTMLElementTranslate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementTranslateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "translate");
}

static inline bool setJSHTMLElementTranslateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTranslate(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementTranslate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementTranslateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "translate");
}

static inline JSValue jsHTMLElementDirGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.dir());
    return result;
}

EncodedJSValue jsHTMLElementDir(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementDirGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dir");
}

static inline bool setJSHTMLElementDirSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDir(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementDir(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementDirSetter>(*lexicalGlobalObject, thisValue, encodedValue, "dir");
}

static inline JSValue jsHTMLElementHiddenGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::hiddenAttr));
    return result;
}

EncodedJSValue jsHTMLElementHidden(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementHiddenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "hidden");
}

static inline bool setJSHTMLElementHiddenSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::hiddenAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementHidden(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementHiddenSetter>(*lexicalGlobalObject, thisValue, encodedValue, "hidden");
}

static inline JSValue jsHTMLElementAccessKeyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::accesskeyAttr));
    return result;
}

EncodedJSValue jsHTMLElementAccessKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementAccessKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "accessKey");
}

static inline bool setJSHTMLElementAccessKeySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::accesskeyAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementAccessKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementAccessKeySetter>(*lexicalGlobalObject, thisValue, encodedValue, "accessKey");
}

static inline JSValue jsHTMLElementDraggableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.draggable());
    return result;
}

EncodedJSValue jsHTMLElementDraggable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementDraggableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "draggable");
}

static inline bool setJSHTMLElementDraggableSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDraggable(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementDraggable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementDraggableSetter>(*lexicalGlobalObject, thisValue, encodedValue, "draggable");
}

static inline JSValue jsHTMLElementSpellcheckGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.spellcheck());
    return result;
}

EncodedJSValue jsHTMLElementSpellcheck(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementSpellcheckGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "spellcheck");
}

static inline bool setJSHTMLElementSpellcheckSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSpellcheck(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementSpellcheck(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementSpellcheckSetter>(*lexicalGlobalObject, thisValue, encodedValue, "spellcheck");
}

static inline JSValue jsHTMLElementInnerTextGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.innerText());
    return result;
}

EncodedJSValue jsHTMLElementInnerText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementInnerTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "innerText");
}

static inline bool setJSHTMLElementInnerTextSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setInnerText(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementInnerText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementInnerTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "innerText");
}

static inline JSValue jsHTMLElementContentEditableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.contentEditable());
    return result;
}

EncodedJSValue jsHTMLElementContentEditable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementContentEditableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "contentEditable");
}

static inline bool setJSHTMLElementContentEditableSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setContentEditable(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementContentEditable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementContentEditableSetter>(*lexicalGlobalObject, thisValue, encodedValue, "contentEditable");
}

static inline JSValue jsHTMLElementIsContentEditableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isContentEditable());
    return result;
}

EncodedJSValue jsHTMLElementIsContentEditable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementIsContentEditableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isContentEditable");
}

static inline JSValue jsHTMLElementOffsetParentGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.offsetParentForBindings());
    return result;
}

EncodedJSValue jsHTMLElementOffsetParent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOffsetParentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "offsetParent");
}

static inline JSValue jsHTMLElementOffsetTopGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.offsetTopForBindings());
    return result;
}

EncodedJSValue jsHTMLElementOffsetTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOffsetTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "offsetTop");
}

static inline JSValue jsHTMLElementOffsetLeftGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.offsetLeftForBindings());
    return result;
}

EncodedJSValue jsHTMLElementOffsetLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOffsetLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "offsetLeft");
}

static inline JSValue jsHTMLElementOffsetWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.offsetWidth());
    return result;
}

EncodedJSValue jsHTMLElementOffsetWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOffsetWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "offsetWidth");
}

static inline JSValue jsHTMLElementOffsetHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.offsetHeight());
    return result;
}

EncodedJSValue jsHTMLElementOffsetHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOffsetHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "offsetHeight");
}

static inline JSValue jsHTMLElementOuterTextGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.outerText());
    return result;
}

EncodedJSValue jsHTMLElementOuterText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOuterTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "outerText");
}

static inline bool setJSHTMLElementOuterTextSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setOuterText(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementOuterText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOuterTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "outerText");
}

#if ENABLE(AUTOCORRECT)
static inline JSValue jsHTMLElementAutocorrectGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.autocorrect());
    return result;
}

EncodedJSValue jsHTMLElementAutocorrect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementAutocorrectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autocorrect");
}

#endif

#if ENABLE(AUTOCORRECT)
static inline bool setJSHTMLElementAutocorrectSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAutocorrect(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementAutocorrect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementAutocorrectSetter>(*lexicalGlobalObject, thisValue, encodedValue, "autocorrect");
}

#endif

#if ENABLE(AUTOCAPITALIZE)
static inline JSValue jsHTMLElementAutocapitalizeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.autocapitalize());
    return result;
}

EncodedJSValue jsHTMLElementAutocapitalize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementAutocapitalizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autocapitalize");
}

#endif

#if ENABLE(AUTOCAPITALIZE)
static inline bool setJSHTMLElementAutocapitalizeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAutocapitalize(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementAutocapitalize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementAutocapitalizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "autocapitalize");
}

#endif

static inline JSValue jsHTMLElementWebkitdropzoneGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::webkitdropzoneAttr));
    return result;
}

EncodedJSValue jsHTMLElementWebkitdropzone(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementWebkitdropzoneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitdropzone");
}

static inline bool setJSHTMLElementWebkitdropzoneSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::webkitdropzoneAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementWebkitdropzone(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementWebkitdropzoneSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitdropzone");
}

static inline JSValue jsHTMLElementInputModeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.inputMode());
    return result;
}

EncodedJSValue jsHTMLElementInputMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementInputModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "inputMode");
}

static inline bool setJSHTMLElementInputModeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setInputMode(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementInputMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementInputModeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "inputMode");
}

static inline JSValue jsHTMLElementEnterKeyHintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.enterKeyHint());
    return result;
}

EncodedJSValue jsHTMLElementEnterKeyHint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementEnterKeyHintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "enterKeyHint");
}

static inline bool setJSHTMLElementEnterKeyHintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setEnterKeyHint(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementEnterKeyHint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementEnterKeyHintSetter>(*lexicalGlobalObject, thisValue, encodedValue, "enterKeyHint");
}

static inline JSValue jsHTMLElementStyleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<CSSStyleDeclaration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cssomStyle());
    return result;
}

EncodedJSValue jsHTMLElementStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "style");
}

static inline bool setJSHTMLElementStyleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    auto id = Identifier::fromString(vm, reinterpret_cast<const LChar*>("style"), strlen("style"));
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, reinterpret_cast<const LChar*>("cssText"), strlen("cssText"));
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable(vm)->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

bool setJSHTMLElementStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "style");
}

#if ENABLE(CSS_TYPED_OM)
static inline JSValue jsHTMLElementAttributeStyleMapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (JSValue cachedValue = thisObject.m_attributeStyleMap.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<StylePropertyMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureAttributeStyleMap());
    thisObject.m_attributeStyleMap.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

EncodedJSValue jsHTMLElementAttributeStyleMap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementAttributeStyleMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "attributeStyleMap");
}

#endif

static inline JSValue jsHTMLElementOnabortGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onabort");
}

static inline bool setJSHTMLElementOnabortSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().abortEvent, value);
    return true;
}

bool setJSHTMLElementOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onabort");
}

static inline JSValue jsHTMLElementOnblurGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onblur");
}

static inline bool setJSHTMLElementOnblurSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().blurEvent, value);
    return true;
}

bool setJSHTMLElementOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onblur");
}

static inline JSValue jsHTMLElementOncanplayGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().canplayEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOncanplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOncanplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncanplay");
}

static inline bool setJSHTMLElementOncanplaySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().canplayEvent, value);
    return true;
}

bool setJSHTMLElementOncanplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOncanplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncanplay");
}

static inline JSValue jsHTMLElementOncanplaythroughGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().canplaythroughEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOncanplaythrough(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOncanplaythroughGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncanplaythrough");
}

static inline bool setJSHTMLElementOncanplaythroughSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().canplaythroughEvent, value);
    return true;
}

bool setJSHTMLElementOncanplaythrough(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOncanplaythroughSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncanplaythrough");
}

static inline JSValue jsHTMLElementOnchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onchange");
}

static inline bool setJSHTMLElementOnchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().changeEvent, value);
    return true;
}

bool setJSHTMLElementOnchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onchange");
}

static inline JSValue jsHTMLElementOnclickGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().clickEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onclick");
}

static inline bool setJSHTMLElementOnclickSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().clickEvent, value);
    return true;
}

bool setJSHTMLElementOnclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onclick");
}

static inline JSValue jsHTMLElementOncontextmenuGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().contextmenuEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOncontextmenu(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOncontextmenuGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncontextmenu");
}

static inline bool setJSHTMLElementOncontextmenuSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().contextmenuEvent, value);
    return true;
}

bool setJSHTMLElementOncontextmenu(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOncontextmenuSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncontextmenu");
}

static inline JSValue jsHTMLElementOncuechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cuechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOncuechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOncuechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncuechange");
}

static inline bool setJSHTMLElementOncuechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().cuechangeEvent, value);
    return true;
}

bool setJSHTMLElementOncuechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOncuechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncuechange");
}

static inline JSValue jsHTMLElementOndblclickGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dblclickEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndblclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndblclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondblclick");
}

static inline bool setJSHTMLElementOndblclickSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dblclickEvent, value);
    return true;
}

bool setJSHTMLElementOndblclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndblclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondblclick");
}

static inline JSValue jsHTMLElementOndragGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndrag(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndragGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondrag");
}

static inline bool setJSHTMLElementOndragSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragEvent, value);
    return true;
}

bool setJSHTMLElementOndrag(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndragSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondrag");
}

static inline JSValue jsHTMLElementOndragendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndragend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndragendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragend");
}

static inline bool setJSHTMLElementOndragendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragendEvent, value);
    return true;
}

bool setJSHTMLElementOndragend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndragendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragend");
}

static inline JSValue jsHTMLElementOndragenterGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndragenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndragenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragenter");
}

static inline bool setJSHTMLElementOndragenterSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragenterEvent, value);
    return true;
}

bool setJSHTMLElementOndragenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndragenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragenter");
}

static inline JSValue jsHTMLElementOndragleaveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndragleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndragleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragleave");
}

static inline bool setJSHTMLElementOndragleaveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragleaveEvent, value);
    return true;
}

bool setJSHTMLElementOndragleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndragleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragleave");
}

static inline JSValue jsHTMLElementOndragoverGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragoverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndragover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndragoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragover");
}

static inline bool setJSHTMLElementOndragoverSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragoverEvent, value);
    return true;
}

bool setJSHTMLElementOndragover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndragoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragover");
}

static inline JSValue jsHTMLElementOndragstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndragstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndragstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragstart");
}

static inline bool setJSHTMLElementOndragstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragstartEvent, value);
    return true;
}

bool setJSHTMLElementOndragstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndragstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragstart");
}

static inline JSValue jsHTMLElementOndropGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dropEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndrop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndropGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondrop");
}

static inline bool setJSHTMLElementOndropSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dropEvent, value);
    return true;
}

bool setJSHTMLElementOndrop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndropSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondrop");
}

static inline JSValue jsHTMLElementOndurationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().durationchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOndurationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOndurationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondurationchange");
}

static inline bool setJSHTMLElementOndurationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().durationchangeEvent, value);
    return true;
}

bool setJSHTMLElementOndurationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOndurationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondurationchange");
}

static inline JSValue jsHTMLElementOnemptiedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().emptiedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnemptied(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnemptiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onemptied");
}

static inline bool setJSHTMLElementOnemptiedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().emptiedEvent, value);
    return true;
}

bool setJSHTMLElementOnemptied(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnemptiedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onemptied");
}

static inline JSValue jsHTMLElementOnendedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onended");
}

static inline bool setJSHTMLElementOnendedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().endedEvent, value);
    return true;
}

bool setJSHTMLElementOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onended");
}

static inline JSValue jsHTMLElementOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSHTMLElementOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSHTMLElementOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsHTMLElementOnfocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocus");
}

static inline bool setJSHTMLElementOnfocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusEvent, value);
    return true;
}

bool setJSHTMLElementOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocus");
}

static inline JSValue jsHTMLElementOninputGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().inputEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOninput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOninputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oninput");
}

static inline bool setJSHTMLElementOninputSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().inputEvent, value);
    return true;
}

bool setJSHTMLElementOninput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOninputSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oninput");
}

static inline JSValue jsHTMLElementOninvalidGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().invalidEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOninvalid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOninvalidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oninvalid");
}

static inline bool setJSHTMLElementOninvalidSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().invalidEvent, value);
    return true;
}

bool setJSHTMLElementOninvalid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOninvalidSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oninvalid");
}

static inline JSValue jsHTMLElementOnkeydownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keydownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnkeydown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnkeydownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onkeydown");
}

static inline bool setJSHTMLElementOnkeydownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keydownEvent, value);
    return true;
}

bool setJSHTMLElementOnkeydown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnkeydownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeydown");
}

static inline JSValue jsHTMLElementOnkeypressGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keypressEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnkeypress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnkeypressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onkeypress");
}

static inline bool setJSHTMLElementOnkeypressSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keypressEvent, value);
    return true;
}

bool setJSHTMLElementOnkeypress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnkeypressSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeypress");
}

static inline JSValue jsHTMLElementOnkeyupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keyupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnkeyup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnkeyupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onkeyup");
}

static inline bool setJSHTMLElementOnkeyupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keyupEvent, value);
    return true;
}

bool setJSHTMLElementOnkeyup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnkeyupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeyup");
}

static inline JSValue jsHTMLElementOnloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onload");
}

static inline bool setJSHTMLElementOnloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadEvent, value);
    return true;
}

bool setJSHTMLElementOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onload");
}

static inline JSValue jsHTMLElementOnloadeddataGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadeddataEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnloadeddata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnloadeddataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadeddata");
}

static inline bool setJSHTMLElementOnloadeddataSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadeddataEvent, value);
    return true;
}

bool setJSHTMLElementOnloadeddata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnloadeddataSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadeddata");
}

static inline JSValue jsHTMLElementOnloadedmetadataGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadedmetadataEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnloadedmetadata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnloadedmetadataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadedmetadata");
}

static inline bool setJSHTMLElementOnloadedmetadataSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadedmetadataEvent, value);
    return true;
}

bool setJSHTMLElementOnloadedmetadata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnloadedmetadataSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadedmetadata");
}

static inline JSValue jsHTMLElementOnloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnloadstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnloadstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadstart");
}

static inline bool setJSHTMLElementOnloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadstartEvent, value);
    return true;
}

bool setJSHTMLElementOnloadstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadstart");
}

static inline JSValue jsHTMLElementOnmousedownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousedownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnmousedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnmousedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmousedown");
}

static inline bool setJSHTMLElementOnmousedownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousedownEvent, value);
    return true;
}

bool setJSHTMLElementOnmousedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnmousedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousedown");
}

static inline JSValue jsHTMLElementOnmouseenterGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnmouseenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnmouseenterGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, "onmouseenter");
}

static inline bool setJSHTMLElementOnmouseenterSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseenterEvent, value);
    return true;
}

bool setJSHTMLElementOnmouseenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnmouseenterSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseenter");
}

static inline JSValue jsHTMLElementOnmouseleaveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnmouseleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnmouseleaveGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, "onmouseleave");
}

static inline bool setJSHTMLElementOnmouseleaveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseleaveEvent, value);
    return true;
}

bool setJSHTMLElementOnmouseleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnmouseleaveSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseleave");
}

static inline JSValue jsHTMLElementOnmousemoveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousemoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnmousemove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnmousemoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmousemove");
}

static inline bool setJSHTMLElementOnmousemoveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousemoveEvent, value);
    return true;
}

bool setJSHTMLElementOnmousemove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnmousemoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousemove");
}

static inline JSValue jsHTMLElementOnmouseoutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseoutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnmouseout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnmouseoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmouseout");
}

static inline bool setJSHTMLElementOnmouseoutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseoutEvent, value);
    return true;
}

bool setJSHTMLElementOnmouseout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnmouseoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseout");
}

static inline JSValue jsHTMLElementOnmouseoverGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseoverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnmouseover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnmouseoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmouseover");
}

static inline bool setJSHTMLElementOnmouseoverSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseoverEvent, value);
    return true;
}

bool setJSHTMLElementOnmouseover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnmouseoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseover");
}

static inline JSValue jsHTMLElementOnmouseupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnmouseup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnmouseupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmouseup");
}

static inline bool setJSHTMLElementOnmouseupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseupEvent, value);
    return true;
}

bool setJSHTMLElementOnmouseup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnmouseupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseup");
}

static inline JSValue jsHTMLElementOnmousewheelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousewheelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnmousewheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnmousewheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmousewheel");
}

static inline bool setJSHTMLElementOnmousewheelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousewheelEvent, value);
    return true;
}

bool setJSHTMLElementOnmousewheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnmousewheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousewheel");
}

static inline JSValue jsHTMLElementOnpauseGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpause(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpauseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpause");
}

static inline bool setJSHTMLElementOnpauseSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pauseEvent, value);
    return true;
}

bool setJSHTMLElementOnpause(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpause");
}

static inline JSValue jsHTMLElementOnplayGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().playEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onplay");
}

static inline bool setJSHTMLElementOnplaySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().playEvent, value);
    return true;
}

bool setJSHTMLElementOnplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onplay");
}

static inline JSValue jsHTMLElementOnplayingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().playingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnplaying(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnplayingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onplaying");
}

static inline bool setJSHTMLElementOnplayingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().playingEvent, value);
    return true;
}

bool setJSHTMLElementOnplaying(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnplayingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onplaying");
}

static inline JSValue jsHTMLElementOnprogressGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onprogress");
}

static inline bool setJSHTMLElementOnprogressSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().progressEvent, value);
    return true;
}

bool setJSHTMLElementOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onprogress");
}

static inline JSValue jsHTMLElementOnratechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().ratechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnratechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnratechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onratechange");
}

static inline bool setJSHTMLElementOnratechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().ratechangeEvent, value);
    return true;
}

bool setJSHTMLElementOnratechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnratechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onratechange");
}

static inline JSValue jsHTMLElementOnrejectionhandledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().rejectionhandledEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnrejectionhandled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnrejectionhandledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onrejectionhandled");
}

static inline bool setJSHTMLElementOnrejectionhandledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().rejectionhandledEvent, value);
    return true;
}

bool setJSHTMLElementOnrejectionhandled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnrejectionhandledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onrejectionhandled");
}

static inline JSValue jsHTMLElementOnresetGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resetEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnreset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnresetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onreset");
}

static inline bool setJSHTMLElementOnresetSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resetEvent, value);
    return true;
}

bool setJSHTMLElementOnreset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnresetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onreset");
}

static inline JSValue jsHTMLElementOnresizeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onresize");
}

static inline bool setJSHTMLElementOnresizeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resizeEvent, value);
    return true;
}

bool setJSHTMLElementOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onresize");
}

static inline JSValue jsHTMLElementOnscrollGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onscroll");
}

static inline bool setJSHTMLElementOnscrollSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().scrollEvent, value);
    return true;
}

bool setJSHTMLElementOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onscroll");
}

static inline JSValue jsHTMLElementOnseekedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().seekedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnseeked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnseekedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onseeked");
}

static inline bool setJSHTMLElementOnseekedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().seekedEvent, value);
    return true;
}

bool setJSHTMLElementOnseeked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnseekedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onseeked");
}

static inline JSValue jsHTMLElementOnseekingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().seekingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnseeking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnseekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onseeking");
}

static inline bool setJSHTMLElementOnseekingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().seekingEvent, value);
    return true;
}

bool setJSHTMLElementOnseeking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnseekingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onseeking");
}

static inline JSValue jsHTMLElementOnselectGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnselect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnselectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onselect");
}

static inline bool setJSHTMLElementOnselectSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().selectEvent, value);
    return true;
}

bool setJSHTMLElementOnselect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnselectSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onselect");
}

static inline JSValue jsHTMLElementOnstalledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().stalledEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnstalled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnstalledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onstalled");
}

static inline bool setJSHTMLElementOnstalledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().stalledEvent, value);
    return true;
}

bool setJSHTMLElementOnstalled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnstalledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstalled");
}

static inline JSValue jsHTMLElementOnsubmitGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().submitEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnsubmit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnsubmitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsubmit");
}

static inline bool setJSHTMLElementOnsubmitSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().submitEvent, value);
    return true;
}

bool setJSHTMLElementOnsubmit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnsubmitSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsubmit");
}

static inline JSValue jsHTMLElementOnsuspendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().suspendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnsuspend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnsuspendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsuspend");
}

static inline bool setJSHTMLElementOnsuspendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().suspendEvent, value);
    return true;
}

bool setJSHTMLElementOnsuspend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnsuspendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsuspend");
}

static inline JSValue jsHTMLElementOntimeupdateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().timeupdateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntimeupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntimeupdateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontimeupdate");
}

static inline bool setJSHTMLElementOntimeupdateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().timeupdateEvent, value);
    return true;
}

bool setJSHTMLElementOntimeupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntimeupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontimeupdate");
}

static inline JSValue jsHTMLElementOntoggleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().toggleEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntoggle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontoggle");
}

static inline bool setJSHTMLElementOntoggleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().toggleEvent, value);
    return true;
}

bool setJSHTMLElementOntoggle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontoggle");
}

static inline JSValue jsHTMLElementOnunhandledrejectionGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().unhandledrejectionEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnunhandledrejection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnunhandledrejectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onunhandledrejection");
}

static inline bool setJSHTMLElementOnunhandledrejectionSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().unhandledrejectionEvent, value);
    return true;
}

bool setJSHTMLElementOnunhandledrejection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnunhandledrejectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onunhandledrejection");
}

static inline JSValue jsHTMLElementOnvolumechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().volumechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnvolumechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnvolumechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onvolumechange");
}

static inline bool setJSHTMLElementOnvolumechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().volumechangeEvent, value);
    return true;
}

bool setJSHTMLElementOnvolumechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnvolumechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onvolumechange");
}

static inline JSValue jsHTMLElementOnwaitingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().waitingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnwaiting(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnwaitingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwaiting");
}

static inline bool setJSHTMLElementOnwaitingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().waitingEvent, value);
    return true;
}

bool setJSHTMLElementOnwaiting(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnwaitingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwaiting");
}

static inline JSValue jsHTMLElementOntransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontransitionend");
}

static inline bool setJSHTMLElementOntransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionendEvent, value);
    return true;
}

bool setJSHTMLElementOntransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionend");
}

static inline JSValue jsHTMLElementOntransitionrunGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionrunEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntransitionrun(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntransitionrunGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontransitionrun");
}

static inline bool setJSHTMLElementOntransitionrunSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionrunEvent, value);
    return true;
}

bool setJSHTMLElementOntransitionrun(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntransitionrunSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionrun");
}

static inline JSValue jsHTMLElementOntransitionstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntransitionstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntransitionstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontransitionstart");
}

static inline bool setJSHTMLElementOntransitionstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionstartEvent, value);
    return true;
}

bool setJSHTMLElementOntransitionstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntransitionstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionstart");
}

static inline JSValue jsHTMLElementOntransitioncancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitioncancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntransitioncancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntransitioncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontransitioncancel");
}

static inline bool setJSHTMLElementOntransitioncancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitioncancelEvent, value);
    return true;
}

bool setJSHTMLElementOntransitioncancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntransitioncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitioncancel");
}

static inline JSValue jsHTMLElementOnanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onanimationend");
}

static inline bool setJSHTMLElementOnanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationendEvent, value);
    return true;
}

bool setJSHTMLElementOnanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationend");
}

static inline JSValue jsHTMLElementOnanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationiterationEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onanimationiteration");
}

static inline bool setJSHTMLElementOnanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationiterationEvent, value);
    return true;
}

bool setJSHTMLElementOnanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationiteration");
}

static inline JSValue jsHTMLElementOnanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onanimationstart");
}

static inline bool setJSHTMLElementOnanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationstartEvent, value);
    return true;
}

bool setJSHTMLElementOnanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationstart");
}

static inline JSValue jsHTMLElementOnanimationcancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationcancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnanimationcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnanimationcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onanimationcancel");
}

static inline bool setJSHTMLElementOnanimationcancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationcancelEvent, value);
    return true;
}

bool setJSHTMLElementOnanimationcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnanimationcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationcancel");
}

static inline JSValue jsHTMLElementOngotpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gotpointercaptureEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOngotpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOngotpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ongotpointercapture");
}

static inline bool setJSHTMLElementOngotpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gotpointercaptureEvent, value);
    return true;
}

bool setJSHTMLElementOngotpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOngotpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongotpointercapture");
}

static inline JSValue jsHTMLElementOnlostpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().lostpointercaptureEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnlostpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnlostpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onlostpointercapture");
}

static inline bool setJSHTMLElementOnlostpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().lostpointercaptureEvent, value);
    return true;
}

bool setJSHTMLElementOnlostpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnlostpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onlostpointercapture");
}

static inline JSValue jsHTMLElementOnpointerdownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerdownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpointerdown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpointerdownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerdown");
}

static inline bool setJSHTMLElementOnpointerdownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerdownEvent, value);
    return true;
}

bool setJSHTMLElementOnpointerdown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpointerdownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerdown");
}

static inline JSValue jsHTMLElementOnpointermoveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointermoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpointermove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpointermoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointermove");
}

static inline bool setJSHTMLElementOnpointermoveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointermoveEvent, value);
    return true;
}

bool setJSHTMLElementOnpointermove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpointermoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointermove");
}

static inline JSValue jsHTMLElementOnpointerupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpointerup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpointerupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerup");
}

static inline bool setJSHTMLElementOnpointerupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerupEvent, value);
    return true;
}

bool setJSHTMLElementOnpointerup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpointerupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerup");
}

static inline JSValue jsHTMLElementOnpointercancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointercancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpointercancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpointercancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointercancel");
}

static inline bool setJSHTMLElementOnpointercancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointercancelEvent, value);
    return true;
}

bool setJSHTMLElementOnpointercancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpointercancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointercancel");
}

static inline JSValue jsHTMLElementOnpointeroverGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointeroverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpointerover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpointeroverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerover");
}

static inline bool setJSHTMLElementOnpointeroverSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointeroverEvent, value);
    return true;
}

bool setJSHTMLElementOnpointerover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpointeroverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerover");
}

static inline JSValue jsHTMLElementOnpointeroutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointeroutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpointerout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpointeroutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerout");
}

static inline bool setJSHTMLElementOnpointeroutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointeroutEvent, value);
    return true;
}

bool setJSHTMLElementOnpointerout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpointeroutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerout");
}

static inline JSValue jsHTMLElementOnpointerenterGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpointerenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpointerenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerenter");
}

static inline bool setJSHTMLElementOnpointerenterSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerenterEvent, value);
    return true;
}

bool setJSHTMLElementOnpointerenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpointerenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerenter");
}

static inline JSValue jsHTMLElementOnpointerleaveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnpointerleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnpointerleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerleave");
}

static inline bool setJSHTMLElementOnpointerleaveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerleaveEvent, value);
    return true;
}

bool setJSHTMLElementOnpointerleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnpointerleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerleave");
}

static inline JSValue jsHTMLElementOnsearchGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().searchEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnsearch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnsearchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsearch");
}

static inline bool setJSHTMLElementOnsearchSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().searchEvent, value);
    return true;
}

bool setJSHTMLElementOnsearch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnsearchSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsearch");
}

static inline JSValue jsHTMLElementOnwheelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().wheelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnwheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnwheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwheel");
}

static inline bool setJSHTMLElementOnwheelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().wheelEvent, value);
    return true;
}

bool setJSHTMLElementOnwheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnwheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwheel");
}

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElementOntouchcancelGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchcancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntouchcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntouchcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchcancel");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElementOntouchcancelSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchcancelEvent, value);
    return true;
}

bool setJSHTMLElementOntouchcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntouchcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchcancel");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElementOntouchendGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntouchend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntouchendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchend");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElementOntouchendSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchendEvent, value);
    return true;
}

bool setJSHTMLElementOntouchend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntouchendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchend");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElementOntouchmoveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchmoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntouchmove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntouchmoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchmove");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElementOntouchmoveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchmoveEvent, value);
    return true;
}

bool setJSHTMLElementOntouchmove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntouchmoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchmove");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElementOntouchstartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntouchstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntouchstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchstart");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElementOntouchstartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchstartEvent, value);
    return true;
}

bool setJSHTMLElementOntouchstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntouchstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchstart");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsHTMLElementOntouchforcechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchforcechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOntouchforcechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOntouchforcechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchforcechange");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSHTMLElementOntouchforcechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchforcechangeEvent, value);
    return true;
}

bool setJSHTMLElementOntouchforcechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOntouchforcechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchforcechange");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsHTMLElementOnwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnwebkitmouseforcechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnwebkitmouseforcechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcechanged");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSHTMLElementOnwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, value);
    return true;
}

bool setJSHTMLElementOnwebkitmouseforcechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcechanged");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsHTMLElementOnwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnwebkitmouseforcedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnwebkitmouseforcedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcedown");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSHTMLElementOnwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, value);
    return true;
}

bool setJSHTMLElementOnwebkitmouseforcedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcedown");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsHTMLElementOnwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnwebkitmouseforcewillbegin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnwebkitmouseforcewillbeginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcewillbegin");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSHTMLElementOnwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, value);
    return true;
}

bool setJSHTMLElementOnwebkitmouseforcewillbegin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcewillbegin");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsHTMLElementOnwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLElementOnwebkitmouseforceup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementOnwebkitmouseforceupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforceup");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSHTMLElementOnwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforceupEvent, value);
    return true;
}

bool setJSHTMLElementOnwebkitmouseforceup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementOnwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforceup");
}

#endif

static inline JSValue jsHTMLElementDatasetGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMStringMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.dataset());
    return result;
}

EncodedJSValue jsHTMLElementDataset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementDatasetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dataset");
}

static inline JSValue jsHTMLElementTabIndexGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tabIndexForBindings());
    return result;
}

EncodedJSValue jsHTMLElementTabIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLElement>::get<jsHTMLElementTabIndexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tabIndex");
}

static inline bool setJSHTMLElementTabIndexSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTabIndexForBindings(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLElementTabIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLElement>::set<setJSHTMLElementTabIndexSetter>(*lexicalGlobalObject, thisValue, encodedValue, "tabIndex");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunctionClickBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.click();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionClick(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunctionClickBody>(*lexicalGlobalObject, *callFrame, "click");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunctionFocusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.focus();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionFocus(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunctionFocusBody>(*lexicalGlobalObject, *callFrame, "focus");
}

static inline JSC::EncodedJSValue jsHTMLElementPrototypeFunctionBlurBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.blur();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionBlur(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLElement>::call<jsHTMLElementPrototypeFunctionBlurBody>(*lexicalGlobalObject, *callFrame, "blur");
}

void JSHTMLElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
#if ENABLE(CSS_TYPED_OM)
    visitor.append(thisObject->m_attributeStyleMap);
#endif
}

void JSHTMLElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

HTMLElement* JSHTMLElement::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLElement*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
