/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFrameSetElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "EventNames.h"
#include "HTMLNames.h"
#include "JSDOMAbstractOperations.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsHTMLFrameSetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementCols(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementCols(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementRows(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementRows(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnfocusin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnfocusin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnfocusout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnfocusout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnafterprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnafterprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnbeforeprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnbeforeprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnbeforeunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnbeforeunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnhashchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnhashchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnlanguagechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnlanguagechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnoffline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnoffline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnonline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnonline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnpagehide(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnpagehide(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnpageshow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnpageshow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnpopstate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnpopstate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnstorage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnstorage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLFrameSetElementOnunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(ORIENTATION_EVENTS)
JSC::EncodedJSValue jsHTMLFrameSetElementOnorientationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLFrameSetElementOnorientationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif

class JSHTMLFrameSetElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLFrameSetElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLFrameSetElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLFrameSetElementPrototype>(vm.heap)) JSHTMLFrameSetElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLFrameSetElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLFrameSetElementPrototype, JSHTMLFrameSetElementPrototype::Base);

using JSHTMLFrameSetElementConstructor = JSDOMConstructorNotConstructable<JSHTMLFrameSetElement>;

template<> JSValue JSHTMLFrameSetElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLFrameSetElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLFrameSetElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLFrameSetElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLFrameSetElementConstructor::s_info = { "HTMLFrameSetElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLFrameSetElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLFrameSetElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementConstructor) } },
    { "cols", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementCols), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementCols) } },
    { "rows", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementRows), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementRows) } },
    { "onblur", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnblur) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnerror) } },
    { "onfocus", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnfocus) } },
    { "onfocusin", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnfocusin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnfocusin) } },
    { "onfocusout", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnfocusout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnfocusout) } },
    { "onload", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnload) } },
    { "onresize", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnresize) } },
    { "onscroll", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnscroll) } },
    { "onafterprint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnafterprint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnafterprint) } },
    { "onbeforeprint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnbeforeprint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnbeforeprint) } },
    { "onbeforeunload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnbeforeunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnbeforeunload) } },
    { "onhashchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnhashchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnhashchange) } },
    { "onlanguagechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnlanguagechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnlanguagechange) } },
    { "onmessage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnmessage) } },
    { "onoffline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnoffline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnoffline) } },
    { "ononline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnonline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnonline) } },
    { "onpagehide", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnpagehide), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnpagehide) } },
    { "onpageshow", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnpageshow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnpageshow) } },
    { "onpopstate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnpopstate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnpopstate) } },
    { "onstorage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnstorage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnstorage) } },
    { "onunload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnunload) } },
#if ENABLE(ORIENTATION_EVENTS)
    { "onorientationchange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameSetElementOnorientationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLFrameSetElementOnorientationchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSHTMLFrameSetElementPrototype::s_info = { "HTMLFrameSetElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLFrameSetElementPrototype) };

void JSHTMLFrameSetElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLFrameSetElement::info(), JSHTMLFrameSetElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLFrameSetElement::s_info = { "HTMLFrameSetElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLFrameSetElement) };

JSHTMLFrameSetElement::JSHTMLFrameSetElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLFrameSetElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLFrameSetElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLFrameSetElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLFrameSetElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLFrameSetElementPrototype::create(vm, &globalObject, JSHTMLFrameSetElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLFrameSetElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLFrameSetElement>(vm, globalObject);
}

JSValue JSHTMLFrameSetElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFrameSetElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSHTMLFrameSetElement::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    using GetterIDLType = IDLInterface<WindowProxy>;
    auto getterFunctor = [] (auto& thisObject, auto propertyName) -> Optional<typename GetterIDLType::ImplementationType> {
        auto result = thisObject.wrapped().namedItem(propertyNameToAtomString(propertyName));
        if (!GetterIDLType::isNullValue(result))
            return typename GetterIDLType::ImplementationType { GetterIDLType::extractValueFromNullable(result) };
        return WTF::nullopt;
    };
    if (auto namedProperty = accessVisibleNamedProperty<OverrideBuiltins::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLInterface<WindowProxy>>(*lexicalGlobalObject, *thisObject->globalObject(), WTFMove(namedProperty.value()));
        slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
        return true;
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSHTMLFrameSetElement::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    auto propertyName = Identifier::from(vm, index);
    using GetterIDLType = IDLInterface<WindowProxy>;
    auto getterFunctor = [] (auto& thisObject, auto propertyName) -> Optional<typename GetterIDLType::ImplementationType> {
        auto result = thisObject.wrapped().namedItem(propertyNameToAtomString(propertyName));
        if (!GetterIDLType::isNullValue(result))
            return typename GetterIDLType::ImplementationType { GetterIDLType::extractValueFromNullable(result) };
        return WTF::nullopt;
    };
    if (auto namedProperty = accessVisibleNamedProperty<OverrideBuiltins::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLInterface<WindowProxy>>(*lexicalGlobalObject, *thisObject->globalObject(), WTFMove(namedProperty.value()));
        slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
        return true;
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSHTMLFrameSetElement::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (auto& propertyName : thisObject->wrapped().supportedPropertyNames())
        propertyNames.add(Identifier::fromString(vm, propertyName));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

template<> inline JSHTMLFrameSetElement* IDLAttribute<JSHTMLFrameSetElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLFrameSetElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsHTMLFrameSetElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLFrameSetElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLFrameSetElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLFrameSetElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLFrameSetElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLFrameSetElementColsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::colsAttr));
    return result;
}

EncodedJSValue jsHTMLFrameSetElementCols(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementColsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "cols");
}

static inline bool setJSHTMLFrameSetElementColsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::colsAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLFrameSetElementCols(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementColsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "cols");
}

static inline JSValue jsHTMLFrameSetElementRowsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::rowsAttr));
    return result;
}

EncodedJSValue jsHTMLFrameSetElementRows(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementRowsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rows");
}

static inline bool setJSHTMLFrameSetElementRowsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::rowsAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLFrameSetElementRows(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementRowsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "rows");
}

static inline JSValue jsHTMLFrameSetElementOnblurGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onblur");
}

static inline bool setJSHTMLFrameSetElementOnblurSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().blurEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onblur");
}

static inline JSValue jsHTMLFrameSetElementOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSHTMLFrameSetElementOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsHTMLFrameSetElementOnfocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocus");
}

static inline bool setJSHTMLFrameSetElementOnfocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocus");
}

static inline JSValue jsHTMLFrameSetElementOnfocusinGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusinEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnfocusin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnfocusinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocusin");
}

static inline bool setJSHTMLFrameSetElementOnfocusinSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusinEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnfocusin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnfocusinSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocusin");
}

static inline JSValue jsHTMLFrameSetElementOnfocusoutGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().focusoutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnfocusout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnfocusoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocusout");
}

static inline bool setJSHTMLFrameSetElementOnfocusoutSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusoutEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnfocusout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnfocusoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocusout");
}

static inline JSValue jsHTMLFrameSetElementOnloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onload");
}

static inline bool setJSHTMLFrameSetElementOnloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onload");
}

static inline JSValue jsHTMLFrameSetElementOnresizeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onresize");
}

static inline bool setJSHTMLFrameSetElementOnresizeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resizeEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onresize");
}

static inline JSValue jsHTMLFrameSetElementOnscrollGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onscroll");
}

static inline bool setJSHTMLFrameSetElementOnscrollSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().scrollEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onscroll");
}

static inline JSValue jsHTMLFrameSetElementOnafterprintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().afterprintEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnafterprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnafterprintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onafterprint");
}

static inline bool setJSHTMLFrameSetElementOnafterprintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().afterprintEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnafterprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnafterprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onafterprint");
}

static inline JSValue jsHTMLFrameSetElementOnbeforeprintGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().beforeprintEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnbeforeprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnbeforeprintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforeprint");
}

static inline bool setJSHTMLFrameSetElementOnbeforeprintSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeprintEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnbeforeprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnbeforeprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeprint");
}

static inline JSValue jsHTMLFrameSetElementOnbeforeunloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().beforeunloadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnbeforeunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnbeforeunloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforeunload");
}

static inline bool setJSHTMLFrameSetElementOnbeforeunloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeunloadEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnbeforeunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnbeforeunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeunload");
}

static inline JSValue jsHTMLFrameSetElementOnhashchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().hashchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnhashchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnhashchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onhashchange");
}

static inline bool setJSHTMLFrameSetElementOnhashchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().hashchangeEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnhashchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnhashchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onhashchange");
}

static inline JSValue jsHTMLFrameSetElementOnlanguagechangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().languagechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnlanguagechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnlanguagechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onlanguagechange");
}

static inline bool setJSHTMLFrameSetElementOnlanguagechangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().languagechangeEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnlanguagechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnlanguagechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onlanguagechange");
}

static inline JSValue jsHTMLFrameSetElementOnmessageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnmessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmessage");
}

static inline bool setJSHTMLFrameSetElementOnmessageSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessage");
}

static inline JSValue jsHTMLFrameSetElementOnofflineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().offlineEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnoffline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnofflineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onoffline");
}

static inline bool setJSHTMLFrameSetElementOnofflineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().offlineEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnoffline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnofflineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onoffline");
}

static inline JSValue jsHTMLFrameSetElementOnonlineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().onlineEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnonline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnonlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ononline");
}

static inline bool setJSHTMLFrameSetElementOnonlineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().onlineEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnonline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnonlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ononline");
}

static inline JSValue jsHTMLFrameSetElementOnpagehideGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().pagehideEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnpagehide(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnpagehideGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpagehide");
}

static inline bool setJSHTMLFrameSetElementOnpagehideSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pagehideEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnpagehide(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnpagehideSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpagehide");
}

static inline JSValue jsHTMLFrameSetElementOnpageshowGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().pageshowEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnpageshow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnpageshowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpageshow");
}

static inline bool setJSHTMLFrameSetElementOnpageshowSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pageshowEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnpageshow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnpageshowSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpageshow");
}

static inline JSValue jsHTMLFrameSetElementOnpopstateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().popstateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnpopstate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnpopstateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpopstate");
}

static inline bool setJSHTMLFrameSetElementOnpopstateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().popstateEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnpopstate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnpopstateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpopstate");
}

static inline JSValue jsHTMLFrameSetElementOnstorageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().storageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnstorage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnstorageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onstorage");
}

static inline bool setJSHTMLFrameSetElementOnstorageSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().storageEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnstorage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnstorageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstorage");
}

static inline JSValue jsHTMLFrameSetElementOnunloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().unloadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnunloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onunload");
}

static inline bool setJSHTMLFrameSetElementOnunloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().unloadEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onunload");
}

#if ENABLE(ORIENTATION_EVENTS)
static inline JSValue jsHTMLFrameSetElementOnorientationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().orientationchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLFrameSetElementOnorientationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLFrameSetElement>::get<jsHTMLFrameSetElementOnorientationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onorientationchange");
}

#endif

#if ENABLE(ORIENTATION_EVENTS)
static inline bool setJSHTMLFrameSetElementOnorientationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLFrameSetElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().orientationchangeEvent, value);
    return true;
}

bool setJSHTMLFrameSetElementOnorientationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLFrameSetElement>::set<setJSHTMLFrameSetElementOnorientationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onorientationchange");
}

#endif

void JSHTMLFrameSetElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLFrameSetElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
