/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLHtmlElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsHTMLHtmlElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLHtmlElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLHtmlElementVersion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLHtmlElementVersion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLHtmlElementManifest(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLHtmlElementManifest(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLHtmlElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLHtmlElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLHtmlElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLHtmlElementPrototype>(vm.heap)) JSHTMLHtmlElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLHtmlElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLHtmlElementPrototype, JSHTMLHtmlElementPrototype::Base);

using JSHTMLHtmlElementConstructor = JSDOMConstructorNotConstructable<JSHTMLHtmlElement>;

template<> JSValue JSHTMLHtmlElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLHtmlElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLHtmlElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLHtmlElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLHtmlElementConstructor::s_info = { "HTMLHtmlElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLHtmlElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLHtmlElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLHtmlElementConstructor) } },
    { "version", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementVersion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLHtmlElementVersion) } },
    { "manifest", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementManifest), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLHtmlElementManifest) } },
};

const ClassInfo JSHTMLHtmlElementPrototype::s_info = { "HTMLHtmlElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLHtmlElementPrototype) };

void JSHTMLHtmlElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLHtmlElement::info(), JSHTMLHtmlElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLHtmlElement::s_info = { "HTMLHtmlElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLHtmlElement) };

JSHTMLHtmlElement::JSHTMLHtmlElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLHtmlElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLHtmlElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLHtmlElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLHtmlElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLHtmlElementPrototype::create(vm, &globalObject, JSHTMLHtmlElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLHtmlElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLHtmlElement>(vm, globalObject);
}

JSValue JSHTMLHtmlElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLHtmlElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLHtmlElement* IDLAttribute<JSHTMLHtmlElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLHtmlElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsHTMLHtmlElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLHtmlElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLHtmlElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLHtmlElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLHtmlElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLHtmlElementVersionGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLHtmlElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::versionAttr));
    return result;
}

EncodedJSValue jsHTMLHtmlElementVersion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLHtmlElement>::get<jsHTMLHtmlElementVersionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "version");
}

static inline bool setJSHTMLHtmlElementVersionSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLHtmlElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::versionAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLHtmlElementVersion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLHtmlElement>::set<setJSHTMLHtmlElementVersionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "version");
}

static inline JSValue jsHTMLHtmlElementManifestGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLHtmlElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.getURLAttribute(WebCore::HTMLNames::manifestAttr));
    return result;
}

EncodedJSValue jsHTMLHtmlElementManifest(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLHtmlElement>::get<jsHTMLHtmlElementManifestGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "manifest");
}

static inline bool setJSHTMLHtmlElementManifestSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLHtmlElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::manifestAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLHtmlElementManifest(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLHtmlElement>::set<setJSHTMLHtmlElementManifestSetter>(*lexicalGlobalObject, thisValue, encodedValue, "manifest");
}

void JSHTMLHtmlElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLHtmlElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
