/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLIFrameElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMBindingSecurity.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMTokenList.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSWindowProxy.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLIFrameElementPrototypeFunctionGetSVGDocument(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsHTMLIFrameElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementFrameBorder(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementFrameBorder(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementLongDesc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementLongDesc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementMarginHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementMarginHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementMarginWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementMarginWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementSandbox(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementSandbox(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementAllowFullscreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementAllowFullscreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementAllow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementAllow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementScrolling(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementScrolling(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementSrc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementSrc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementSrcdoc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementSrcdoc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLIFrameElementContentDocument(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLIFrameElementContentWindow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLIFrameElementReferrerPolicy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLIFrameElementReferrerPolicy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLIFrameElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLIFrameElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLIFrameElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLIFrameElementPrototype>(vm.heap)) JSHTMLIFrameElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLIFrameElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLIFrameElementPrototype, JSHTMLIFrameElementPrototype::Base);

using JSHTMLIFrameElementConstructor = JSDOMConstructorNotConstructable<JSHTMLIFrameElement>;

template<> JSValue JSHTMLIFrameElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLIFrameElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLIFrameElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLIFrameElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLIFrameElementConstructor::s_info = { "HTMLIFrameElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLIFrameElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLIFrameElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementConstructor) } },
    { "align", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementAlign) } },
    { "frameBorder", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementFrameBorder), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementFrameBorder) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementHeight) } },
    { "longDesc", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementLongDesc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementLongDesc) } },
    { "marginHeight", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementMarginHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementMarginHeight) } },
    { "marginWidth", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementMarginWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementMarginWidth) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementName) } },
    { "sandbox", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementSandbox), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementSandbox) } },
    { "allowFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementAllowFullscreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementAllowFullscreen) } },
    { "allow", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementAllow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementAllow) } },
    { "scrolling", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementScrolling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementScrolling) } },
    { "src", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementSrc) } },
    { "srcdoc", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementSrcdoc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementSrcdoc) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementWidth) } },
    { "contentDocument", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementContentDocument), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "contentWindow", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementContentWindow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referrerPolicy", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLIFrameElementReferrerPolicy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLIFrameElementReferrerPolicy) } },
    { "getSVGDocument", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLIFrameElementPrototypeFunctionGetSVGDocument), (intptr_t) (0) } },
};

const ClassInfo JSHTMLIFrameElementPrototype::s_info = { "HTMLIFrameElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLIFrameElementPrototype) };

void JSHTMLIFrameElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLIFrameElement::info(), JSHTMLIFrameElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().referrerPolicyAttributeEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("referrerPolicy"), strlen("referrerPolicy"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLIFrameElement::s_info = { "HTMLIFrameElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLIFrameElement) };

JSHTMLIFrameElement::JSHTMLIFrameElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLIFrameElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLIFrameElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLIFrameElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLIFrameElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLIFrameElementPrototype::create(vm, &globalObject, JSHTMLIFrameElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLIFrameElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLIFrameElement>(vm, globalObject);
}

JSValue JSHTMLIFrameElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLIFrameElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLIFrameElement* IDLAttribute<JSHTMLIFrameElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLIFrameElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLIFrameElement* IDLOperation<JSHTMLIFrameElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLIFrameElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLIFrameElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLIFrameElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLIFrameElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLIFrameElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLIFrameElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLIFrameElementAlignGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::alignAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementAlignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "align");
}

static inline bool setJSHTMLIFrameElementAlignSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alignAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementAlignSetter>(*lexicalGlobalObject, thisValue, encodedValue, "align");
}

static inline JSValue jsHTMLIFrameElementFrameBorderGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::frameborderAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementFrameBorder(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementFrameBorderGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "frameBorder");
}

static inline bool setJSHTMLIFrameElementFrameBorderSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::frameborderAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementFrameBorder(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementFrameBorderSetter>(*lexicalGlobalObject, thisValue, encodedValue, "frameBorder");
}

static inline JSValue jsHTMLIFrameElementHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::heightAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline bool setJSHTMLIFrameElementHeightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::heightAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "height");
}

static inline JSValue jsHTMLIFrameElementLongDescGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.getURLAttribute(WebCore::HTMLNames::longdescAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementLongDesc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementLongDescGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "longDesc");
}

static inline bool setJSHTMLIFrameElementLongDescSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::longdescAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementLongDesc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementLongDescSetter>(*lexicalGlobalObject, thisValue, encodedValue, "longDesc");
}

static inline JSValue jsHTMLIFrameElementMarginHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::marginheightAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementMarginHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementMarginHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "marginHeight");
}

static inline bool setJSHTMLIFrameElementMarginHeightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::marginheightAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementMarginHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementMarginHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "marginHeight");
}

static inline JSValue jsHTMLIFrameElementMarginWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::marginwidthAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementMarginWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementMarginWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "marginWidth");
}

static inline bool setJSHTMLIFrameElementMarginWidthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::marginwidthAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementMarginWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementMarginWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "marginWidth");
}

static inline JSValue jsHTMLIFrameElementNameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.getNameAttribute());
    return result;
}

EncodedJSValue jsHTMLIFrameElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSHTMLIFrameElementNameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsHTMLIFrameElementSandboxGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMTokenList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sandbox());
    return result;
}

EncodedJSValue jsHTMLIFrameElementSandbox(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementSandboxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sandbox");
}

static inline bool setJSHTMLIFrameElementSandboxSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    auto id = Identifier::fromString(vm, reinterpret_cast<const LChar*>("sandbox"), strlen("sandbox"));
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, reinterpret_cast<const LChar*>("value"), strlen("value"));
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable(vm)->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

bool setJSHTMLIFrameElementSandbox(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementSandboxSetter>(*lexicalGlobalObject, thisValue, encodedValue, "sandbox");
}

static inline JSValue jsHTMLIFrameElementAllowFullscreenGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::allowfullscreenAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementAllowFullscreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementAllowFullscreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "allowFullscreen");
}

static inline bool setJSHTMLIFrameElementAllowFullscreenSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::allowfullscreenAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementAllowFullscreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementAllowFullscreenSetter>(*lexicalGlobalObject, thisValue, encodedValue, "allowFullscreen");
}

static inline JSValue jsHTMLIFrameElementAllowGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::allowAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementAllow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementAllowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "allow");
}

static inline bool setJSHTMLIFrameElementAllowSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::allowAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementAllow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementAllowSetter>(*lexicalGlobalObject, thisValue, encodedValue, "allow");
}

static inline JSValue jsHTMLIFrameElementScrollingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::scrollingAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementScrolling(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementScrollingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scrolling");
}

static inline bool setJSHTMLIFrameElementScrollingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::scrollingAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementScrolling(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementScrollingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "scrolling");
}

static inline JSValue jsHTMLIFrameElementSrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementSrc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementSrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "src");
}

static inline bool setJSHTMLIFrameElementSrcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementSrc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementSrcSetter>(*lexicalGlobalObject, thisValue, encodedValue, "src");
}

static inline JSValue jsHTMLIFrameElementSrcdocGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::srcdocAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementSrcdoc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementSrcdocGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "srcdoc");
}

static inline bool setJSHTMLIFrameElementSrcdocSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcdocAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementSrcdoc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementSrcdocSetter>(*lexicalGlobalObject, thisValue, encodedValue, "srcdoc");
}

static inline JSValue jsHTMLIFrameElementWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::widthAttr));
    return result;
}

EncodedJSValue jsHTMLIFrameElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline bool setJSHTMLIFrameElementWidthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::widthAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "width");
}

static inline JSValue jsHTMLIFrameElementContentDocumentGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Document>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, BindingSecurity::checkSecurityForNode(lexicalGlobalObject, impl.contentDocument()));
    return result;
}

EncodedJSValue jsHTMLIFrameElementContentDocument(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementContentDocumentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "contentDocument");
}

static inline JSValue jsHTMLIFrameElementContentWindowGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<WindowProxy>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.contentWindow());
    return result;
}

EncodedJSValue jsHTMLIFrameElementContentWindow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementContentWindowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "contentWindow");
}

static inline JSValue jsHTMLIFrameElementReferrerPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.referrerPolicyForBindings());
    return result;
}

EncodedJSValue jsHTMLIFrameElementReferrerPolicy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLIFrameElement>::get<jsHTMLIFrameElementReferrerPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "referrerPolicy");
}

static inline bool setJSHTMLIFrameElementReferrerPolicySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLIFrameElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setReferrerPolicyForBindings(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLIFrameElementReferrerPolicy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLIFrameElement>::set<setJSHTMLIFrameElementReferrerPolicySetter>(*lexicalGlobalObject, thisValue, encodedValue, "referrerPolicy");
}

static inline JSC::EncodedJSValue jsHTMLIFrameElementPrototypeFunctionGetSVGDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLIFrameElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<Document>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, BindingSecurity::checkSecurityForNode(*lexicalGlobalObject, impl.getSVGDocument())));
}

EncodedJSValue JSC_HOST_CALL jsHTMLIFrameElementPrototypeFunctionGetSVGDocument(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLIFrameElement>::call<jsHTMLIFrameElementPrototypeFunctionGetSVGDocumentBody>(*lexicalGlobalObject, *callFrame, "getSVGDocument");
}

void JSHTMLIFrameElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLIFrameElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
