/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLKeygenElement.h"

#include "ActiveDOMObject.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionCheckValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionReportValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionSetCustomValidity(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsHTMLKeygenElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLKeygenElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLKeygenElementAutofocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLKeygenElementAutofocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLKeygenElementChallenge(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLKeygenElementChallenge(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLKeygenElementDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLKeygenElementDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLKeygenElementForm(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLKeygenElementKeytype(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLKeygenElementKeytype(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLKeygenElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLKeygenElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLKeygenElementType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLKeygenElementWillValidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLKeygenElementValidity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLKeygenElementValidationMessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLKeygenElementLabels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSHTMLKeygenElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLKeygenElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLKeygenElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLKeygenElementPrototype>(vm.heap)) JSHTMLKeygenElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLKeygenElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLKeygenElementPrototype, JSHTMLKeygenElementPrototype::Base);

using JSHTMLKeygenElementConstructor = JSDOMConstructorNotConstructable<JSHTMLKeygenElement>;

template<> JSValue JSHTMLKeygenElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLKeygenElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLKeygenElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLKeygenElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLKeygenElementConstructor::s_info = { "HTMLKeygenElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLKeygenElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLKeygenElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLKeygenElementConstructor) } },
    { "autofocus", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementAutofocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLKeygenElementAutofocus) } },
    { "challenge", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementChallenge), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLKeygenElementChallenge) } },
    { "disabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementDisabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLKeygenElementDisabled) } },
    { "form", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementForm), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "keytype", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementKeytype), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLKeygenElementKeytype) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLKeygenElementName) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "willValidate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementWillValidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validity", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementValidity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validationMessage", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementValidationMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "labels", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementLabels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "checkValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLKeygenElementPrototypeFunctionCheckValidity), (intptr_t) (0) } },
    { "reportValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLKeygenElementPrototypeFunctionReportValidity), (intptr_t) (0) } },
    { "setCustomValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLKeygenElementPrototypeFunctionSetCustomValidity), (intptr_t) (1) } },
};

const ClassInfo JSHTMLKeygenElementPrototype::s_info = { "HTMLKeygenElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLKeygenElementPrototype) };

void JSHTMLKeygenElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLKeygenElement::info(), JSHTMLKeygenElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().interactiveFormValidationEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("reportValidity"), strlen("reportValidity"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLKeygenElement::s_info = { "HTMLKeygenElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLKeygenElement) };

JSHTMLKeygenElement::JSHTMLKeygenElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLKeygenElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLKeygenElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLKeygenElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLKeygenElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLKeygenElementPrototype::create(vm, &globalObject, JSHTMLKeygenElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLKeygenElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLKeygenElement>(vm, globalObject);
}

JSValue JSHTMLKeygenElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLKeygenElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLKeygenElement* IDLAttribute<JSHTMLKeygenElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLKeygenElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLKeygenElement* IDLOperation<JSHTMLKeygenElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLKeygenElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLKeygenElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLKeygenElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLKeygenElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLKeygenElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLKeygenElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLKeygenElementAutofocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autofocusAttr));
    return result;
}

EncodedJSValue jsHTMLKeygenElementAutofocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementAutofocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autofocus");
}

static inline bool setJSHTMLKeygenElementAutofocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLKeygenElementAutofocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLKeygenElement>::set<setJSHTMLKeygenElementAutofocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "autofocus");
}

static inline JSValue jsHTMLKeygenElementChallengeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::challengeAttr));
    return result;
}

EncodedJSValue jsHTMLKeygenElementChallenge(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementChallengeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "challenge");
}

static inline bool setJSHTMLKeygenElementChallengeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::challengeAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLKeygenElementChallenge(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLKeygenElement>::set<setJSHTMLKeygenElementChallengeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "challenge");
}

static inline JSValue jsHTMLKeygenElementDisabledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::disabledAttr));
    return result;
}

EncodedJSValue jsHTMLKeygenElementDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementDisabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "disabled");
}

static inline bool setJSHTMLKeygenElementDisabledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::disabledAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLKeygenElementDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLKeygenElement>::set<setJSHTMLKeygenElementDisabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "disabled");
}

static inline JSValue jsHTMLKeygenElementFormGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLFormElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.form());
    return result;
}

EncodedJSValue jsHTMLKeygenElementForm(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementFormGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "form");
}

static inline JSValue jsHTMLKeygenElementKeytypeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.keytype());
    return result;
}

EncodedJSValue jsHTMLKeygenElementKeytype(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementKeytypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "keytype");
}

static inline bool setJSHTMLKeygenElementKeytypeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setKeytype(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLKeygenElementKeytype(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLKeygenElement>::set<setJSHTMLKeygenElementKeytypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "keytype");
}

static inline JSValue jsHTMLKeygenElementNameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.getNameAttribute());
    return result;
}

EncodedJSValue jsHTMLKeygenElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSHTMLKeygenElementNameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLKeygenElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLKeygenElement>::set<setJSHTMLKeygenElementNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsHTMLKeygenElementTypeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsHTMLKeygenElementType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsHTMLKeygenElementWillValidateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.willValidate());
    return result;
}

EncodedJSValue jsHTMLKeygenElementWillValidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementWillValidateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "willValidate");
}

static inline JSValue jsHTMLKeygenElementValidityGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<ValidityState>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.validity());
    return result;
}

EncodedJSValue jsHTMLKeygenElementValidity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementValidityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validity");
}

static inline JSValue jsHTMLKeygenElementValidationMessageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.validationMessage());
    return result;
}

EncodedJSValue jsHTMLKeygenElementValidationMessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementValidationMessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validationMessage");
}

static inline JSValue jsHTMLKeygenElementLabelsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLKeygenElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<NodeList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.labels());
    return result;
}

EncodedJSValue jsHTMLKeygenElementLabels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLKeygenElement>::get<jsHTMLKeygenElementLabelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "labels");
}

static inline JSC::EncodedJSValue jsHTMLKeygenElementPrototypeFunctionCheckValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLKeygenElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.checkValidity()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionCheckValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLKeygenElement>::call<jsHTMLKeygenElementPrototypeFunctionCheckValidityBody>(*lexicalGlobalObject, *callFrame, "checkValidity");
}

static inline JSC::EncodedJSValue jsHTMLKeygenElementPrototypeFunctionReportValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLKeygenElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.reportValidity()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionReportValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLKeygenElement>::call<jsHTMLKeygenElementPrototypeFunctionReportValidityBody>(*lexicalGlobalObject, *callFrame, "reportValidity");
}

static inline JSC::EncodedJSValue jsHTMLKeygenElementPrototypeFunctionSetCustomValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLKeygenElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto error = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setCustomValidity(WTFMove(error));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionSetCustomValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLKeygenElement>::call<jsHTMLKeygenElementPrototypeFunctionSetCustomValidityBody>(*lexicalGlobalObject, *callFrame, "setCustomValidity");
}

void JSHTMLKeygenElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLKeygenElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
