/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(METER_ELEMENT)

#include "JSHTMLMeterElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSNodeList.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsHTMLMeterElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMeterElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMeterElementValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementMin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMeterElementMin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementMax(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMeterElementMax(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementLow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMeterElementLow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementHigh(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMeterElementHigh(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementOptimum(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMeterElementOptimum(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMeterElementLabels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSHTMLMeterElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLMeterElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMeterElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMeterElementPrototype>(vm.heap)) JSHTMLMeterElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMeterElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLMeterElementPrototype, JSHTMLMeterElementPrototype::Base);

using JSHTMLMeterElementConstructor = JSDOMConstructorNotConstructable<JSHTMLMeterElement>;

template<> JSValue JSHTMLMeterElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMeterElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMeterElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLMeterElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLMeterElementConstructor::s_info = { "HTMLMeterElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMeterElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLMeterElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementConstructor) } },
    { "value", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementValue) } },
    { "min", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementMin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementMin) } },
    { "max", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementMax), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementMax) } },
    { "low", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementLow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementLow) } },
    { "high", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementHigh), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementHigh) } },
    { "optimum", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementOptimum), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMeterElementOptimum) } },
    { "labels", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMeterElementLabels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSHTMLMeterElementPrototype::s_info = { "HTMLMeterElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMeterElementPrototype) };

void JSHTMLMeterElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMeterElement::info(), JSHTMLMeterElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLMeterElement::s_info = { "HTMLMeterElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMeterElement) };

JSHTMLMeterElement::JSHTMLMeterElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMeterElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLMeterElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLMeterElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLMeterElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLMeterElementPrototype::create(vm, &globalObject, JSHTMLMeterElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLMeterElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLMeterElement>(vm, globalObject);
}

JSValue JSHTMLMeterElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMeterElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLMeterElement* IDLAttribute<JSHTMLMeterElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLMeterElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsHTMLMeterElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLMeterElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLMeterElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLMeterElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLMeterElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLMeterElementValueGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.value());
    return result;
}

EncodedJSValue jsHTMLMeterElementValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMeterElement>::get<jsHTMLMeterElementValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "value");
}

static inline bool setJSHTMLMeterElementValueSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMeterElementValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMeterElement>::set<setJSHTMLMeterElementValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "value");
}

static inline JSValue jsHTMLMeterElementMinGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.min());
    return result;
}

EncodedJSValue jsHTMLMeterElementMin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMeterElement>::get<jsHTMLMeterElementMinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "min");
}

static inline bool setJSHTMLMeterElementMinSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMin(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMeterElementMin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMeterElement>::set<setJSHTMLMeterElementMinSetter>(*lexicalGlobalObject, thisValue, encodedValue, "min");
}

static inline JSValue jsHTMLMeterElementMaxGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.max());
    return result;
}

EncodedJSValue jsHTMLMeterElementMax(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMeterElement>::get<jsHTMLMeterElementMaxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "max");
}

static inline bool setJSHTMLMeterElementMaxSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMax(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMeterElementMax(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMeterElement>::set<setJSHTMLMeterElementMaxSetter>(*lexicalGlobalObject, thisValue, encodedValue, "max");
}

static inline JSValue jsHTMLMeterElementLowGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.low());
    return result;
}

EncodedJSValue jsHTMLMeterElementLow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMeterElement>::get<jsHTMLMeterElementLowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "low");
}

static inline bool setJSHTMLMeterElementLowSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLow(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMeterElementLow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMeterElement>::set<setJSHTMLMeterElementLowSetter>(*lexicalGlobalObject, thisValue, encodedValue, "low");
}

static inline JSValue jsHTMLMeterElementHighGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.high());
    return result;
}

EncodedJSValue jsHTMLMeterElementHigh(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMeterElement>::get<jsHTMLMeterElementHighGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "high");
}

static inline bool setJSHTMLMeterElementHighSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setHigh(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMeterElementHigh(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMeterElement>::set<setJSHTMLMeterElementHighSetter>(*lexicalGlobalObject, thisValue, encodedValue, "high");
}

static inline JSValue jsHTMLMeterElementOptimumGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.optimum());
    return result;
}

EncodedJSValue jsHTMLMeterElementOptimum(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMeterElement>::get<jsHTMLMeterElementOptimumGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "optimum");
}

static inline bool setJSHTMLMeterElementOptimumSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setOptimum(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMeterElementOptimum(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMeterElement>::set<setJSHTMLMeterElementOptimumSetter>(*lexicalGlobalObject, thisValue, encodedValue, "optimum");
}

static inline JSValue jsHTMLMeterElementLabelsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMeterElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<NodeList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.labels());
    return result;
}

EncodedJSValue jsHTMLMeterElementLabels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMeterElement>::get<jsHTMLMeterElementLabelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "labels");
}

void JSHTMLMeterElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLMeterElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(METER_ELEMENT)
