/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLOptionsCollection.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Element.h"
#include "JSDOMAbstractOperations.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLElement.h"
#include "JSHTMLOptGroupElement.h"
#include "JSHTMLOptionElement.h"
#include "JSNode.h"
#include "JSNodeCustom.h"
#include "Node.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/ArrayPrototype.h>
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/PropertyNameArray.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLOptionsCollectionPrototypeFunctionAdd(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLOptionsCollectionPrototypeFunctionRemove(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLOptionsCollectionPrototypeFunctionItem(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLOptionsCollectionPrototypeFunctionNamedItem(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsHTMLOptionsCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLOptionsCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLOptionsCollectionLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLOptionsCollectionLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLOptionsCollectionSelectedIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLOptionsCollectionSelectedIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLOptionsCollectionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLOptionsCollectionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLOptionsCollectionPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLOptionsCollectionPrototype>(vm.heap)) JSHTMLOptionsCollectionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLOptionsCollectionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLOptionsCollectionPrototype, JSHTMLOptionsCollectionPrototype::Base);

using JSHTMLOptionsCollectionConstructor = JSDOMConstructorNotConstructable<JSHTMLOptionsCollection>;

template<> JSValue JSHTMLOptionsCollectionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLCollection::getConstructor(vm, &globalObject);
}

template<> void JSHTMLOptionsCollectionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLOptionsCollection::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLOptionsCollection"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLOptionsCollectionConstructor::s_info = { "HTMLOptionsCollection", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLOptionsCollectionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLOptionsCollectionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionsCollectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLOptionsCollectionConstructor) } },
    { "length", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionsCollectionLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLOptionsCollectionLength) } },
    { "selectedIndex", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionsCollectionSelectedIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLOptionsCollectionSelectedIndex) } },
    { "add", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLOptionsCollectionPrototypeFunctionAdd), (intptr_t) (1) } },
    { "remove", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLOptionsCollectionPrototypeFunctionRemove), (intptr_t) (1) } },
    { "item", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLOptionsCollectionPrototypeFunctionItem), (intptr_t) (1) } },
    { "namedItem", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLOptionsCollectionPrototypeFunctionNamedItem), (intptr_t) (1) } },
};

const ClassInfo JSHTMLOptionsCollectionPrototype::s_info = { "HTMLOptionsCollectionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLOptionsCollectionPrototype) };

void JSHTMLOptionsCollectionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLOptionsCollection::info(), JSHTMLOptionsCollectionPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, globalObject()->arrayPrototype()->getDirect(vm, vm.propertyNames->builtinNames().valuesPrivateName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
}

const ClassInfo JSHTMLOptionsCollection::s_info = { "HTMLOptionsCollection", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLOptionsCollection) };

JSHTMLOptionsCollection::JSHTMLOptionsCollection(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLOptionsCollection>&& impl)
    : JSHTMLCollection(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLOptionsCollection::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLOptionsCollection>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLOptionsCollection::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLOptionsCollectionPrototype::create(vm, &globalObject, JSHTMLOptionsCollectionPrototype::createStructure(vm, &globalObject, JSHTMLCollection::prototype(vm, globalObject)));
}

JSObject* JSHTMLOptionsCollection::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLOptionsCollection>(vm, globalObject);
}

JSValue JSHTMLOptionsCollection::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLOptionsCollectionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSHTMLOptionsCollection::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLOptionsCollection*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (auto index = parseIndex(propertyName)) {
        if (index.value() < thisObject->wrapped().length()) {
            auto value = toJS<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, *thisObject->globalObject(), thisObject->wrapped().item(index.value()));
            slot.setValue(thisObject, static_cast<unsigned>(0), value);
            return true;
        }
        return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
    }
    using GetterIDLType = IDLInterface<HTMLOptionElement>;
    auto getterFunctor = [] (auto& thisObject, auto propertyName) -> Optional<typename GetterIDLType::ImplementationType> {
        auto result = thisObject.wrapped().namedItem(propertyNameToAtomString(propertyName));
        if (!GetterIDLType::isNullValue(result))
            return typename GetterIDLType::ImplementationType { GetterIDLType::extractValueFromNullable(result) };
        return WTF::nullopt;
    };
    if (auto namedProperty = accessVisibleNamedProperty<OverrideBuiltins::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, *thisObject->globalObject(), WTFMove(namedProperty.value()));
        slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
        return true;
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSHTMLOptionsCollection::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSHTMLOptionsCollection*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (LIKELY(index <= MAX_ARRAY_INDEX)) {
        if (index < thisObject->wrapped().length()) {
            auto value = toJS<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, *thisObject->globalObject(), thisObject->wrapped().item(index));
            slot.setValue(thisObject, static_cast<unsigned>(0), value);
            return true;
        }
        return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
    }
    auto propertyName = Identifier::from(vm, index);
    using GetterIDLType = IDLInterface<HTMLOptionElement>;
    auto getterFunctor = [] (auto& thisObject, auto propertyName) -> Optional<typename GetterIDLType::ImplementationType> {
        auto result = thisObject.wrapped().namedItem(propertyNameToAtomString(propertyName));
        if (!GetterIDLType::isNullValue(result))
            return typename GetterIDLType::ImplementationType { GetterIDLType::extractValueFromNullable(result) };
        return WTF::nullopt;
    };
    if (auto namedProperty = accessVisibleNamedProperty<OverrideBuiltins::No>(*lexicalGlobalObject, *thisObject, propertyName, getterFunctor)) {
        auto value = toJS<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, *thisObject->globalObject(), WTFMove(namedProperty.value()));
        slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
        return true;
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSHTMLOptionsCollection::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSHTMLOptionsCollection*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(vm, i));
    for (auto& propertyName : thisObject->wrapped().supportedPropertyNames())
        propertyNames.add(Identifier::fromString(vm, propertyName));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

bool JSHTMLOptionsCollection::put(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, JSValue value, PutPropertySlot& putPropertySlot)
{
    auto* thisObject = jsCast<JSHTMLOptionsCollection*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    if (auto index = parseIndex(propertyName)) {
        auto throwScope = DECLARE_THROW_SCOPE(JSC::getVM(lexicalGlobalObject));
        auto nativeValue = convert<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, value);
        RETURN_IF_EXCEPTION(throwScope, true);
        thisObject->wrapped().setItem(index.value(), WTFMove(nativeValue));
        return true;
    }

    return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);
}

bool JSHTMLOptionsCollection::putByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index, JSValue value, bool shouldThrow)
{
    auto* thisObject = jsCast<JSHTMLOptionsCollection*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    if (LIKELY(index <= MAX_ARRAY_INDEX)) {
        auto throwScope = DECLARE_THROW_SCOPE(JSC::getVM(lexicalGlobalObject));
        auto nativeValue = convert<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, value);
        RETURN_IF_EXCEPTION(throwScope, true);
        thisObject->wrapped().setItem(index, WTFMove(nativeValue));
        return true;
    }

    return JSObject::putByIndex(cell, lexicalGlobalObject, index, value, shouldThrow);
}

bool JSHTMLOptionsCollection::defineOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, const PropertyDescriptor& propertyDescriptor, bool shouldThrow)
{
    auto* thisObject = jsCast<JSHTMLOptionsCollection*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    if (auto index = parseIndex(propertyName)) {
        if (!propertyDescriptor.isDataDescriptor())
            return false;
        auto throwScope = DECLARE_THROW_SCOPE(JSC::getVM(lexicalGlobalObject));
        auto nativeValue = convert<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, propertyDescriptor.value());
        RETURN_IF_EXCEPTION(throwScope, true);
        thisObject->wrapped().setItem(index.value(), WTFMove(nativeValue));
        return true;
    }

    if (!propertyName.isSymbol()) {
        PropertySlot slot { thisObject, PropertySlot::InternalMethodType::VMInquiry };
        if (!JSObject::getOwnPropertySlot(thisObject, lexicalGlobalObject, propertyName, slot)) {
            if (thisObject->wrapped().isSupportedPropertyName(propertyNameToString(propertyName)))
                return false;
        }
    }

    PropertyDescriptor newPropertyDescriptor = propertyDescriptor;
    newPropertyDescriptor.setConfigurable(true);
    return JSObject::defineOwnProperty(object, lexicalGlobalObject, propertyName, newPropertyDescriptor, shouldThrow);
}

template<> inline JSHTMLOptionsCollection* IDLAttribute<JSHTMLOptionsCollection>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLOptionsCollection*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLOptionsCollection* IDLOperation<JSHTMLOptionsCollection>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLOptionsCollection*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLOptionsCollectionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLOptionsCollectionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLOptionsCollection::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLOptionsCollectionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLOptionsCollectionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLOptionsCollectionLengthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOptionsCollection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length());
    return result;
}

EncodedJSValue jsHTMLOptionsCollectionLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOptionsCollection>::get<jsHTMLOptionsCollectionLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "length");
}

static inline bool setJSHTMLOptionsCollectionLengthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOptionsCollection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLength(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLOptionsCollectionLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLOptionsCollection>::set<setJSHTMLOptionsCollectionLengthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "length");
}

static inline JSValue jsHTMLOptionsCollectionSelectedIndexGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOptionsCollection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.selectedIndex());
    return result;
}

EncodedJSValue jsHTMLOptionsCollectionSelectedIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOptionsCollection>::get<jsHTMLOptionsCollectionSelectedIndexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "selectedIndex");
}

static inline bool setJSHTMLOptionsCollectionSelectedIndexSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOptionsCollection& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSelectedIndex(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLOptionsCollectionSelectedIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLOptionsCollection>::set<setJSHTMLOptionsCollectionSelectedIndexSetter>(*lexicalGlobalObject, thisValue, encodedValue, "selectedIndex");
}

static inline JSC::EncodedJSValue jsHTMLOptionsCollectionPrototypeFunctionAddBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLOptionsCollection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLUnion<IDLInterface<HTMLOptionElement>, IDLInterface<HTMLOptGroupElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto before = callFrame->argument(1).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLUnion<IDLInterface<HTMLElement>, IDLLong>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.add(WTFMove(element), WTFMove(before)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLOptionsCollectionPrototypeFunctionAdd(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLOptionsCollection>::call<jsHTMLOptionsCollectionPrototypeFunctionAddBody>(*lexicalGlobalObject, *callFrame, "add");
}

static inline JSC::EncodedJSValue jsHTMLOptionsCollectionPrototypeFunctionRemoveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLOptionsCollection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.remove(WTFMove(index));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLOptionsCollectionPrototypeFunctionRemove(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLOptionsCollection>::call<jsHTMLOptionsCollectionPrototypeFunctionRemoveBody>(*lexicalGlobalObject, *callFrame, "remove");
}

static inline JSC::EncodedJSValue jsHTMLOptionsCollectionPrototypeFunctionItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLOptionsCollection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.item(WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsHTMLOptionsCollectionPrototypeFunctionItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLOptionsCollection>::call<jsHTMLOptionsCollectionPrototypeFunctionItemBody>(*lexicalGlobalObject, *callFrame, "item");
}

static inline JSC::EncodedJSValue jsHTMLOptionsCollectionPrototypeFunctionNamedItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLOptionsCollection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<HTMLOptionElement>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.namedItem(WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsHTMLOptionsCollectionPrototypeFunctionNamedItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLOptionsCollection>::call<jsHTMLOptionsCollectionPrototypeFunctionNamedItemBody>(*lexicalGlobalObject, *callFrame, "namedItem");
}

void JSHTMLOptionsCollection::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLOptionsCollection*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLOptionsCollectionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsHTMLOptionsCollection = jsCast<JSHTMLOptionsCollection*>(handle.slot()->asCell());
    void* root = WebCore::root(jsHTMLOptionsCollection->wrapped().ownerNode());
    if (UNLIKELY(reason))
        *reason = "Reachable from HTMLOptionsCollection ownerNode";
    return visitor.containsOpaqueRoot(root);
}

void JSHTMLOptionsCollectionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLOptionsCollection = static_cast<JSHTMLOptionsCollection*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLOptionsCollection->wrapped(), jsHTMLOptionsCollection);
}

HTMLOptionsCollection* JSHTMLOptionsCollection::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLOptionsCollection*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
