/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLOutputElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMTokenList.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionCheckValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionReportValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionSetCustomValidity(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsHTMLOutputElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLOutputElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLOutputElementHtmlFor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLOutputElementHtmlFor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLOutputElementForm(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLOutputElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLOutputElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLOutputElementType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLOutputElementDefaultValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLOutputElementDefaultValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLOutputElementValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLOutputElementValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLOutputElementWillValidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLOutputElementValidity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLOutputElementValidationMessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLOutputElementLabels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSHTMLOutputElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLOutputElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLOutputElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLOutputElementPrototype>(vm.heap)) JSHTMLOutputElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLOutputElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLOutputElementPrototype, JSHTMLOutputElementPrototype::Base);

using JSHTMLOutputElementConstructor = JSDOMConstructorNotConstructable<JSHTMLOutputElement>;

template<> JSValue JSHTMLOutputElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLOutputElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLOutputElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLOutputElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLOutputElementConstructor::s_info = { "HTMLOutputElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLOutputElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLOutputElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLOutputElementConstructor) } },
    { "htmlFor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementHtmlFor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLOutputElementHtmlFor) } },
    { "form", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementForm), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLOutputElementName) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultValue", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementDefaultValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLOutputElementDefaultValue) } },
    { "value", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLOutputElementValue) } },
    { "willValidate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementWillValidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validity", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValidity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validationMessage", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValidationMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "labels", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementLabels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "checkValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLOutputElementPrototypeFunctionCheckValidity), (intptr_t) (0) } },
    { "reportValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLOutputElementPrototypeFunctionReportValidity), (intptr_t) (0) } },
    { "setCustomValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLOutputElementPrototypeFunctionSetCustomValidity), (intptr_t) (1) } },
};

const ClassInfo JSHTMLOutputElementPrototype::s_info = { "HTMLOutputElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLOutputElementPrototype) };

void JSHTMLOutputElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLOutputElement::info(), JSHTMLOutputElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().interactiveFormValidationEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("reportValidity"), strlen("reportValidity"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLOutputElement::s_info = { "HTMLOutputElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLOutputElement) };

JSHTMLOutputElement::JSHTMLOutputElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLOutputElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLOutputElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLOutputElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLOutputElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLOutputElementPrototype::create(vm, &globalObject, JSHTMLOutputElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLOutputElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLOutputElement>(vm, globalObject);
}

JSValue JSHTMLOutputElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLOutputElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLOutputElement* IDLAttribute<JSHTMLOutputElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLOutputElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLOutputElement* IDLOperation<JSHTMLOutputElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLOutputElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLOutputElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLOutputElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLOutputElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLOutputElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLOutputElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLOutputElementHtmlForGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMTokenList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.htmlFor());
    return result;
}

EncodedJSValue jsHTMLOutputElementHtmlFor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementHtmlForGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "htmlFor");
}

static inline bool setJSHTMLOutputElementHtmlForSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    auto id = Identifier::fromString(vm, reinterpret_cast<const LChar*>("htmlFor"), strlen("htmlFor"));
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, reinterpret_cast<const LChar*>("value"), strlen("value"));
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable(vm)->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

bool setJSHTMLOutputElementHtmlFor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLOutputElement>::set<setJSHTMLOutputElementHtmlForSetter>(*lexicalGlobalObject, thisValue, encodedValue, "htmlFor");
}

static inline JSValue jsHTMLOutputElementFormGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLFormElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.form());
    return result;
}

EncodedJSValue jsHTMLOutputElementForm(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementFormGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "form");
}

static inline JSValue jsHTMLOutputElementNameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.getNameAttribute());
    return result;
}

EncodedJSValue jsHTMLOutputElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSHTMLOutputElementNameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLOutputElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLOutputElement>::set<setJSHTMLOutputElementNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsHTMLOutputElementTypeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsHTMLOutputElementType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsHTMLOutputElementDefaultValueGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.defaultValue());
    return result;
}

EncodedJSValue jsHTMLOutputElementDefaultValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementDefaultValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "defaultValue");
}

static inline bool setJSHTMLOutputElementDefaultValueSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDefaultValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLOutputElementDefaultValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLOutputElement>::set<setJSHTMLOutputElementDefaultValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "defaultValue");
}

static inline JSValue jsHTMLOutputElementValueGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.value());
    return result;
}

EncodedJSValue jsHTMLOutputElementValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "value");
}

static inline bool setJSHTMLOutputElementValueSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLOutputElementValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLOutputElement>::set<setJSHTMLOutputElementValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "value");
}

static inline JSValue jsHTMLOutputElementWillValidateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.willValidate());
    return result;
}

EncodedJSValue jsHTMLOutputElementWillValidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementWillValidateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "willValidate");
}

static inline JSValue jsHTMLOutputElementValidityGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<ValidityState>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.validity());
    return result;
}

EncodedJSValue jsHTMLOutputElementValidity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementValidityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validity");
}

static inline JSValue jsHTMLOutputElementValidationMessageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.validationMessage());
    return result;
}

EncodedJSValue jsHTMLOutputElementValidationMessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementValidationMessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validationMessage");
}

static inline JSValue jsHTMLOutputElementLabelsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLOutputElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<NodeList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.labels());
    return result;
}

EncodedJSValue jsHTMLOutputElementLabels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLOutputElement>::get<jsHTMLOutputElementLabelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "labels");
}

static inline JSC::EncodedJSValue jsHTMLOutputElementPrototypeFunctionCheckValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLOutputElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.checkValidity()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionCheckValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLOutputElement>::call<jsHTMLOutputElementPrototypeFunctionCheckValidityBody>(*lexicalGlobalObject, *callFrame, "checkValidity");
}

static inline JSC::EncodedJSValue jsHTMLOutputElementPrototypeFunctionReportValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLOutputElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.reportValidity()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionReportValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLOutputElement>::call<jsHTMLOutputElementPrototypeFunctionReportValidityBody>(*lexicalGlobalObject, *callFrame, "reportValidity");
}

static inline JSC::EncodedJSValue jsHTMLOutputElementPrototypeFunctionSetCustomValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLOutputElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto error = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setCustomValidity(WTFMove(error));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionSetCustomValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLOutputElement>::call<jsHTMLOutputElementPrototypeFunctionSetCustomValidityBody>(*lexicalGlobalObject, *callFrame, "setCustomValidity");
}

void JSHTMLOutputElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLOutputElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
