/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLVideoElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "EventNames.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(PICTURE_IN_PICTURE_API)
#include "HTMLVideoElementPictureInPicture.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSEventListener.h"
#endif


namespace WebCore {
using namespace JSC;

#if ENABLE(VIDEO_PRESENTATION_MODE)

String convertEnumerationToString(HTMLVideoElement::VideoPresentationMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("inline"),
        MAKE_STATIC_STRING_IMPL("fullscreen"),
        MAKE_STATIC_STRING_IMPL("picture-in-picture"),
    };
    static_assert(static_cast<size_t>(HTMLVideoElement::VideoPresentationMode::Inline) == 0, "HTMLVideoElement::VideoPresentationMode::Inline is not 0 as expected");
    static_assert(static_cast<size_t>(HTMLVideoElement::VideoPresentationMode::Fullscreen) == 1, "HTMLVideoElement::VideoPresentationMode::Fullscreen is not 1 as expected");
    static_assert(static_cast<size_t>(HTMLVideoElement::VideoPresentationMode::PictureInPicture) == 2, "HTMLVideoElement::VideoPresentationMode::PictureInPicture is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, HTMLVideoElement::VideoPresentationMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<HTMLVideoElement::VideoPresentationMode> parseEnumeration<HTMLVideoElement::VideoPresentationMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "inline")
        return HTMLVideoElement::VideoPresentationMode::Inline;
    if (stringValue == "fullscreen")
        return HTMLVideoElement::VideoPresentationMode::Fullscreen;
    if (stringValue == "picture-in-picture")
        return HTMLVideoElement::VideoPresentationMode::PictureInPicture;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<HTMLVideoElement::VideoPresentationMode>()
{
    return "\"inline\", \"fullscreen\", \"picture-in-picture\"";
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreen(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(VIDEO_PRESENTATION_MODE)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitSupportsPresentationMode(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitSetPresentationMode(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionRequestPictureInPicture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif

// Attributes

JSC::EncodedJSValue jsHTMLVideoElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLVideoElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLVideoElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLVideoElementVideoWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLVideoElementVideoHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLVideoElementPoster(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementPoster(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLVideoElementPlaysInline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementPlaysInline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLVideoElementWebkitSupportsFullscreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLVideoElementWebkitDisplayingFullscreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsHTMLVideoElementWebkitWirelessVideoPlaybackDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementWebkitWirelessVideoPlaybackDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STATISTICS)
JSC::EncodedJSValue jsHTMLVideoElementWebkitDecodedFrameCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(MEDIA_STATISTICS)
JSC::EncodedJSValue jsHTMLVideoElementWebkitDroppedFrameCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
JSC::EncodedJSValue jsHTMLVideoElementWebkitPresentationMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsHTMLVideoElementOnenterpictureinpicture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementOnenterpictureinpicture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsHTMLVideoElementOnleavepictureinpicture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementOnleavepictureinpicture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsHTMLVideoElementAutoPictureInPicture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementAutoPictureInPicture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsHTMLVideoElementDisablePictureInPicture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLVideoElementDisablePictureInPicture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif

class JSHTMLVideoElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLVideoElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLVideoElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLVideoElementPrototype>(vm.heap)) JSHTMLVideoElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLVideoElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLVideoElementPrototype, JSHTMLVideoElementPrototype::Base);

using JSHTMLVideoElementConstructor = JSDOMConstructorNotConstructable<JSHTMLVideoElement>;

template<> JSValue JSHTMLVideoElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLMediaElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLVideoElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLVideoElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLVideoElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLVideoElementConstructor::s_info = { "HTMLVideoElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLVideoElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLVideoElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementConstructor) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementWidth) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementHeight) } },
    { "videoWidth", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementVideoWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "videoHeight", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementVideoHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "poster", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementPoster), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementPoster) } },
    { "playsInline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementPlaysInline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementPlaysInline) } },
    { "webkitSupportsFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitSupportsFullscreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitDisplayingFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDisplayingFullscreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "webkitWirelessVideoPlaybackDisabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitWirelessVideoPlaybackDisabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementWebkitWirelessVideoPlaybackDisabled) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitDecodedFrameCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDecodedFrameCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitDroppedFrameCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDroppedFrameCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    { "webkitPresentationMode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitPresentationMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "onenterpictureinpicture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementOnenterpictureinpicture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementOnenterpictureinpicture) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "onleavepictureinpicture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementOnleavepictureinpicture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementOnleavepictureinpicture) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "autoPictureInPicture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementAutoPictureInPicture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementAutoPictureInPicture) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "disablePictureInPicture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementDisablePictureInPicture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLVideoElementDisablePictureInPicture) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "webkitEnterFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreen), (intptr_t) (0) } },
    { "webkitExitFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreen), (intptr_t) (0) } },
    { "webkitEnterFullScreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreen), (intptr_t) (0) } },
    { "webkitExitFullScreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreen), (intptr_t) (0) } },
#if ENABLE(VIDEO_PRESENTATION_MODE)
    { "webkitSupportsPresentationMode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitSupportsPresentationMode), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    { "webkitSetPresentationMode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitSetPresentationMode), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "requestPictureInPicture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLVideoElementPrototypeFunctionRequestPictureInPicture), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSHTMLVideoElementPrototype::s_info = { "HTMLVideoElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLVideoElementPrototype) };

void JSHTMLVideoElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLVideoElement::info(), JSHTMLVideoElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("requestPictureInPicture"), strlen("requestPictureInPicture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onenterpictureinpicture"), strlen("onenterpictureinpicture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onleavepictureinpicture"), strlen("onleavepictureinpicture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("autoPictureInPicture"), strlen("autoPictureInPicture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("disablePictureInPicture"), strlen("disablePictureInPicture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLVideoElement::s_info = { "HTMLVideoElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLVideoElement) };

JSHTMLVideoElement::JSHTMLVideoElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLVideoElement>&& impl)
    : JSHTMLMediaElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLVideoElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, HTMLVideoElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSHTMLVideoElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLVideoElementPrototype::create(vm, &globalObject, JSHTMLVideoElementPrototype::createStructure(vm, &globalObject, JSHTMLMediaElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLVideoElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLVideoElement>(vm, globalObject);
}

JSValue JSHTMLVideoElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLVideoElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLVideoElement* IDLAttribute<JSHTMLVideoElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLVideoElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLVideoElement* IDLOperation<JSHTMLVideoElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLVideoElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLVideoElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLVideoElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLVideoElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLVideoElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLVideoElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLVideoElementWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::widthAttr)));
    return result;
}

EncodedJSValue jsHTMLVideoElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline bool setJSHTMLVideoElementWidthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLVideoElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "width");
}

static inline JSValue jsHTMLVideoElementHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::heightAttr)));
    return result;
}

EncodedJSValue jsHTMLVideoElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline bool setJSHTMLVideoElementHeightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLVideoElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "height");
}

static inline JSValue jsHTMLVideoElementVideoWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.videoWidth());
    return result;
}

EncodedJSValue jsHTMLVideoElementVideoWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementVideoWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "videoWidth");
}

static inline JSValue jsHTMLVideoElementVideoHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.videoHeight());
    return result;
}

EncodedJSValue jsHTMLVideoElementVideoHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementVideoHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "videoHeight");
}

static inline JSValue jsHTMLVideoElementPosterGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.getURLAttribute(WebCore::HTMLNames::posterAttr));
    return result;
}

EncodedJSValue jsHTMLVideoElementPoster(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementPosterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "poster");
}

static inline bool setJSHTMLVideoElementPosterSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::posterAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLVideoElementPoster(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementPosterSetter>(*lexicalGlobalObject, thisValue, encodedValue, "poster");
}

static inline JSValue jsHTMLVideoElementPlaysInlineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::playsinlineAttr));
    return result;
}

EncodedJSValue jsHTMLVideoElementPlaysInline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementPlaysInlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "playsInline");
}

static inline bool setJSHTMLVideoElementPlaysInlineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::playsinlineAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLVideoElementPlaysInline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementPlaysInlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "playsInline");
}

static inline JSValue jsHTMLVideoElementWebkitSupportsFullscreenGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitSupportsFullscreen());
    return result;
}

EncodedJSValue jsHTMLVideoElementWebkitSupportsFullscreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementWebkitSupportsFullscreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitSupportsFullscreen");
}

static inline JSValue jsHTMLVideoElementWebkitDisplayingFullscreenGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitDisplayingFullscreen());
    return result;
}

EncodedJSValue jsHTMLVideoElementWebkitDisplayingFullscreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementWebkitDisplayingFullscreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitDisplayingFullscreen");
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSValue jsHTMLVideoElementWebkitWirelessVideoPlaybackDisabledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitWirelessVideoPlaybackDisabled());
    return result;
}

EncodedJSValue jsHTMLVideoElementWebkitWirelessVideoPlaybackDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementWebkitWirelessVideoPlaybackDisabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitWirelessVideoPlaybackDisabled");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline bool setJSHTMLVideoElementWebkitWirelessVideoPlaybackDisabledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setWebkitWirelessVideoPlaybackDisabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLVideoElementWebkitWirelessVideoPlaybackDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementWebkitWirelessVideoPlaybackDisabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitWirelessVideoPlaybackDisabled");
}

#endif

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLVideoElementWebkitDecodedFrameCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitDecodedFrameCount());
    return result;
}

EncodedJSValue jsHTMLVideoElementWebkitDecodedFrameCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementWebkitDecodedFrameCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitDecodedFrameCount");
}

#endif

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLVideoElementWebkitDroppedFrameCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitDroppedFrameCount());
    return result;
}

EncodedJSValue jsHTMLVideoElementWebkitDroppedFrameCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementWebkitDroppedFrameCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitDroppedFrameCount");
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
static inline JSValue jsHTMLVideoElementWebkitPresentationModeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<HTMLVideoElement::VideoPresentationMode>>(lexicalGlobalObject, throwScope, impl.webkitPresentationMode());
    return result;
}

EncodedJSValue jsHTMLVideoElementWebkitPresentationMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementWebkitPresentationModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitPresentationMode");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsHTMLVideoElementOnenterpictureinpictureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().enterpictureinpictureEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLVideoElementOnenterpictureinpicture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementOnenterpictureinpictureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onenterpictureinpicture");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSHTMLVideoElementOnenterpictureinpictureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().enterpictureinpictureEvent, value);
    return true;
}

bool setJSHTMLVideoElementOnenterpictureinpicture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementOnenterpictureinpictureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onenterpictureinpicture");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsHTMLVideoElementOnleavepictureinpictureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().leavepictureinpictureEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLVideoElementOnleavepictureinpicture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementOnleavepictureinpictureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onleavepictureinpicture");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSHTMLVideoElementOnleavepictureinpictureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().leavepictureinpictureEvent, value);
    return true;
}

bool setJSHTMLVideoElementOnleavepictureinpicture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementOnleavepictureinpictureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onleavepictureinpicture");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsHTMLVideoElementAutoPictureInPictureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autopictureinpictureAttr));
    return result;
}

EncodedJSValue jsHTMLVideoElementAutoPictureInPicture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementAutoPictureInPictureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autoPictureInPicture");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSHTMLVideoElementAutoPictureInPictureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autopictureinpictureAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLVideoElementAutoPictureInPicture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementAutoPictureInPictureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "autoPictureInPicture");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsHTMLVideoElementDisablePictureInPictureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::disablepictureinpictureAttr));
    return result;
}

EncodedJSValue jsHTMLVideoElementDisablePictureInPicture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElementDisablePictureInPictureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "disablePictureInPicture");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSHTMLVideoElementDisablePictureInPictureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::disablepictureinpictureAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLVideoElementDisablePictureInPicture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElementDisablePictureInPictureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "disablePictureInPicture");
}

#endif

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.webkitEnterFullscreen());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreenBody>(*lexicalGlobalObject, *callFrame, "webkitEnterFullscreen");
}

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.webkitExitFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreenBody>(*lexicalGlobalObject, *callFrame, "webkitExitFullscreen");
}

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.webkitEnterFullscreen());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreenBody>(*lexicalGlobalObject, *callFrame, "webkitEnterFullScreen");
}

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.webkitExitFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreenBody>(*lexicalGlobalObject, *callFrame, "webkitExitFullScreen");
}

#if ENABLE(VIDEO_PRESENTATION_MODE)
static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunctionWebkitSupportsPresentationModeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLEnumeration<HTMLVideoElement::VideoPresentationMode>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "mode", "HTMLVideoElement", "webkitSupportsPresentationMode", expectedEnumerationValues<HTMLVideoElement::VideoPresentationMode>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.webkitSupportsPresentationMode(WTFMove(mode))));
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitSupportsPresentationMode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunctionWebkitSupportsPresentationModeBody>(*lexicalGlobalObject, *callFrame, "webkitSupportsPresentationMode");
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunctionWebkitSetPresentationModeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLEnumeration<HTMLVideoElement::VideoPresentationMode>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "mode", "HTMLVideoElement", "webkitSetPresentationMode", expectedEnumerationValues<HTMLVideoElement::VideoPresentationMode>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.webkitSetPresentationMode(WTFMove(mode));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitSetPresentationMode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunctionWebkitSetPresentationModeBody>(*lexicalGlobalObject, *callFrame, "webkitSetPresentationMode");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunctionRequestPictureInPictureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLVideoElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    WebCore::HTMLVideoElementPictureInPicture::requestPictureInPicture(impl, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionRequestPictureInPicture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunctionRequestPictureInPictureBody>(*lexicalGlobalObject, *callFrame, "requestPictureInPicture");
}

#endif

void JSHTMLVideoElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLVideoElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLVideoElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsHTMLVideoElement = jsCast<JSHTMLVideoElement*>(handle.slot()->asCell());
    if (jsHTMLVideoElement->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsHTMLVideoElement->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLVideoElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLVideoElement = static_cast<JSHTMLVideoElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLVideoElement->wrapped(), jsHTMLVideoElement);
}

HTMLVideoElement* JSHTMLVideoElement::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLVideoElement*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
