/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHdrMetadataType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(HdrMetadataType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("smpteSt2086"),
        MAKE_STATIC_STRING_IMPL("smpteSt2094-10"),
        MAKE_STATIC_STRING_IMPL("smpteSt2094-40"),
    };
    static_assert(static_cast<size_t>(HdrMetadataType::SmpteSt2086) == 0, "HdrMetadataType::SmpteSt2086 is not 0 as expected");
    static_assert(static_cast<size_t>(HdrMetadataType::SmpteSt209410) == 1, "HdrMetadataType::SmpteSt209410 is not 1 as expected");
    static_assert(static_cast<size_t>(HdrMetadataType::SmpteSt209440) == 2, "HdrMetadataType::SmpteSt209440 is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, HdrMetadataType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<HdrMetadataType> parseEnumeration<HdrMetadataType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "smpteSt2086")
        return HdrMetadataType::SmpteSt2086;
    if (stringValue == "smpteSt2094-10")
        return HdrMetadataType::SmpteSt209410;
    if (stringValue == "smpteSt2094-40")
        return HdrMetadataType::SmpteSt209440;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<HdrMetadataType>()
{
    return "\"smpteSt2086\", \"smpteSt2094-10\", \"smpteSt2094-40\"";
}

} // namespace WebCore
