/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBIndex.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSIDBCursorDirection.h"
#include "JSIDBKeyRange.h"
#include "JSIDBObjectStore.h"
#include "JSIDBRequest.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenCursor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenKeyCursor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGet(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetKey(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetAll(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetAllKeys(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionCount(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsIDBIndexConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBIndexConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBIndexName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBIndexName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBIndexObjectStore(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBIndexKeyPath(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBIndexMultiEntry(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBIndexUnique(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSIDBIndexPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBIndexPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBIndexPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBIndexPrototype>(vm.heap)) JSIDBIndexPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBIndexPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBIndexPrototype, JSIDBIndexPrototype::Base);

using JSIDBIndexConstructor = JSDOMConstructorNotConstructable<JSIDBIndex>;

template<> JSValue JSIDBIndexConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBIndexConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBIndex::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IDBIndex"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSIDBIndexConstructor::s_info = { "IDBIndex", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBIndexConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBIndexPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBIndexConstructor) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBIndexName) } },
    { "objectStore", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexObjectStore), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "keyPath", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexKeyPath), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "multiEntry", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexMultiEntry), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "unique", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexUnique), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "openCursor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBIndexPrototypeFunctionOpenCursor), (intptr_t) (0) } },
    { "openKeyCursor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBIndexPrototypeFunctionOpenKeyCursor), (intptr_t) (0) } },
    { "get", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBIndexPrototypeFunctionGet), (intptr_t) (1) } },
    { "getKey", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBIndexPrototypeFunctionGetKey), (intptr_t) (1) } },
    { "getAll", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBIndexPrototypeFunctionGetAll), (intptr_t) (0) } },
    { "getAllKeys", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBIndexPrototypeFunctionGetAllKeys), (intptr_t) (0) } },
    { "count", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBIndexPrototypeFunctionCount), (intptr_t) (0) } },
};

const ClassInfo JSIDBIndexPrototype::s_info = { "IDBIndexPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBIndexPrototype) };

void JSIDBIndexPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBIndex::info(), JSIDBIndexPrototypeTableValues, *this);
}

const ClassInfo JSIDBIndex::s_info = { "IDBIndex", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBIndex) };

JSIDBIndex::JSIDBIndex(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBIndex>&& impl)
    : JSDOMWrapper<IDBIndex>(structure, globalObject, WTFMove(impl))
{
}

void JSIDBIndex::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, IDBIndex>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSIDBIndex::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIDBIndexPrototype::create(vm, &globalObject, JSIDBIndexPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSIDBIndex::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBIndex>(vm, globalObject);
}

JSValue JSIDBIndex::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBIndexConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBIndex::destroy(JSC::JSCell* cell)
{
    JSIDBIndex* thisObject = static_cast<JSIDBIndex*>(cell);
    thisObject->JSIDBIndex::~JSIDBIndex();
}

template<> inline JSIDBIndex* IDLAttribute<JSIDBIndex>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIDBIndex*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSIDBIndex* IDLOperation<JSIDBIndex>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSIDBIndex*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsIDBIndexConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBIndexPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBIndex::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIDBIndexConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBIndexPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIDBIndexNameGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name());
    return result;
}

EncodedJSValue jsIDBIndexName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndexNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSIDBIndexNameSetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setName(WTFMove(nativeValue));
    });
    return true;
}

bool setJSIDBIndexName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBIndex>::set<setJSIDBIndexNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsIDBIndexObjectStoreGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<IDBObjectStore>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.objectStore());
    return result;
}

EncodedJSValue jsIDBIndexObjectStore(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndexObjectStoreGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "objectStore");
}

static inline JSValue jsIDBIndexKeyPathGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.keyPath());
    return result;
}

EncodedJSValue jsIDBIndexKeyPath(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndexKeyPathGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "keyPath");
}

static inline JSValue jsIDBIndexMultiEntryGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.multiEntry());
    return result;
}

EncodedJSValue jsIDBIndexMultiEntry(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndexMultiEntryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "multiEntry");
}

static inline JSValue jsIDBIndexUniqueGetter(JSGlobalObject& lexicalGlobalObject, JSIDBIndex& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.unique());
    return result;
}

EncodedJSValue jsIDBIndexUnique(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBIndex>::get<jsIDBIndexUniqueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "unique");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionOpenCursor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "openCursor", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(1).isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBIndex", "openCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range), WTFMove(direction))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionOpenCursor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(1).isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBIndex", "openCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(direction))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionOpenCursorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBIndexPrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionOpenCursor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionOpenCursor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenCursor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunctionOpenCursorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "openCursor");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionOpenKeyCursor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "openKeyCursor", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(1).isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBIndex", "openKeyCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openKeyCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range), WTFMove(direction))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionOpenKeyCursor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(1).isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBIndex", "openKeyCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openKeyCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(direction))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionOpenKeyCursorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBIndexPrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionOpenKeyCursor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionOpenKeyCursor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionOpenKeyCursor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunctionOpenKeyCursorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "openKeyCursor");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGet1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "key", "IDBIndex", "get", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGet2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionGet1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionGet1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionGet2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGet(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunctionGetOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetKey1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "key", "IDBIndex", "getKey", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetKey2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetKeyOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionGetKey1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionGetKey1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionGetKey2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetKey(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunctionGetKeyOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getKey");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetAll1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "getAll", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range), WTFMove(count))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetAll2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(count))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetAllOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBIndexPrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionGetAll2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionGetAll2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetAll(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunctionGetAllOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getAll");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetAllKeys1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "getAllKeys", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAllKeys(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range), WTFMove(count))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetAllKeys2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAllKeys(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(count))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionGetAllKeysOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBIndexPrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionGetAllKeys2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionGetAllKeys2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionGetAllKeys(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunctionGetAllKeysOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getAllKeys");
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionCount1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBIndex", "count", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.count(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionCount2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.count(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBIndexPrototypeFunctionCountOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBIndex>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBIndexPrototypeFunctionCount1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBIndexPrototypeFunctionCount1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBIndexPrototypeFunctionCount1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBIndexPrototypeFunctionCount1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBIndexPrototypeFunctionCount2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBIndexPrototypeFunctionCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBIndex>::call<jsIDBIndexPrototypeFunctionCountOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "count");
}

void JSIDBIndex::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBIndex*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIDBIndex::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBIndex*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIDBIndex::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBIndex*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBIndexOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsIDBIndex = jsCast<JSIDBIndex*>(handle.slot()->asCell());
    if (jsIDBIndex->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    IDBIndex* root = &jsIDBIndex->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from IDBIndex";
    return visitor.containsOpaqueRoot(root);
}

void JSIDBIndexOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBIndex = static_cast<JSIDBIndex*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBIndex->wrapped(), jsIDBIndex);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBIndex>&& impl)
{
    return createWrapper<IDBIndex>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBIndex& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBIndex* JSIDBIndex::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBIndex*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
