/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBObjectStore.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMStringList.h"
#include "JSDOMWrapperCache.h"
#include "JSIDBCursorDirection.h"
#include "JSIDBIndex.h"
#include "JSIDBKeyRange.h"
#include "JSIDBRequest.h"
#include "JSIDBTransaction.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

template<> IDBObjectStore::IndexParameters convertDictionary<IDBObjectStore::IndexParameters>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    IDBObjectStore::IndexParameters result;
    JSValue multiEntryValue;
    if (isNullOrUndefined)
        multiEntryValue = jsUndefined();
    else {
        multiEntryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "multiEntry"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!multiEntryValue.isUndefined()) {
        result.multiEntry = convert<IDLBoolean>(lexicalGlobalObject, multiEntryValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.multiEntry = false;
    JSValue uniqueValue;
    if (isNullOrUndefined)
        uniqueValue = jsUndefined();
    else {
        uniqueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "unique"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!uniqueValue.isUndefined()) {
        result.unique = convert<IDLBoolean>(lexicalGlobalObject, uniqueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.unique = false;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionPut(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionAdd(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDelete(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGet(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGetKey(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionClear(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionOpenCursor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionOpenKeyCursor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGetAll(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGetAllKeys(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCreateIndex(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionIndex(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDeleteIndex(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCount(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsIDBObjectStoreConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBObjectStoreConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBObjectStoreName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBObjectStoreName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBObjectStoreKeyPath(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBObjectStoreIndexNames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBObjectStoreTransaction(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBObjectStoreAutoIncrement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSIDBObjectStorePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBObjectStorePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBObjectStorePrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBObjectStorePrototype>(vm.heap)) JSIDBObjectStorePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBObjectStorePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBObjectStorePrototype, JSIDBObjectStorePrototype::Base);

using JSIDBObjectStoreConstructor = JSDOMConstructorNotConstructable<JSIDBObjectStore>;

template<> JSValue JSIDBObjectStoreConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBObjectStoreConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBObjectStore::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IDBObjectStore"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSIDBObjectStoreConstructor::s_info = { "IDBObjectStore", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBObjectStoreConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBObjectStorePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBObjectStoreConstructor) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBObjectStoreName) } },
    { "keyPath", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreKeyPath), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "indexNames", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreIndexNames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "transaction", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreTransaction), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "autoIncrement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBObjectStoreAutoIncrement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "put", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionPut), (intptr_t) (1) } },
    { "add", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionAdd), (intptr_t) (1) } },
    { "delete", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionDelete), (intptr_t) (1) } },
    { "get", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionGet), (intptr_t) (1) } },
    { "getKey", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionGetKey), (intptr_t) (1) } },
    { "clear", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionClear), (intptr_t) (0) } },
    { "openCursor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionOpenCursor), (intptr_t) (0) } },
    { "openKeyCursor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionOpenKeyCursor), (intptr_t) (0) } },
    { "getAll", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionGetAll), (intptr_t) (0) } },
    { "getAllKeys", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionGetAllKeys), (intptr_t) (0) } },
    { "createIndex", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionCreateIndex), (intptr_t) (2) } },
    { "index", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionIndex), (intptr_t) (1) } },
    { "deleteIndex", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionDeleteIndex), (intptr_t) (1) } },
    { "count", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBObjectStorePrototypeFunctionCount), (intptr_t) (0) } },
};

const ClassInfo JSIDBObjectStorePrototype::s_info = { "IDBObjectStorePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBObjectStorePrototype) };

void JSIDBObjectStorePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBObjectStore::info(), JSIDBObjectStorePrototypeTableValues, *this);
}

const ClassInfo JSIDBObjectStore::s_info = { "IDBObjectStore", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBObjectStore) };

JSIDBObjectStore::JSIDBObjectStore(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBObjectStore>&& impl)
    : JSDOMWrapper<IDBObjectStore>(structure, globalObject, WTFMove(impl))
{
}

void JSIDBObjectStore::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, IDBObjectStore>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSIDBObjectStore::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIDBObjectStorePrototype::create(vm, &globalObject, JSIDBObjectStorePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSIDBObjectStore::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBObjectStore>(vm, globalObject);
}

JSValue JSIDBObjectStore::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBObjectStoreConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBObjectStore::destroy(JSC::JSCell* cell)
{
    JSIDBObjectStore* thisObject = static_cast<JSIDBObjectStore*>(cell);
    thisObject->JSIDBObjectStore::~JSIDBObjectStore();
}

template<> inline JSIDBObjectStore* IDLAttribute<JSIDBObjectStore>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIDBObjectStore*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSIDBObjectStore* IDLOperation<JSIDBObjectStore>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSIDBObjectStore*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsIDBObjectStoreConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBObjectStorePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBObjectStore::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIDBObjectStoreConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBObjectStorePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIDBObjectStoreNameGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name());
    return result;
}

EncodedJSValue jsIDBObjectStoreName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStoreNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSIDBObjectStoreNameSetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setName(WTFMove(nativeValue));
    });
    return true;
}

bool setJSIDBObjectStoreName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBObjectStore>::set<setJSIDBObjectStoreNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsIDBObjectStoreKeyPathGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.keyPath());
    return result;
}

EncodedJSValue jsIDBObjectStoreKeyPath(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStoreKeyPathGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "keyPath");
}

static inline JSValue jsIDBObjectStoreIndexNamesGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.indexNames());
    return result;
}

EncodedJSValue jsIDBObjectStoreIndexNames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStoreIndexNamesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "indexNames");
}

static inline JSValue jsIDBObjectStoreTransactionGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<IDBTransaction>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.transaction());
    return result;
}

EncodedJSValue jsIDBObjectStoreTransaction(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStoreTransactionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "transaction");
}

static inline JSValue jsIDBObjectStoreAutoIncrementGetter(JSGlobalObject& lexicalGlobalObject, JSIDBObjectStore& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.autoIncrement());
    return result;
}

EncodedJSValue jsIDBObjectStoreAutoIncrement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBObjectStore>::get<jsIDBObjectStoreAutoIncrementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autoIncrement");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionPutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.put(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(value), WTFMove(key))));
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionPut(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionPutBody>(*lexicalGlobalObject, *callFrame, "put");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionAddBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.add(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(value), WTFMove(key))));
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionAdd(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionAddBody>(*lexicalGlobalObject, *callFrame, "add");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionDelete1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto keyRange = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "keyRange", "IDBObjectStore", "delete", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.deleteFunction(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(keyRange))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionDelete2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.deleteFunction(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionDeleteOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionDelete1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionDelete1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionDelete2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDelete(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionDeleteOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "delete");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGet1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "key", "IDBObjectStore", "get", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGet2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.get(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionGet1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionGet1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionGet2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGet(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionGetOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetKey1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "key", "IDBObjectStore", "getKey", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetKey2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getKey(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetKeyOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionGetKey1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionGetKey1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionGetKey2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGetKey(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionGetKeyOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getKey");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionClearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clear(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject))));
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionClear(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionClearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionOpenCursor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "openCursor", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(1).isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBObjectStore", "openCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range), WTFMove(direction))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionOpenCursor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(1).isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBObjectStore", "openCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(direction))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionOpenCursorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBObjectStorePrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionOpenCursor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionOpenCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionOpenCursor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionOpenCursor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionOpenCursorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "openCursor");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionOpenKeyCursor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "openKeyCursor", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(1).isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBObjectStore", "openKeyCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openKeyCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range), WTFMove(direction))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionOpenKeyCursor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(1).isUndefined() ? IDBCursorDirection::Next : convert<IDLEnumeration<IDBCursorDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "direction", "IDBObjectStore", "openKeyCursor", expectedEnumerationValues<IDBCursorDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openKeyCursor(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(direction))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionOpenKeyCursorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBObjectStorePrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionOpenKeyCursor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionOpenKeyCursor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionOpenKeyCursor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionOpenKeyCursor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionOpenKeyCursorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "openKeyCursor");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetAll1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "getAll", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range), WTFMove(count))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetAll2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAll(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(count))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetAllOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBObjectStorePrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionGetAll2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionGetAll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionGetAll2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGetAll(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionGetAllOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getAll");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetAllKeys1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "getAllKeys", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAllKeys(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range), WTFMove(count))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetAllKeys2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>() : Optional<Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType>(convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getAllKeys(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key), WTFMove(count))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionGetAllKeysOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBObjectStorePrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionGetAllKeys2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionGetAllKeys1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionGetAllKeys2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionGetAllKeys(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionGetAllKeysOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "getAllKeys");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionCreateIndexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto keyPath = convert<IDLUnion<IDLDOMString, IDLSequence<IDLDOMString>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<IDBObjectStore::IndexParameters>>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBIndex>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createIndex(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(name), WTFMove(keyPath), WTFMove(options))));
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCreateIndex(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionCreateIndexBody>(*lexicalGlobalObject, *callFrame, "createIndex");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionIndexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBIndex>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.index(WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionIndex(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionIndexBody>(*lexicalGlobalObject, *callFrame, "index");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionDeleteIndexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.deleteIndex(WTFMove(name)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionDeleteIndex(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionDeleteIndexBody>(*lexicalGlobalObject, *callFrame, "deleteIndex");
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionCount1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto range = convert<IDLNullable<IDLInterface<IDBKeyRange>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "IDBObjectStore", "count", "IDBKeyRange"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.count(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(range))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionCount2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBRequest>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.count(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

static inline JSC::EncodedJSValue jsIDBObjectStorePrototypeFunctionCountOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBObjectStore>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsIDBObjectStorePrototypeFunctionCount1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsIDBObjectStorePrototypeFunctionCount1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isUndefinedOrNull())
            return jsIDBObjectStorePrototypeFunctionCount1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSIDBKeyRange>(vm))
            return jsIDBObjectStorePrototypeFunctionCount1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsIDBObjectStorePrototypeFunctionCount2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsIDBObjectStorePrototypeFunctionCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBObjectStore>::call<jsIDBObjectStorePrototypeFunctionCountOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "count");
}

void JSIDBObjectStore::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBObjectStore*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIDBObjectStore::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBObjectStore*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIDBObjectStore::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBObjectStore*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBObjectStoreOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsIDBObjectStore = jsCast<JSIDBObjectStore*>(handle.slot()->asCell());
    if (jsIDBObjectStore->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    IDBObjectStore* root = &jsIDBObjectStore->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from IDBObjectStore";
    return visitor.containsOpaqueRoot(root);
}

void JSIDBObjectStoreOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBObjectStore = static_cast<JSIDBObjectStore*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBObjectStore->wrapped(), jsIDBObjectStore);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBObjectStore>&& impl)
{
    return createWrapper<IDBObjectStore>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBObjectStore& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBObjectStore* JSIDBObjectStore::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBObjectStore*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
