/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBOpenDBRequest.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsIDBOpenDBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBOpenDBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBOpenDBRequestOnblocked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBOpenDBRequestOnblocked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBOpenDBRequestOnupgradeneeded(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBOpenDBRequestOnupgradeneeded(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSIDBOpenDBRequestPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBOpenDBRequestPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBOpenDBRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBOpenDBRequestPrototype>(vm.heap)) JSIDBOpenDBRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBOpenDBRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBOpenDBRequestPrototype, JSIDBOpenDBRequestPrototype::Base);

using JSIDBOpenDBRequestConstructor = JSDOMConstructorNotConstructable<JSIDBOpenDBRequest>;

template<> JSValue JSIDBOpenDBRequestConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSIDBRequest::getConstructor(vm, &globalObject);
}

template<> void JSIDBOpenDBRequestConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBOpenDBRequest::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IDBOpenDBRequest"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSIDBOpenDBRequestConstructor::s_info = { "IDBOpenDBRequest", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBOpenDBRequestConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBOpenDBRequestPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBOpenDBRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBOpenDBRequestConstructor) } },
    { "onblocked", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBOpenDBRequestOnblocked), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBOpenDBRequestOnblocked) } },
    { "onupgradeneeded", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBOpenDBRequestOnupgradeneeded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBOpenDBRequestOnupgradeneeded) } },
};

const ClassInfo JSIDBOpenDBRequestPrototype::s_info = { "IDBOpenDBRequestPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBOpenDBRequestPrototype) };

void JSIDBOpenDBRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBOpenDBRequest::info(), JSIDBOpenDBRequestPrototypeTableValues, *this);
}

const ClassInfo JSIDBOpenDBRequest::s_info = { "IDBOpenDBRequest", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBOpenDBRequest) };

JSIDBOpenDBRequest::JSIDBOpenDBRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBOpenDBRequest>&& impl)
    : JSIDBRequest(structure, globalObject, WTFMove(impl))
{
}

void JSIDBOpenDBRequest::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, IDBOpenDBRequest>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSIDBOpenDBRequest::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIDBOpenDBRequestPrototype::create(vm, &globalObject, JSIDBOpenDBRequestPrototype::createStructure(vm, &globalObject, JSIDBRequest::prototype(vm, globalObject)));
}

JSObject* JSIDBOpenDBRequest::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBOpenDBRequest>(vm, globalObject);
}

JSValue JSIDBOpenDBRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBOpenDBRequestConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSIDBOpenDBRequest* IDLAttribute<JSIDBOpenDBRequest>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIDBOpenDBRequest*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsIDBOpenDBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBOpenDBRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBOpenDBRequest::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIDBOpenDBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBOpenDBRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIDBOpenDBRequestOnblockedGetter(JSGlobalObject& lexicalGlobalObject, JSIDBOpenDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().blockedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsIDBOpenDBRequestOnblocked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBOpenDBRequest>::get<jsIDBOpenDBRequestOnblockedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onblocked");
}

static inline bool setJSIDBOpenDBRequestOnblockedSetter(JSGlobalObject& lexicalGlobalObject, JSIDBOpenDBRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().blockedEvent, value);
    return true;
}

bool setJSIDBOpenDBRequestOnblocked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBOpenDBRequest>::set<setJSIDBOpenDBRequestOnblockedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onblocked");
}

static inline JSValue jsIDBOpenDBRequestOnupgradeneededGetter(JSGlobalObject& lexicalGlobalObject, JSIDBOpenDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().upgradeneededEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsIDBOpenDBRequestOnupgradeneeded(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBOpenDBRequest>::get<jsIDBOpenDBRequestOnupgradeneededGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onupgradeneeded");
}

static inline bool setJSIDBOpenDBRequestOnupgradeneededSetter(JSGlobalObject& lexicalGlobalObject, JSIDBOpenDBRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().upgradeneededEvent, value);
    return true;
}

bool setJSIDBOpenDBRequestOnupgradeneeded(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBOpenDBRequest>::set<setJSIDBOpenDBRequestOnupgradeneededSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onupgradeneeded");
}

void JSIDBOpenDBRequest::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBOpenDBRequest*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBOpenDBRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsIDBOpenDBRequest = jsCast<JSIDBOpenDBRequest*>(handle.slot()->asCell());
    if (jsIDBOpenDBRequest->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsIDBOpenDBRequest->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIDBOpenDBRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBOpenDBRequest = static_cast<JSIDBOpenDBRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBOpenDBRequest->wrapped(), jsIDBOpenDBRequest);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBOpenDBRequest>&& impl)
{
    return createWrapper<IDBOpenDBRequest>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBOpenDBRequest& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBOpenDBRequest* JSIDBOpenDBRequest::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBOpenDBRequest*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
