/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBRequest.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMException.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSIDBCursor.h"
#include "JSIDBIndex.h"
#include "JSIDBObjectStore.h"
#include "JSIDBTransaction.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(IDBRequest::ReadyState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("pending"),
        MAKE_STATIC_STRING_IMPL("done"),
    };
    static_assert(static_cast<size_t>(IDBRequest::ReadyState::Pending) == 0, "IDBRequest::ReadyState::Pending is not 0 as expected");
    static_assert(static_cast<size_t>(IDBRequest::ReadyState::Done) == 1, "IDBRequest::ReadyState::Done is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, IDBRequest::ReadyState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<IDBRequest::ReadyState> parseEnumeration<IDBRequest::ReadyState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "pending")
        return IDBRequest::ReadyState::Pending;
    if (stringValue == "done")
        return IDBRequest::ReadyState::Done;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<IDBRequest::ReadyState>()
{
    return "\"pending\", \"done\"";
}

// Attributes

JSC::EncodedJSValue jsIDBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBRequestResult(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBRequestError(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBRequestSource(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBRequestTransaction(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBRequestReadyState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBRequestOnsuccess(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBRequestOnsuccess(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBRequestOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBRequestOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSIDBRequestPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBRequestPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBRequestPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBRequestPrototype>(vm.heap)) JSIDBRequestPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBRequestPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBRequestPrototype, JSIDBRequestPrototype::Base);

using JSIDBRequestConstructor = JSDOMConstructorNotConstructable<JSIDBRequest>;

template<> JSValue JSIDBRequestConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSIDBRequestConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBRequest::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IDBRequest"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSIDBRequestConstructor::s_info = { "IDBRequest", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBRequestConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBRequestPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBRequestConstructor) } },
    { "result", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestResult), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "error", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestError), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "source", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestSource), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "transaction", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestTransaction), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onsuccess", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestOnsuccess), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBRequestOnsuccess) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBRequestOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBRequestOnerror) } },
};

const ClassInfo JSIDBRequestPrototype::s_info = { "IDBRequestPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBRequestPrototype) };

void JSIDBRequestPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBRequest::info(), JSIDBRequestPrototypeTableValues, *this);
}

const ClassInfo JSIDBRequest::s_info = { "IDBRequest", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBRequest) };

JSIDBRequest::JSIDBRequest(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBRequest>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSIDBRequest::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, IDBRequest>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSIDBRequest::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIDBRequestPrototype::create(vm, &globalObject, JSIDBRequestPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSIDBRequest::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBRequest>(vm, globalObject);
}

JSValue JSIDBRequest::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBRequestConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSIDBRequest* IDLAttribute<JSIDBRequest>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIDBRequest*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsIDBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBRequest::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIDBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBRequestPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIDBRequestResultGetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.result(lexicalGlobalObject);
}

EncodedJSValue jsIDBRequestResult(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBRequest>::get<jsIDBRequestResultGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "result");
}

static inline JSValue jsIDBRequestErrorGetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<DOMException>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.error());
    return result;
}

EncodedJSValue jsIDBRequestError(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBRequest>::get<jsIDBRequestErrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "error");
}

static inline JSValue jsIDBRequestSourceGetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnion<IDLInterface<IDBObjectStore>, IDLInterface<IDBIndex>, IDLInterface<IDBCursor>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.source());
    return result;
}

EncodedJSValue jsIDBRequestSource(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBRequest>::get<jsIDBRequestSourceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "source");
}

static inline JSValue jsIDBRequestTransactionGetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<IDBTransaction>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.transaction());
    return result;
}

EncodedJSValue jsIDBRequestTransaction(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBRequest>::get<jsIDBRequestTransactionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "transaction");
}

static inline JSValue jsIDBRequestReadyStateGetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<IDBRequest::ReadyState>>(lexicalGlobalObject, throwScope, impl.readyState());
    return result;
}

EncodedJSValue jsIDBRequestReadyState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBRequest>::get<jsIDBRequestReadyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readyState");
}

static inline JSValue jsIDBRequestOnsuccessGetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().successEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsIDBRequestOnsuccess(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBRequest>::get<jsIDBRequestOnsuccessGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsuccess");
}

static inline bool setJSIDBRequestOnsuccessSetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().successEvent, value);
    return true;
}

bool setJSIDBRequestOnsuccess(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBRequest>::set<setJSIDBRequestOnsuccessSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsuccess");
}

static inline JSValue jsIDBRequestOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsIDBRequestOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBRequest>::get<jsIDBRequestOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSIDBRequestOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSIDBRequest& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSIDBRequestOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBRequest>::set<setJSIDBRequestOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

void JSIDBRequest::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIDBRequest::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBRequest*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIDBRequest::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBRequest*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBRequestOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsIDBRequest = jsCast<JSIDBRequest*>(handle.slot()->asCell());
    if (jsIDBRequest->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsIDBRequest->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    IDBRequest* root = &jsIDBRequest->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from IDBRequest";
    return visitor.containsOpaqueRoot(root);
}

void JSIDBRequestOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBRequest = static_cast<JSIDBRequest*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBRequest->wrapped(), jsIDBRequest);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBRequest>&& impl)
{
    return createWrapper<IDBRequest>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBRequest& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBRequest* JSIDBRequest::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBRequest*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
