/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBTransaction.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMException.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMStringList.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSIDBDatabase.h"
#include "JSIDBObjectStore.h"
#include "JSIDBTransactionMode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionObjectStore(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionAbort(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsIDBTransactionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBTransactionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBTransactionObjectStoreNames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBTransactionMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBTransactionDb(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBTransactionError(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBTransactionOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBTransactionOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBTransactionOncomplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBTransactionOncomplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBTransactionOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBTransactionOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSIDBTransactionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBTransactionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBTransactionPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBTransactionPrototype>(vm.heap)) JSIDBTransactionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBTransactionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBTransactionPrototype, JSIDBTransactionPrototype::Base);

using JSIDBTransactionConstructor = JSDOMConstructorNotConstructable<JSIDBTransaction>;

template<> JSValue JSIDBTransactionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSIDBTransactionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBTransaction::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IDBTransaction"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSIDBTransactionConstructor::s_info = { "IDBTransaction", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBTransactionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBTransactionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBTransactionConstructor) } },
    { "objectStoreNames", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionObjectStoreNames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "mode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "db", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionDb), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "error", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionError), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onabort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBTransactionOnabort) } },
    { "oncomplete", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionOncomplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBTransactionOncomplete) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBTransactionOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBTransactionOnerror) } },
    { "objectStore", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBTransactionPrototypeFunctionObjectStore), (intptr_t) (1) } },
    { "abort", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBTransactionPrototypeFunctionAbort), (intptr_t) (0) } },
};

const ClassInfo JSIDBTransactionPrototype::s_info = { "IDBTransactionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBTransactionPrototype) };

void JSIDBTransactionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBTransaction::info(), JSIDBTransactionPrototypeTableValues, *this);
}

const ClassInfo JSIDBTransaction::s_info = { "IDBTransaction", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBTransaction) };

JSIDBTransaction::JSIDBTransaction(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBTransaction>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSIDBTransaction::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, IDBTransaction>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSIDBTransaction::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIDBTransactionPrototype::create(vm, &globalObject, JSIDBTransactionPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSIDBTransaction::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBTransaction>(vm, globalObject);
}

JSValue JSIDBTransaction::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBTransactionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSIDBTransaction* IDLAttribute<JSIDBTransaction>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIDBTransaction*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSIDBTransaction* IDLOperation<JSIDBTransaction>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSIDBTransaction*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsIDBTransactionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBTransactionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBTransaction::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIDBTransactionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBTransactionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIDBTransactionObjectStoreNamesGetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.objectStoreNames());
    return result;
}

EncodedJSValue jsIDBTransactionObjectStoreNames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBTransaction>::get<jsIDBTransactionObjectStoreNamesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "objectStoreNames");
}

static inline JSValue jsIDBTransactionModeGetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<IDBTransactionMode>>(lexicalGlobalObject, throwScope, impl.mode());
    return result;
}

EncodedJSValue jsIDBTransactionMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBTransaction>::get<jsIDBTransactionModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mode");
}

static inline JSValue jsIDBTransactionDbGetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<IDBDatabase>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.db());
    return result;
}

EncodedJSValue jsIDBTransactionDb(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBTransaction>::get<jsIDBTransactionDbGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "db");
}

static inline JSValue jsIDBTransactionErrorGetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMException>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.error());
    return result;
}

EncodedJSValue jsIDBTransactionError(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBTransaction>::get<jsIDBTransactionErrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "error");
}

static inline JSValue jsIDBTransactionOnabortGetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsIDBTransactionOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBTransaction>::get<jsIDBTransactionOnabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onabort");
}

static inline bool setJSIDBTransactionOnabortSetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().abortEvent, value);
    return true;
}

bool setJSIDBTransactionOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBTransaction>::set<setJSIDBTransactionOnabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onabort");
}

static inline JSValue jsIDBTransactionOncompleteGetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().completeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsIDBTransactionOncomplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBTransaction>::get<jsIDBTransactionOncompleteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncomplete");
}

static inline bool setJSIDBTransactionOncompleteSetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().completeEvent, value);
    return true;
}

bool setJSIDBTransactionOncomplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBTransaction>::set<setJSIDBTransactionOncompleteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncomplete");
}

static inline JSValue jsIDBTransactionOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsIDBTransactionOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBTransaction>::get<jsIDBTransactionOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSIDBTransactionOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSIDBTransaction& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSIDBTransactionOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSIDBTransaction>::set<setJSIDBTransactionOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSC::EncodedJSValue jsIDBTransactionPrototypeFunctionObjectStoreBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBTransaction>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBObjectStore>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.objectStore(WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionObjectStore(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBTransaction>::call<jsIDBTransactionPrototypeFunctionObjectStoreBody>(*lexicalGlobalObject, *callFrame, "objectStore");
}

static inline JSC::EncodedJSValue jsIDBTransactionPrototypeFunctionAbortBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBTransaction>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.abort());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBTransactionPrototypeFunctionAbort(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBTransaction>::call<jsIDBTransactionPrototypeFunctionAbortBody>(*lexicalGlobalObject, *callFrame, "abort");
}

void JSIDBTransaction::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBTransaction*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIDBTransaction::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBTransaction*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIDBTransaction::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBTransaction*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBTransactionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsIDBTransaction = jsCast<JSIDBTransaction*>(handle.slot()->asCell());
    if (jsIDBTransaction->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsIDBTransaction->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIDBTransactionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBTransaction = static_cast<JSIDBTransaction*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBTransaction->wrapped(), jsIDBTransaction);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBTransaction>&& impl)
{
    return createWrapper<IDBTransaction>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBTransaction& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBTransaction* JSIDBTransaction::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBTransaction*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
