/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageBitmapRenderingContext.h"

#include "ActiveDOMObject.h"
#include "CallTracer.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "JSImageBitmap.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsImageBitmapRenderingContextPrototypeFunctionTransferFromImageBitmap(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsImageBitmapRenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSImageBitmapRenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsImageBitmapRenderingContextCanvas(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSImageBitmapRenderingContextPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSImageBitmapRenderingContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSImageBitmapRenderingContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSImageBitmapRenderingContextPrototype>(vm.heap)) JSImageBitmapRenderingContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSImageBitmapRenderingContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSImageBitmapRenderingContextPrototype, JSImageBitmapRenderingContextPrototype::Base);

using JSImageBitmapRenderingContextConstructor = JSDOMConstructorNotConstructable<JSImageBitmapRenderingContext>;

template<> JSValue JSImageBitmapRenderingContextConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSImageBitmapRenderingContextConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSImageBitmapRenderingContext::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ImageBitmapRenderingContext"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSImageBitmapRenderingContextConstructor::s_info = { "ImageBitmapRenderingContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageBitmapRenderingContextConstructor) };

/* Hash table for prototype */

static const HashTableValue JSImageBitmapRenderingContextPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageBitmapRenderingContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSImageBitmapRenderingContextConstructor) } },
    { "canvas", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageBitmapRenderingContextCanvas), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "transferFromImageBitmap", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsImageBitmapRenderingContextPrototypeFunctionTransferFromImageBitmap), (intptr_t) (1) } },
};

const ClassInfo JSImageBitmapRenderingContextPrototype::s_info = { "ImageBitmapRenderingContextPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageBitmapRenderingContextPrototype) };

void JSImageBitmapRenderingContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSImageBitmapRenderingContext::info(), JSImageBitmapRenderingContextPrototypeTableValues, *this);
}

const ClassInfo JSImageBitmapRenderingContext::s_info = { "ImageBitmapRenderingContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageBitmapRenderingContext) };

JSImageBitmapRenderingContext::JSImageBitmapRenderingContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ImageBitmapRenderingContext>&& impl)
    : JSDOMWrapper<ImageBitmapRenderingContext>(structure, globalObject, WTFMove(impl))
{
}

void JSImageBitmapRenderingContext::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ImageBitmapRenderingContext>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSImageBitmapRenderingContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSImageBitmapRenderingContextPrototype::create(vm, &globalObject, JSImageBitmapRenderingContextPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSImageBitmapRenderingContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSImageBitmapRenderingContext>(vm, globalObject);
}

JSValue JSImageBitmapRenderingContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSImageBitmapRenderingContextConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSImageBitmapRenderingContext::destroy(JSC::JSCell* cell)
{
    JSImageBitmapRenderingContext* thisObject = static_cast<JSImageBitmapRenderingContext*>(cell);
    thisObject->JSImageBitmapRenderingContext::~JSImageBitmapRenderingContext();
}

template<> inline JSImageBitmapRenderingContext* IDLAttribute<JSImageBitmapRenderingContext>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSImageBitmapRenderingContext*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSImageBitmapRenderingContext* IDLOperation<JSImageBitmapRenderingContext>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSImageBitmapRenderingContext*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsImageBitmapRenderingContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSImageBitmapRenderingContextPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSImageBitmapRenderingContext::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSImageBitmapRenderingContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSImageBitmapRenderingContextPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsImageBitmapRenderingContextCanvasGetter(JSGlobalObject& lexicalGlobalObject, JSImageBitmapRenderingContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCanvasElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas());
    return result;
}

EncodedJSValue jsImageBitmapRenderingContextCanvas(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSImageBitmapRenderingContext>::get<jsImageBitmapRenderingContextCanvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "canvas");
}

static inline JSC::EncodedJSValue jsImageBitmapRenderingContextPrototypeFunctionTransferFromImageBitmapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSImageBitmapRenderingContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto bitmap = convert<IDLNullable<IDLInterface<ImageBitmap>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "bitmap", "ImageBitmapRenderingContext", "transferFromImageBitmap", "ImageBitmap"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "transferFromImageBitmap"_s, { bitmap });
    propagateException(*lexicalGlobalObject, throwScope, impl.transferFromImageBitmap(WTFMove(bitmap)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsImageBitmapRenderingContextPrototypeFunctionTransferFromImageBitmap(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSImageBitmapRenderingContext>::call<jsImageBitmapRenderingContextPrototypeFunctionTransferFromImageBitmapBody>(*lexicalGlobalObject, *callFrame, "transferFromImageBitmap");
}

void JSImageBitmapRenderingContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSImageBitmapRenderingContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSImageBitmapRenderingContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSImageBitmapRenderingContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsImageBitmapRenderingContext = static_cast<JSImageBitmapRenderingContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsImageBitmapRenderingContext->wrapped(), jsImageBitmapRenderingContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ImageBitmapRenderingContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27ImageBitmapRenderingContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ImageBitmapRenderingContext>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7ImageBitmapRenderingContext@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore27ImageBitmapRenderingContextE[2];
#endif

    // If this fails ImageBitmapRenderingContext does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<ImageBitmapRenderingContext>::value, "ImageBitmapRenderingContext is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // ImageBitmapRenderingContext has subclasses. If ImageBitmapRenderingContext has subclasses that get passed
    // to toJS() we currently require ImageBitmapRenderingContext you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<ImageBitmapRenderingContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ImageBitmapRenderingContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ImageBitmapRenderingContext* JSImageBitmapRenderingContext::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSImageBitmapRenderingContext*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
