/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageData.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsImageDataConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSImageDataConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsImageDataWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsImageDataHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsImageDataData(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSImageDataPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSImageDataPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSImageDataPrototype* ptr = new (NotNull, JSC::allocateCell<JSImageDataPrototype>(vm.heap)) JSImageDataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSImageDataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSImageDataPrototype, JSImageDataPrototype::Base);

using JSImageDataConstructor = JSDOMConstructor<JSImageData>;

static inline EncodedJSValue constructJSImageData1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSImageDataConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto sw = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ImageData::create(WTFMove(sw), WTFMove(sh));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

static inline EncodedJSValue constructJSImageData2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSImageDataConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto data = convert<IDLUint8ClampedArray>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "data", "ImageData", nullptr, "Uint8ClampedArray"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sw = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = callFrame->argument(2).isUndefined() ? Optional<Converter<IDLUnsignedLong>::ReturnType>() : Optional<Converter<IDLUnsignedLong>::ReturnType>(convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ImageData::create(data.releaseNonNull(), WTFMove(sw), WTFMove(sh));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> EncodedJSValue JSC_HOST_CALL JSImageDataConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSUint8ClampedArray>(vm))
            return constructJSImageData2(lexicalGlobalObject, callFrame);
        if (distinguishingArg.isNumber())
            return constructJSImageData1(lexicalGlobalObject, callFrame);
        return constructJSImageData1(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 3) {
        return constructJSImageData2(lexicalGlobalObject, callFrame);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

template<> JSValue JSImageDataConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSImageDataConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSImageData::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ImageData"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSImageDataConstructor::s_info = { "ImageData", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageDataConstructor) };

/* Hash table for prototype */

static const HashTableValue JSImageDataPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSImageDataConstructor) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "data", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataData), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSImageDataPrototype::s_info = { "ImageDataPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageDataPrototype) };

void JSImageDataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSImageData::info(), JSImageDataPrototypeTableValues, *this);
}

const ClassInfo JSImageData::s_info = { "ImageData", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSImageData) };

JSImageData::JSImageData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ImageData>&& impl)
    : JSDOMWrapper<ImageData>(structure, globalObject, WTFMove(impl))
{
}

void JSImageData::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ImageData>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSImageData::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSImageDataPrototype::create(vm, &globalObject, JSImageDataPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSImageData::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSImageData>(vm, globalObject);
}

JSValue JSImageData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSImageDataConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSImageData::destroy(JSC::JSCell* cell)
{
    JSImageData* thisObject = static_cast<JSImageData*>(cell);
    thisObject->JSImageData::~JSImageData();
}

template<> inline JSImageData* IDLAttribute<JSImageData>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSImageData*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsImageDataConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSImageDataPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSImageData::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSImageDataConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSImageDataPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsImageDataWidthGetter(JSGlobalObject& lexicalGlobalObject, JSImageData& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.width());
    return result;
}

EncodedJSValue jsImageDataWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSImageData>::get<jsImageDataWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline JSValue jsImageDataHeightGetter(JSGlobalObject& lexicalGlobalObject, JSImageData& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.height());
    return result;
}

EncodedJSValue jsImageDataHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSImageData>::get<jsImageDataHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline JSValue jsImageDataDataGetter(JSGlobalObject& lexicalGlobalObject, JSImageData& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUint8ClampedArray>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.data());
    return result;
}

EncodedJSValue jsImageDataData(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSImageData>::get<jsImageDataDataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "data");
}

void JSImageData::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSImageData*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSImageDataOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSImageDataOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsImageData = static_cast<JSImageData*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsImageData->wrapped(), jsImageData);
}

ImageData* JSImageData::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSImageData*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
