/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInternalSettings.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(InternalSettings::ForcedAccessibilityValue enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("system"),
        MAKE_STATIC_STRING_IMPL("on"),
        MAKE_STATIC_STRING_IMPL("off"),
    };
    static_assert(static_cast<size_t>(InternalSettings::ForcedAccessibilityValue::System) == 0, "InternalSettings::ForcedAccessibilityValue::System is not 0 as expected");
    static_assert(static_cast<size_t>(InternalSettings::ForcedAccessibilityValue::On) == 1, "InternalSettings::ForcedAccessibilityValue::On is not 1 as expected");
    static_assert(static_cast<size_t>(InternalSettings::ForcedAccessibilityValue::Off) == 2, "InternalSettings::ForcedAccessibilityValue::Off is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, InternalSettings::ForcedAccessibilityValue enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<InternalSettings::ForcedAccessibilityValue> parseEnumeration<InternalSettings::ForcedAccessibilityValue>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "system")
        return InternalSettings::ForcedAccessibilityValue::System;
    if (stringValue == "on")
        return InternalSettings::ForcedAccessibilityValue::On;
    if (stringValue == "off")
        return InternalSettings::ForcedAccessibilityValue::Off;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<InternalSettings::ForcedAccessibilityValue>()
{
    return "\"system\", \"on\", \"off\"";
}

String convertEnumerationToString(InternalSettings::FrameFlatteningValue enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("Disabled"),
        MAKE_STATIC_STRING_IMPL("EnabledForNonFullScreenIFrames"),
        MAKE_STATIC_STRING_IMPL("FullyEnabled"),
    };
    static_assert(static_cast<size_t>(InternalSettings::FrameFlatteningValue::Disabled) == 0, "InternalSettings::FrameFlatteningValue::Disabled is not 0 as expected");
    static_assert(static_cast<size_t>(InternalSettings::FrameFlatteningValue::EnabledForNonFullScreenIFrames) == 1, "InternalSettings::FrameFlatteningValue::EnabledForNonFullScreenIFrames is not 1 as expected");
    static_assert(static_cast<size_t>(InternalSettings::FrameFlatteningValue::FullyEnabled) == 2, "InternalSettings::FrameFlatteningValue::FullyEnabled is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, InternalSettings::FrameFlatteningValue enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<InternalSettings::FrameFlatteningValue> parseEnumeration<InternalSettings::FrameFlatteningValue>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "Disabled")
        return InternalSettings::FrameFlatteningValue::Disabled;
    if (stringValue == "EnabledForNonFullScreenIFrames")
        return InternalSettings::FrameFlatteningValue::EnabledForNonFullScreenIFrames;
    if (stringValue == "FullyEnabled")
        return InternalSettings::FrameFlatteningValue::FullyEnabled;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<InternalSettings::FrameFlatteningValue>()
{
    return "\"Disabled\", \"EnabledForNonFullScreenIFrames\", \"FullyEnabled\"";
}

String convertEnumerationToString(InternalSettings::FontLoadTimingOverride enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("Block"),
        MAKE_STATIC_STRING_IMPL("Swap"),
        MAKE_STATIC_STRING_IMPL("Failure"),
    };
    static_assert(static_cast<size_t>(InternalSettings::FontLoadTimingOverride::Block) == 0, "InternalSettings::FontLoadTimingOverride::Block is not 0 as expected");
    static_assert(static_cast<size_t>(InternalSettings::FontLoadTimingOverride::Swap) == 1, "InternalSettings::FontLoadTimingOverride::Swap is not 1 as expected");
    static_assert(static_cast<size_t>(InternalSettings::FontLoadTimingOverride::Failure) == 2, "InternalSettings::FontLoadTimingOverride::Failure is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, InternalSettings::FontLoadTimingOverride enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<InternalSettings::FontLoadTimingOverride> parseEnumeration<InternalSettings::FontLoadTimingOverride>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "Block")
        return InternalSettings::FontLoadTimingOverride::Block;
    if (stringValue == "Swap")
        return InternalSettings::FontLoadTimingOverride::Swap;
    if (stringValue == "Failure")
        return InternalSettings::FontLoadTimingOverride::Failure;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<InternalSettings::FontLoadTimingOverride>()
{
    return "\"Block\", \"Swap\", \"Failure\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStandardFontFamily(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSerifFontFamily(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSansSerifFontFamily(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFixedFontFamily(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCursiveFontFamily(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFantasyFontFamily(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPictographFontFamily(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFontFallbackPrefersPictographs(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFontLoadTimingOverride(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldIgnoreFontLoadCompletions(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverride(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingUsesIdempotentMode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCanStartMedia(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKind(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionShouldDisplayTrackKind(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDefaultVideoPosterURL(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTimeWithoutMouseMovementBeforeHidingControls(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMediaTypeOverride(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAllowsAirPlayForMediaPlayback(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMediaCaptureRequiresSecureConnection(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetForcePendingWebGLPolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetQuickTimePluginReplacementEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetYouTubeFlashPluginReplacementEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetEditingBehavior(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldConvertPositionStyleOnCopy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPreferMIMETypeForImages(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetUseDarkAppearance(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetImagesEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPDFImageCachingPolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehavior(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAutoscrollForDragAndDropEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetBackgroundShouldExtendBeyondPage(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetScrollingTreeIncludesFrames(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAllowUnclampedScrollPosition(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAnimatedImageDebugCanvasDrawingEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMinimumTimerInterval(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlayback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlaybackAfterFullscreen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetInlineMediaPlaybackRequiresPlaysInlineAttribute(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFrameFlattening(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetIncompleteImageBorderEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseEventsWhenModifyingSelection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseOutAfterSyntheticClick(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetIndexedDBWorkersEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetWebGL2Enabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetWebGPUEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetScreenCaptureEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionUserInterfaceDirectionPolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetUserInterfaceDirectionPolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSystemLayoutDirection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSystemLayoutDirection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionDeferredCSSParserEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDeferredCSSParserEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldMockBoldSystemFontForAccessibility(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldManageAudioSessionCategory(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCustomPasteboardDataEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionWebAnimationsCSSIntegrationEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDeactivateAudioSession(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsInternalSettingsForcedColorsAreInvertedAccessibilityValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSInternalSettingsForcedColorsAreInvertedAccessibilityValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsInternalSettingsForcedDisplayIsMonochromeAccessibilityValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSInternalSettingsForcedDisplayIsMonochromeAccessibilityValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsInternalSettingsForcedPrefersReducedMotionAccessibilityValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSInternalSettingsForcedPrefersReducedMotionAccessibilityValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsInternalSettingsForcedSupportsHighDynamicRangeValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSInternalSettingsForcedSupportsHighDynamicRangeValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSInternalSettingsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInternalSettingsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInternalSettingsPrototype* ptr = new (NotNull, JSC::allocateCell<JSInternalSettingsPrototype>(vm.heap)) JSInternalSettingsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInternalSettingsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInternalSettingsPrototype, JSInternalSettingsPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInternalSettingsPrototypeTableValues[] =
{
    { "forcedColorsAreInvertedAccessibilityValue", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalSettingsForcedColorsAreInvertedAccessibilityValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSInternalSettingsForcedColorsAreInvertedAccessibilityValue) } },
    { "forcedDisplayIsMonochromeAccessibilityValue", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalSettingsForcedDisplayIsMonochromeAccessibilityValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSInternalSettingsForcedDisplayIsMonochromeAccessibilityValue) } },
    { "forcedPrefersReducedMotionAccessibilityValue", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalSettingsForcedPrefersReducedMotionAccessibilityValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSInternalSettingsForcedPrefersReducedMotionAccessibilityValue) } },
    { "forcedSupportsHighDynamicRangeValue", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalSettingsForcedSupportsHighDynamicRangeValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSInternalSettingsForcedSupportsHighDynamicRangeValue) } },
    { "setTouchEventEmulationEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabled), (intptr_t) (1) } },
    { "setStandardFontFamily", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetStandardFontFamily), (intptr_t) (2) } },
    { "setSerifFontFamily", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetSerifFontFamily), (intptr_t) (2) } },
    { "setSansSerifFontFamily", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetSansSerifFontFamily), (intptr_t) (2) } },
    { "setFixedFontFamily", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetFixedFontFamily), (intptr_t) (2) } },
    { "setCursiveFontFamily", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetCursiveFontFamily), (intptr_t) (2) } },
    { "setFantasyFontFamily", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetFantasyFontFamily), (intptr_t) (2) } },
    { "setPictographFontFamily", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetPictographFontFamily), (intptr_t) (2) } },
    { "setFontFallbackPrefersPictographs", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetFontFallbackPrefersPictographs), (intptr_t) (1) } },
    { "setFontLoadTimingOverride", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetFontLoadTimingOverride), (intptr_t) (1) } },
    { "setShouldIgnoreFontLoadCompletions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldIgnoreFontLoadCompletions), (intptr_t) (1) } },
    { "setTextAutosizingEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabled), (intptr_t) (1) } },
    { "setTextAutosizingWindowSizeOverride", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverride), (intptr_t) (2) } },
    { "setTextAutosizingUsesIdempotentMode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingUsesIdempotentMode), (intptr_t) (1) } },
    { "setCanStartMedia", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetCanStartMedia), (intptr_t) (1) } },
#if ENABLE(VIDEO_TRACK)
    { "setShouldDisplayTrackKind", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKind), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "shouldDisplayTrackKind", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionShouldDisplayTrackKind), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "setDefaultVideoPosterURL", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetDefaultVideoPosterURL), (intptr_t) (1) } },
    { "setTimeWithoutMouseMovementBeforeHidingControls", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetTimeWithoutMouseMovementBeforeHidingControls), (intptr_t) (1) } },
    { "setMediaTypeOverride", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetMediaTypeOverride), (intptr_t) (1) } },
    { "setAllowsAirPlayForMediaPlayback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetAllowsAirPlayForMediaPlayback), (intptr_t) (1) } },
#if ENABLE(MEDIA_STREAM)
    { "setMediaCaptureRequiresSecureConnection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetMediaCaptureRequiresSecureConnection), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "setForcePendingWebGLPolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetForcePendingWebGLPolicy), (intptr_t) (1) } },
    { "setQuickTimePluginReplacementEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetQuickTimePluginReplacementEnabled), (intptr_t) (1) } },
    { "setYouTubeFlashPluginReplacementEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetYouTubeFlashPluginReplacementEnabled), (intptr_t) (1) } },
    { "setEditingBehavior", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetEditingBehavior), (intptr_t) (1) } },
    { "setShouldConvertPositionStyleOnCopy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldConvertPositionStyleOnCopy), (intptr_t) (1) } },
    { "setPreferMIMETypeForImages", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetPreferMIMETypeForImages), (intptr_t) (1) } },
    { "setUseDarkAppearance", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetUseDarkAppearance), (intptr_t) (1) } },
    { "setStorageBlockingPolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicy), (intptr_t) (1) } },
    { "setImagesEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetImagesEnabled), (intptr_t) (1) } },
    { "setPDFImageCachingPolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetPDFImageCachingPolicy), (intptr_t) (1) } },
    { "setUseLegacyBackgroundSizeShorthandBehavior", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehavior), (intptr_t) (1) } },
    { "setAutoscrollForDragAndDropEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetAutoscrollForDragAndDropEnabled), (intptr_t) (1) } },
    { "setBackgroundShouldExtendBeyondPage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetBackgroundShouldExtendBeyondPage), (intptr_t) (1) } },
    { "setScrollingTreeIncludesFrames", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetScrollingTreeIncludesFrames), (intptr_t) (1) } },
    { "setAllowUnclampedScrollPosition", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetAllowUnclampedScrollPosition), (intptr_t) (1) } },
    { "setAnimatedImageDebugCanvasDrawingEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetAnimatedImageDebugCanvasDrawingEnabled), (intptr_t) (1) } },
    { "setMinimumTimerInterval", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetMinimumTimerInterval), (intptr_t) (1) } },
    { "setAllowsInlineMediaPlayback", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlayback), (intptr_t) (1) } },
    { "setAllowsInlineMediaPlaybackAfterFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlaybackAfterFullscreen), (intptr_t) (1) } },
    { "setInlineMediaPlaybackRequiresPlaysInlineAttribute", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetInlineMediaPlaybackRequiresPlaysInlineAttribute), (intptr_t) (1) } },
    { "setFrameFlattening", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetFrameFlattening), (intptr_t) (1) } },
    { "setIncompleteImageBorderEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetIncompleteImageBorderEnabled), (intptr_t) (1) } },
    { "setShouldDispatchSyntheticMouseEventsWhenModifyingSelection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseEventsWhenModifyingSelection), (intptr_t) (1) } },
    { "setShouldDispatchSyntheticMouseOutAfterSyntheticClick", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseOutAfterSyntheticClick), (intptr_t) (1) } },
    { "setIndexedDBWorkersEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetIndexedDBWorkersEnabled), (intptr_t) (1) } },
    { "setWebGL2Enabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetWebGL2Enabled), (intptr_t) (1) } },
    { "setWebGPUEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetWebGPUEnabled), (intptr_t) (1) } },
    { "setScreenCaptureEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetScreenCaptureEnabled), (intptr_t) (1) } },
    { "userInterfaceDirectionPolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionUserInterfaceDirectionPolicy), (intptr_t) (0) } },
    { "setUserInterfaceDirectionPolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetUserInterfaceDirectionPolicy), (intptr_t) (1) } },
    { "systemLayoutDirection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSystemLayoutDirection), (intptr_t) (0) } },
    { "setSystemLayoutDirection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetSystemLayoutDirection), (intptr_t) (1) } },
    { "deferredCSSParserEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionDeferredCSSParserEnabled), (intptr_t) (0) } },
    { "setDeferredCSSParserEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetDeferredCSSParserEnabled), (intptr_t) (1) } },
    { "setShouldMockBoldSystemFontForAccessibility", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldMockBoldSystemFontForAccessibility), (intptr_t) (1) } },
    { "setShouldManageAudioSessionCategory", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldManageAudioSessionCategory), (intptr_t) (1) } },
    { "setCustomPasteboardDataEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetCustomPasteboardDataEnabled), (intptr_t) (1) } },
    { "webAnimationsCSSIntegrationEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionWebAnimationsCSSIntegrationEnabled), (intptr_t) (0) } },
    { "setShouldDeactivateAudioSession", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldDeactivateAudioSession), (intptr_t) (1) } },
};

const ClassInfo JSInternalSettingsPrototype::s_info = { "InternalSettingsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInternalSettingsPrototype) };

void JSInternalSettingsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInternalSettings::info(), JSInternalSettingsPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webAnimationsCSSIntegrationEnabled"), strlen("webAnimationsCSSIntegrationEnabled"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSInternalSettings::s_info = { "InternalSettings", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInternalSettings) };

JSInternalSettings::JSInternalSettings(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InternalSettings>&& impl)
    : JSInternalSettingsGenerated(structure, globalObject, WTFMove(impl))
{
}

void JSInternalSettings::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, InternalSettings>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSInternalSettings::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSInternalSettingsPrototype::create(vm, &globalObject, JSInternalSettingsPrototype::createStructure(vm, &globalObject, JSInternalSettingsGenerated::prototype(vm, globalObject)));
}

JSObject* JSInternalSettings::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInternalSettings>(vm, globalObject);
}

template<> inline JSInternalSettings* IDLAttribute<JSInternalSettings>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSInternalSettings*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSInternalSettings* IDLOperation<JSInternalSettings>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSInternalSettings*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsInternalSettingsForcedColorsAreInvertedAccessibilityValueGetter(JSGlobalObject& lexicalGlobalObject, JSInternalSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<InternalSettings::ForcedAccessibilityValue>>(lexicalGlobalObject, throwScope, impl.forcedColorsAreInvertedAccessibilityValue());
    return result;
}

EncodedJSValue jsInternalSettingsForcedColorsAreInvertedAccessibilityValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternalSettings>::get<jsInternalSettingsForcedColorsAreInvertedAccessibilityValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "forcedColorsAreInvertedAccessibilityValue");
}

static inline bool setJSInternalSettingsForcedColorsAreInvertedAccessibilityValueSetter(JSGlobalObject& lexicalGlobalObject, JSInternalSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<InternalSettings::ForcedAccessibilityValue>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setForcedColorsAreInvertedAccessibilityValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSInternalSettingsForcedColorsAreInvertedAccessibilityValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSInternalSettings>::set<setJSInternalSettingsForcedColorsAreInvertedAccessibilityValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "forcedColorsAreInvertedAccessibilityValue");
}

static inline JSValue jsInternalSettingsForcedDisplayIsMonochromeAccessibilityValueGetter(JSGlobalObject& lexicalGlobalObject, JSInternalSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<InternalSettings::ForcedAccessibilityValue>>(lexicalGlobalObject, throwScope, impl.forcedDisplayIsMonochromeAccessibilityValue());
    return result;
}

EncodedJSValue jsInternalSettingsForcedDisplayIsMonochromeAccessibilityValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternalSettings>::get<jsInternalSettingsForcedDisplayIsMonochromeAccessibilityValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "forcedDisplayIsMonochromeAccessibilityValue");
}

static inline bool setJSInternalSettingsForcedDisplayIsMonochromeAccessibilityValueSetter(JSGlobalObject& lexicalGlobalObject, JSInternalSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<InternalSettings::ForcedAccessibilityValue>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setForcedDisplayIsMonochromeAccessibilityValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSInternalSettingsForcedDisplayIsMonochromeAccessibilityValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSInternalSettings>::set<setJSInternalSettingsForcedDisplayIsMonochromeAccessibilityValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "forcedDisplayIsMonochromeAccessibilityValue");
}

static inline JSValue jsInternalSettingsForcedPrefersReducedMotionAccessibilityValueGetter(JSGlobalObject& lexicalGlobalObject, JSInternalSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<InternalSettings::ForcedAccessibilityValue>>(lexicalGlobalObject, throwScope, impl.forcedPrefersReducedMotionAccessibilityValue());
    return result;
}

EncodedJSValue jsInternalSettingsForcedPrefersReducedMotionAccessibilityValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternalSettings>::get<jsInternalSettingsForcedPrefersReducedMotionAccessibilityValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "forcedPrefersReducedMotionAccessibilityValue");
}

static inline bool setJSInternalSettingsForcedPrefersReducedMotionAccessibilityValueSetter(JSGlobalObject& lexicalGlobalObject, JSInternalSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<InternalSettings::ForcedAccessibilityValue>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setForcedPrefersReducedMotionAccessibilityValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSInternalSettingsForcedPrefersReducedMotionAccessibilityValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSInternalSettings>::set<setJSInternalSettingsForcedPrefersReducedMotionAccessibilityValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "forcedPrefersReducedMotionAccessibilityValue");
}

static inline JSValue jsInternalSettingsForcedSupportsHighDynamicRangeValueGetter(JSGlobalObject& lexicalGlobalObject, JSInternalSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<InternalSettings::ForcedAccessibilityValue>>(lexicalGlobalObject, throwScope, impl.forcedSupportsHighDynamicRangeValue());
    return result;
}

EncodedJSValue jsInternalSettingsForcedSupportsHighDynamicRangeValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternalSettings>::get<jsInternalSettingsForcedSupportsHighDynamicRangeValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "forcedSupportsHighDynamicRangeValue");
}

static inline bool setJSInternalSettingsForcedSupportsHighDynamicRangeValueSetter(JSGlobalObject& lexicalGlobalObject, JSInternalSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<InternalSettings::ForcedAccessibilityValue>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setForcedSupportsHighDynamicRangeValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSInternalSettingsForcedSupportsHighDynamicRangeValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSInternalSettings>::set<setJSInternalSettingsForcedSupportsHighDynamicRangeValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "forcedSupportsHighDynamicRangeValue");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setTouchEventEmulationEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabledBody>(*lexicalGlobalObject, *callFrame, "setTouchEventEmulationEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetStandardFontFamilyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto family = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto script = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setStandardFontFamily(WTFMove(family), WTFMove(script)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStandardFontFamily(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetStandardFontFamilyBody>(*lexicalGlobalObject, *callFrame, "setStandardFontFamily");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetSerifFontFamilyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto family = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto script = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setSerifFontFamily(WTFMove(family), WTFMove(script)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSerifFontFamily(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetSerifFontFamilyBody>(*lexicalGlobalObject, *callFrame, "setSerifFontFamily");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetSansSerifFontFamilyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto family = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto script = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setSansSerifFontFamily(WTFMove(family), WTFMove(script)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSansSerifFontFamily(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetSansSerifFontFamilyBody>(*lexicalGlobalObject, *callFrame, "setSansSerifFontFamily");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetFixedFontFamilyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto family = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto script = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setFixedFontFamily(WTFMove(family), WTFMove(script)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFixedFontFamily(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetFixedFontFamilyBody>(*lexicalGlobalObject, *callFrame, "setFixedFontFamily");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetCursiveFontFamilyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto family = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto script = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setCursiveFontFamily(WTFMove(family), WTFMove(script)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCursiveFontFamily(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetCursiveFontFamilyBody>(*lexicalGlobalObject, *callFrame, "setCursiveFontFamily");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetFantasyFontFamilyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto family = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto script = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setFantasyFontFamily(WTFMove(family), WTFMove(script)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFantasyFontFamily(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetFantasyFontFamilyBody>(*lexicalGlobalObject, *callFrame, "setFantasyFontFamily");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetPictographFontFamilyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto family = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto script = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPictographFontFamily(WTFMove(family), WTFMove(script)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPictographFontFamily(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetPictographFontFamilyBody>(*lexicalGlobalObject, *callFrame, "setPictographFontFamily");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetFontFallbackPrefersPictographsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto preferPictographs = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setFontFallbackPrefersPictographs(WTFMove(preferPictographs)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFontFallbackPrefersPictographs(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetFontFallbackPrefersPictographsBody>(*lexicalGlobalObject, *callFrame, "setFontFallbackPrefersPictographs");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetFontLoadTimingOverrideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto override = convert<IDLEnumeration<InternalSettings::FontLoadTimingOverride>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "override", "InternalSettings", "setFontLoadTimingOverride", expectedEnumerationValues<InternalSettings::FontLoadTimingOverride>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setFontLoadTimingOverride(WTFMove(override)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFontLoadTimingOverride(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetFontLoadTimingOverrideBody>(*lexicalGlobalObject, *callFrame, "setFontLoadTimingOverride");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetShouldIgnoreFontLoadCompletionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto ignore = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setShouldIgnoreFontLoadCompletions(WTFMove(ignore)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldIgnoreFontLoadCompletions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetShouldIgnoreFontLoadCompletionsBody>(*lexicalGlobalObject, *callFrame, "setShouldIgnoreFontLoadCompletions");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setTextAutosizingEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabledBody>(*lexicalGlobalObject, *callFrame, "setTextAutosizingEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverrideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setTextAutosizingWindowSizeOverride(WTFMove(width), WTFMove(height)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverride(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverrideBody>(*lexicalGlobalObject, *callFrame, "setTextAutosizingWindowSizeOverride");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetTextAutosizingUsesIdempotentModeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setTextAutosizingUsesIdempotentMode(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingUsesIdempotentMode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetTextAutosizingUsesIdempotentModeBody>(*lexicalGlobalObject, *callFrame, "setTextAutosizingUsesIdempotentMode");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetCanStartMediaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setCanStartMedia(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCanStartMedia(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetCanStartMediaBody>(*lexicalGlobalObject, *callFrame, "setCanStartMedia");
}

#if ENABLE(VIDEO_TRACK)
static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKindBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto kind = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setShouldDisplayTrackKind(WTFMove(kind), WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKind(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKindBody>(*lexicalGlobalObject, *callFrame, "setShouldDisplayTrackKind");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionShouldDisplayTrackKindBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto trackKind = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.shouldDisplayTrackKind(WTFMove(trackKind))));
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionShouldDisplayTrackKind(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionShouldDisplayTrackKindBody>(*lexicalGlobalObject, *callFrame, "shouldDisplayTrackKind");
}

#endif

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetDefaultVideoPosterURLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto poster = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setDefaultVideoPosterURL(WTFMove(poster)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDefaultVideoPosterURL(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetDefaultVideoPosterURLBody>(*lexicalGlobalObject, *callFrame, "setDefaultVideoPosterURL");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetTimeWithoutMouseMovementBeforeHidingControlsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto time = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setTimeWithoutMouseMovementBeforeHidingControls(WTFMove(time)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTimeWithoutMouseMovementBeforeHidingControls(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetTimeWithoutMouseMovementBeforeHidingControlsBody>(*lexicalGlobalObject, *callFrame, "setTimeWithoutMouseMovementBeforeHidingControls");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetMediaTypeOverrideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mediaTypeOverride = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setMediaTypeOverride(WTFMove(mediaTypeOverride)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMediaTypeOverride(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetMediaTypeOverrideBody>(*lexicalGlobalObject, *callFrame, "setMediaTypeOverride");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetAllowsAirPlayForMediaPlaybackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto available = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAllowsAirPlayForMediaPlayback(WTFMove(available));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAllowsAirPlayForMediaPlayback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetAllowsAirPlayForMediaPlaybackBody>(*lexicalGlobalObject, *callFrame, "setAllowsAirPlayForMediaPlayback");
}

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetMediaCaptureRequiresSecureConnectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enable = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setMediaCaptureRequiresSecureConnection(WTFMove(enable)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMediaCaptureRequiresSecureConnection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetMediaCaptureRequiresSecureConnectionBody>(*lexicalGlobalObject, *callFrame, "setMediaCaptureRequiresSecureConnection");
}

#endif

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetForcePendingWebGLPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto forced = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setForcePendingWebGLPolicy(WTFMove(forced)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetForcePendingWebGLPolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetForcePendingWebGLPolicyBody>(*lexicalGlobalObject, *callFrame, "setForcePendingWebGLPolicy");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetQuickTimePluginReplacementEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setQuickTimePluginReplacementEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetQuickTimePluginReplacementEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetQuickTimePluginReplacementEnabledBody>(*lexicalGlobalObject, *callFrame, "setQuickTimePluginReplacementEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetYouTubeFlashPluginReplacementEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setYouTubeFlashPluginReplacementEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetYouTubeFlashPluginReplacementEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetYouTubeFlashPluginReplacementEnabledBody>(*lexicalGlobalObject, *callFrame, "setYouTubeFlashPluginReplacementEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetEditingBehaviorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto behavior = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setEditingBehavior(WTFMove(behavior)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetEditingBehavior(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetEditingBehaviorBody>(*lexicalGlobalObject, *callFrame, "setEditingBehavior");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetShouldConvertPositionStyleOnCopyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto convertPosition = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setShouldConvertPositionStyleOnCopy(WTFMove(convertPosition)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldConvertPositionStyleOnCopy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetShouldConvertPositionStyleOnCopyBody>(*lexicalGlobalObject, *callFrame, "setShouldConvertPositionStyleOnCopy");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetPreferMIMETypeForImagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto preferMimeTypeForImage = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPreferMIMETypeForImages(WTFMove(preferMimeTypeForImage)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPreferMIMETypeForImages(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetPreferMIMETypeForImagesBody>(*lexicalGlobalObject, *callFrame, "setPreferMIMETypeForImages");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetUseDarkAppearanceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setUseDarkAppearance(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetUseDarkAppearance(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetUseDarkAppearanceBody>(*lexicalGlobalObject, *callFrame, "setUseDarkAppearance");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto policy = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setStorageBlockingPolicy(WTFMove(policy)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicyBody>(*lexicalGlobalObject, *callFrame, "setStorageBlockingPolicy");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetImagesEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setImagesEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetImagesEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetImagesEnabledBody>(*lexicalGlobalObject, *callFrame, "setImagesEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetPDFImageCachingPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto policy = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPDFImageCachingPolicy(WTFMove(policy)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPDFImageCachingPolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetPDFImageCachingPolicyBody>(*lexicalGlobalObject, *callFrame, "setPDFImageCachingPolicy");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehaviorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setUseLegacyBackgroundSizeShorthandBehavior(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehavior(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetUseLegacyBackgroundSizeShorthandBehaviorBody>(*lexicalGlobalObject, *callFrame, "setUseLegacyBackgroundSizeShorthandBehavior");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetAutoscrollForDragAndDropEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setAutoscrollForDragAndDropEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAutoscrollForDragAndDropEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetAutoscrollForDragAndDropEnabledBody>(*lexicalGlobalObject, *callFrame, "setAutoscrollForDragAndDropEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetBackgroundShouldExtendBeyondPageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto hasExtendedBackground = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setBackgroundShouldExtendBeyondPage(WTFMove(hasExtendedBackground)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetBackgroundShouldExtendBeyondPage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetBackgroundShouldExtendBeyondPageBody>(*lexicalGlobalObject, *callFrame, "setBackgroundShouldExtendBeyondPage");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetScrollingTreeIncludesFramesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setScrollingTreeIncludesFrames(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetScrollingTreeIncludesFrames(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetScrollingTreeIncludesFramesBody>(*lexicalGlobalObject, *callFrame, "setScrollingTreeIncludesFrames");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetAllowUnclampedScrollPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto allowUnclamped = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setAllowUnclampedScrollPosition(WTFMove(allowUnclamped)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAllowUnclampedScrollPosition(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetAllowUnclampedScrollPositionBody>(*lexicalGlobalObject, *callFrame, "setAllowUnclampedScrollPosition");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetAnimatedImageDebugCanvasDrawingEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enable = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setAnimatedImageDebugCanvasDrawingEnabled(WTFMove(enable)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAnimatedImageDebugCanvasDrawingEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetAnimatedImageDebugCanvasDrawingEnabledBody>(*lexicalGlobalObject, *callFrame, "setAnimatedImageDebugCanvasDrawingEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetMinimumTimerIntervalBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto intervalInSeconds = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setMinimumTimerInterval(WTFMove(intervalInSeconds)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMinimumTimerInterval(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetMinimumTimerIntervalBody>(*lexicalGlobalObject, *callFrame, "setMinimumTimerInterval");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlaybackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto allows = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setAllowsInlineMediaPlayback(WTFMove(allows)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlayback(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlaybackBody>(*lexicalGlobalObject, *callFrame, "setAllowsInlineMediaPlayback");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlaybackAfterFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto allows = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setAllowsInlineMediaPlaybackAfterFullscreen(WTFMove(allows)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlaybackAfterFullscreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetAllowsInlineMediaPlaybackAfterFullscreenBody>(*lexicalGlobalObject, *callFrame, "setAllowsInlineMediaPlaybackAfterFullscreen");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetInlineMediaPlaybackRequiresPlaysInlineAttributeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto requires = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setInlineMediaPlaybackRequiresPlaysInlineAttribute(WTFMove(requires)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetInlineMediaPlaybackRequiresPlaysInlineAttribute(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetInlineMediaPlaybackRequiresPlaysInlineAttributeBody>(*lexicalGlobalObject, *callFrame, "setInlineMediaPlaybackRequiresPlaysInlineAttribute");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetFrameFlatteningBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto frameFlattening = convert<IDLEnumeration<InternalSettings::FrameFlatteningValue>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "frameFlattening", "InternalSettings", "setFrameFlattening", expectedEnumerationValues<InternalSettings::FrameFlatteningValue>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setFrameFlattening(WTFMove(frameFlattening)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFrameFlattening(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetFrameFlatteningBody>(*lexicalGlobalObject, *callFrame, "setFrameFlattening");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetIncompleteImageBorderEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setIncompleteImageBorderEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetIncompleteImageBorderEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetIncompleteImageBorderEnabledBody>(*lexicalGlobalObject, *callFrame, "setIncompleteImageBorderEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseEventsWhenModifyingSelectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shouldDispatch = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setShouldDispatchSyntheticMouseEventsWhenModifyingSelection(WTFMove(shouldDispatch)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseEventsWhenModifyingSelection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseEventsWhenModifyingSelectionBody>(*lexicalGlobalObject, *callFrame, "setShouldDispatchSyntheticMouseEventsWhenModifyingSelection");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseOutAfterSyntheticClickBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shouldDispatch = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setShouldDispatchSyntheticMouseOutAfterSyntheticClick(WTFMove(shouldDispatch)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseOutAfterSyntheticClick(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetShouldDispatchSyntheticMouseOutAfterSyntheticClickBody>(*lexicalGlobalObject, *callFrame, "setShouldDispatchSyntheticMouseOutAfterSyntheticClick");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetIndexedDBWorkersEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setIndexedDBWorkersEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetIndexedDBWorkersEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetIndexedDBWorkersEnabledBody>(*lexicalGlobalObject, *callFrame, "setIndexedDBWorkersEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetWebGL2EnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setWebGL2Enabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetWebGL2Enabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetWebGL2EnabledBody>(*lexicalGlobalObject, *callFrame, "setWebGL2Enabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetWebGPUEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setWebGPUEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetWebGPUEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetWebGPUEnabledBody>(*lexicalGlobalObject, *callFrame, "setWebGPUEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetScreenCaptureEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setScreenCaptureEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetScreenCaptureEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetScreenCaptureEnabledBody>(*lexicalGlobalObject, *callFrame, "setScreenCaptureEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionUserInterfaceDirectionPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.userInterfaceDirectionPolicy()));
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionUserInterfaceDirectionPolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionUserInterfaceDirectionPolicyBody>(*lexicalGlobalObject, *callFrame, "userInterfaceDirectionPolicy");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetUserInterfaceDirectionPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto policy = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setUserInterfaceDirectionPolicy(WTFMove(policy)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetUserInterfaceDirectionPolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetUserInterfaceDirectionPolicyBody>(*lexicalGlobalObject, *callFrame, "setUserInterfaceDirectionPolicy");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSystemLayoutDirectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.systemLayoutDirection()));
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSystemLayoutDirection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSystemLayoutDirectionBody>(*lexicalGlobalObject, *callFrame, "systemLayoutDirection");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetSystemLayoutDirectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto direction = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setSystemLayoutDirection(WTFMove(direction)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSystemLayoutDirection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetSystemLayoutDirectionBody>(*lexicalGlobalObject, *callFrame, "setSystemLayoutDirection");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionDeferredCSSParserEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.deferredCSSParserEnabled()));
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionDeferredCSSParserEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionDeferredCSSParserEnabledBody>(*lexicalGlobalObject, *callFrame, "deferredCSSParserEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetDeferredCSSParserEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setDeferredCSSParserEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDeferredCSSParserEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetDeferredCSSParserEnabledBody>(*lexicalGlobalObject, *callFrame, "setDeferredCSSParserEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetShouldMockBoldSystemFontForAccessibilityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shouldMock = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setShouldMockBoldSystemFontForAccessibility(WTFMove(shouldMock)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldMockBoldSystemFontForAccessibility(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetShouldMockBoldSystemFontForAccessibilityBody>(*lexicalGlobalObject, *callFrame, "setShouldMockBoldSystemFontForAccessibility");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetShouldManageAudioSessionCategoryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto should = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setShouldManageAudioSessionCategory(WTFMove(should)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldManageAudioSessionCategory(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetShouldManageAudioSessionCategoryBody>(*lexicalGlobalObject, *callFrame, "setShouldManageAudioSessionCategory");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetCustomPasteboardDataEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setCustomPasteboardDataEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCustomPasteboardDataEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetCustomPasteboardDataEnabledBody>(*lexicalGlobalObject, *callFrame, "setCustomPasteboardDataEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionWebAnimationsCSSIntegrationEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.webAnimationsCSSIntegrationEnabled()));
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionWebAnimationsCSSIntegrationEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionWebAnimationsCSSIntegrationEnabledBody>(*lexicalGlobalObject, *callFrame, "webAnimationsCSSIntegrationEnabled");
}

static inline JSC::EncodedJSValue jsInternalSettingsPrototypeFunctionSetShouldDeactivateAudioSessionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternalSettings>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shouldDeactivate = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setShouldDeactivateAudioSession(WTFMove(shouldDeactivate));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDeactivateAudioSession(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternalSettings>::call<jsInternalSettingsPrototypeFunctionSetShouldDeactivateAudioSessionBody>(*lexicalGlobalObject, *callFrame, "setShouldDeactivateAudioSession");
}

void JSInternalSettings::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInternalSettings*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7InternalSettings@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16InternalSettingsE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InternalSettings>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7InternalSettings@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16InternalSettingsE[2];
#endif

    // If this fails InternalSettings does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<InternalSettings>::value, "InternalSettings is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // InternalSettings has subclasses. If InternalSettings has subclasses that get passed
    // to toJS() we currently require InternalSettings you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<InternalSettings>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InternalSettings& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
