/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyframeEffectOptions.h"

#include "JSCompositeOperation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSFillMode.h"
#include "JSIterationCompositeOperation.h"
#include "JSPlaybackDirection.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

template<> KeyframeEffectOptions convertDictionary<KeyframeEffectOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    KeyframeEffectOptions result;
    JSValue delayValue;
    if (isNullOrUndefined)
        delayValue = jsUndefined();
    else {
        delayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delay"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!delayValue.isUndefined()) {
        result.delay = convert<IDLDouble>(lexicalGlobalObject, delayValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.delay = 0;
    JSValue directionValue;
    if (isNullOrUndefined)
        directionValue = jsUndefined();
    else {
        directionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "direction"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!directionValue.isUndefined()) {
        result.direction = convert<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, directionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.direction = PlaybackDirection::Normal;
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!durationValue.isUndefined()) {
        result.duration = convert<IDLUnion<IDLUnrestrictedDouble, IDLDOMString>>(lexicalGlobalObject, durationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.duration = "auto";
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLDOMString>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.easing = "linear"_s;
    JSValue endDelayValue;
    if (isNullOrUndefined)
        endDelayValue = jsUndefined();
    else {
        endDelayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endDelay"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!endDelayValue.isUndefined()) {
        result.endDelay = convert<IDLDouble>(lexicalGlobalObject, endDelayValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.endDelay = 0;
    JSValue fillValue;
    if (isNullOrUndefined)
        fillValue = jsUndefined();
    else {
        fillValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fill"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fillValue.isUndefined()) {
        result.fill = convert<IDLEnumeration<FillMode>>(lexicalGlobalObject, fillValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.fill = FillMode::Auto;
    JSValue iterationStartValue;
    if (isNullOrUndefined)
        iterationStartValue = jsUndefined();
    else {
        iterationStartValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterationStart"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iterationStartValue.isUndefined()) {
        result.iterationStart = convert<IDLDouble>(lexicalGlobalObject, iterationStartValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.iterationStart = 0.0;
    JSValue iterationsValue;
    if (isNullOrUndefined)
        iterationsValue = jsUndefined();
    else {
        iterationsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterations"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iterationsValue.isUndefined()) {
        result.iterations = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, iterationsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.iterations = 1.0;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compositeValue.isUndefined()) {
        result.composite = convert<IDLEnumeration<CompositeOperation>>(lexicalGlobalObject, compositeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composite = CompositeOperation::Replace;
    JSValue iterationCompositeValue;
    if (isNullOrUndefined)
        iterationCompositeValue = jsUndefined();
    else {
        iterationCompositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterationComposite"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!iterationCompositeValue.isUndefined()) {
        result.iterationComposite = convert<IDLEnumeration<IterationCompositeOperation>>(lexicalGlobalObject, iterationCompositeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.iterationComposite = IterationCompositeOperation::Replace;
    return result;
}

} // namespace WebCore
