/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMallocStatistics.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsMallocStatisticsReservedVMBytes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMallocStatisticsCommittedVMBytes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMallocStatisticsFreeListBytes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMallocStatisticsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMallocStatisticsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMallocStatisticsPrototype* ptr = new (NotNull, JSC::allocateCell<JSMallocStatisticsPrototype>(vm.heap)) JSMallocStatisticsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMallocStatisticsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMallocStatisticsPrototype, JSMallocStatisticsPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSMallocStatisticsPrototypeTableValues[] =
{
    { "reservedVMBytes", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMallocStatisticsReservedVMBytes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "committedVMBytes", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMallocStatisticsCommittedVMBytes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "freeListBytes", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMallocStatisticsFreeListBytes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMallocStatisticsPrototype::s_info = { "MallocStatisticsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMallocStatisticsPrototype) };

void JSMallocStatisticsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMallocStatistics::info(), JSMallocStatisticsPrototypeTableValues, *this);
}

const ClassInfo JSMallocStatistics::s_info = { "MallocStatistics", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMallocStatistics) };

JSMallocStatistics::JSMallocStatistics(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MallocStatistics>&& impl)
    : JSDOMWrapper<MallocStatistics>(structure, globalObject, WTFMove(impl))
{
}

void JSMallocStatistics::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MallocStatistics>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMallocStatistics::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMallocStatisticsPrototype::create(vm, &globalObject, JSMallocStatisticsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMallocStatistics::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMallocStatistics>(vm, globalObject);
}

void JSMallocStatistics::destroy(JSC::JSCell* cell)
{
    JSMallocStatistics* thisObject = static_cast<JSMallocStatistics*>(cell);
    thisObject->JSMallocStatistics::~JSMallocStatistics();
}

template<> inline JSMallocStatistics* IDLAttribute<JSMallocStatistics>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMallocStatistics*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

static inline JSValue jsMallocStatisticsReservedVMBytesGetter(JSGlobalObject& lexicalGlobalObject, JSMallocStatistics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.reservedVMBytes());
    return result;
}

EncodedJSValue jsMallocStatisticsReservedVMBytes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMallocStatistics>::get<jsMallocStatisticsReservedVMBytesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "reservedVMBytes");
}

static inline JSValue jsMallocStatisticsCommittedVMBytesGetter(JSGlobalObject& lexicalGlobalObject, JSMallocStatistics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.committedVMBytes());
    return result;
}

EncodedJSValue jsMallocStatisticsCommittedVMBytes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMallocStatistics>::get<jsMallocStatisticsCommittedVMBytesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "committedVMBytes");
}

static inline JSValue jsMallocStatisticsFreeListBytesGetter(JSGlobalObject& lexicalGlobalObject, JSMallocStatistics& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.freeListBytes());
    return result;
}

EncodedJSValue jsMallocStatisticsFreeListBytes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMallocStatistics>::get<jsMallocStatisticsFreeListBytesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "freeListBytes");
}

void JSMallocStatistics::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMallocStatistics*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMallocStatisticsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMallocStatisticsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMallocStatistics = static_cast<JSMallocStatistics*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMallocStatistics->wrapped(), jsMallocStatistics);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MallocStatistics>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MallocStatistics.
    static_assert(!std::is_polymorphic<MallocStatistics>::value, "MallocStatistics is polymorphic but the IDL claims it is not");
    return createWrapper<MallocStatistics>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MallocStatistics& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MallocStatistics* JSMallocStatistics::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMallocStatistics*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
