/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaEncodingConfiguration.h"

#include "JSAudioConfiguration.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMGlobalObject.h"
#include "JSMediaEncodingType.h"
#include "JSVideoConfiguration.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> MediaEncodingConfiguration convertDictionary<MediaEncodingConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaEncodingConfiguration result;
    JSValue audioValue;
    if (isNullOrUndefined)
        audioValue = jsUndefined();
    else {
        audioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audio"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!audioValue.isUndefined()) {
        result.audio = convert<IDLDictionary<AudioConfiguration>>(lexicalGlobalObject, audioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue videoValue;
    if (isNullOrUndefined)
        videoValue = jsUndefined();
    else {
        videoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "video"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!videoValue.isUndefined()) {
        result.video = convert<IDLDictionary<VideoConfiguration>>(lexicalGlobalObject, videoValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<MediaEncodingType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "type", "MediaEncodingConfiguration", "MediaEncodingType");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaEncodingConfiguration& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDictionary<AudioConfiguration>::isNullValue(dictionary.audio)) {
        auto audioValue = toJS<IDLDictionary<AudioConfiguration>>(lexicalGlobalObject, globalObject, IDLDictionary<AudioConfiguration>::extractValueFromNullable(dictionary.audio));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "audio"), audioValue);
    }
    if (!IDLDictionary<VideoConfiguration>::isNullValue(dictionary.video)) {
        auto videoValue = toJS<IDLDictionary<VideoConfiguration>>(lexicalGlobalObject, globalObject, IDLDictionary<VideoConfiguration>::extractValueFromNullable(dictionary.video));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "video"), videoValue);
    }
    auto typeValue = toJS<IDLEnumeration<MediaEncodingType>>(lexicalGlobalObject, dictionary.type);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "type"), typeValue);
    return result;
}

} // namespace WebCore
