/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSMediaError.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsMediaErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaErrorCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMediaErrorPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaErrorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaErrorPrototype>(vm.heap)) JSMediaErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaErrorPrototype, JSMediaErrorPrototype::Base);

using JSMediaErrorConstructor = JSDOMConstructorNotConstructable<JSMediaError>;

/* Hash table for constructor */

static const HashTableValue JSMediaErrorConstructorTableValues[] =
{
    { "MEDIA_ERR_ABORTED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "MEDIA_ERR_NETWORK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "MEDIA_ERR_DECODE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MEDIA_ERR_SRC_NOT_SUPPORTED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    { "MEDIA_ERR_ENCRYPTED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

static_assert(MediaError::MEDIA_ERR_ABORTED == 1, "MEDIA_ERR_ABORTED in MediaError does not match value from IDL");
static_assert(MediaError::MEDIA_ERR_NETWORK == 2, "MEDIA_ERR_NETWORK in MediaError does not match value from IDL");
static_assert(MediaError::MEDIA_ERR_DECODE == 3, "MEDIA_ERR_DECODE in MediaError does not match value from IDL");
static_assert(MediaError::MEDIA_ERR_SRC_NOT_SUPPORTED == 4, "MEDIA_ERR_SRC_NOT_SUPPORTED in MediaError does not match value from IDL");
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static_assert(MediaError::MEDIA_ERR_ENCRYPTED == 5, "MEDIA_ERR_ENCRYPTED in MediaError does not match value from IDL");
#endif

template<> JSValue JSMediaErrorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaErrorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaError::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaError"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSMediaError::info(), JSMediaErrorConstructorTableValues, *this);
}

template<> const ClassInfo JSMediaErrorConstructor::s_info = { "MediaError", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaErrorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaErrorPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaErrorConstructor) } },
    { "code", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "MEDIA_ERR_ABORTED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "MEDIA_ERR_NETWORK", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "MEDIA_ERR_DECODE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MEDIA_ERR_SRC_NOT_SUPPORTED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    { "MEDIA_ERR_ENCRYPTED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSMediaErrorPrototype::s_info = { "MediaErrorPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaErrorPrototype) };

void JSMediaErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaError::info(), JSMediaErrorPrototypeTableValues, *this);
}

const ClassInfo JSMediaError::s_info = { "MediaError", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaError) };

JSMediaError::JSMediaError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaError>&& impl)
    : JSDOMWrapper<MediaError>(structure, globalObject, WTFMove(impl))
{
}

void JSMediaError::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MediaError>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMediaError::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaErrorPrototype::create(vm, &globalObject, JSMediaErrorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMediaError::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaError>(vm, globalObject);
}

JSValue JSMediaError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaErrorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaError::destroy(JSC::JSCell* cell)
{
    JSMediaError* thisObject = static_cast<JSMediaError*>(cell);
    thisObject->JSMediaError::~JSMediaError();
}

template<> inline JSMediaError* IDLAttribute<JSMediaError>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaError*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsMediaErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaErrorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaError::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaErrorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaErrorCodeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaError& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.code());
    return result;
}

EncodedJSValue jsMediaErrorCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaError>::get<jsMediaErrorCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "code");
}

void JSMediaError::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaError*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaError = static_cast<JSMediaError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaError->wrapped(), jsMediaError);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaError>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MediaError.
    static_assert(!std::is_polymorphic<MediaError>::value, "MediaError is polymorphic but the IDL claims it is not");
    return createWrapper<MediaError>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaError& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaError* JSMediaError::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaError*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
