/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaRecorder.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSMediaStream.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaRecorder::RecordingState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("inactive"),
        MAKE_STATIC_STRING_IMPL("recording"),
        MAKE_STATIC_STRING_IMPL("paused"),
    };
    static_assert(static_cast<size_t>(MediaRecorder::RecordingState::Inactive) == 0, "MediaRecorder::RecordingState::Inactive is not 0 as expected");
    static_assert(static_cast<size_t>(MediaRecorder::RecordingState::Recording) == 1, "MediaRecorder::RecordingState::Recording is not 1 as expected");
    static_assert(static_cast<size_t>(MediaRecorder::RecordingState::Paused) == 2, "MediaRecorder::RecordingState::Paused is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MediaRecorder::RecordingState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MediaRecorder::RecordingState> parseEnumeration<MediaRecorder::RecordingState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "inactive")
        return MediaRecorder::RecordingState::Inactive;
    if (stringValue == "recording")
        return MediaRecorder::RecordingState::Recording;
    if (stringValue == "paused")
        return MediaRecorder::RecordingState::Paused;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MediaRecorder::RecordingState>()
{
    return "\"inactive\", \"recording\", \"paused\"";
}

template<> MediaRecorder::Options convertDictionary<MediaRecorder::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaRecorder::Options result;
    JSValue audioBitsPerSecondValue;
    if (isNullOrUndefined)
        audioBitsPerSecondValue = jsUndefined();
    else {
        audioBitsPerSecondValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audioBitsPerSecond"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!audioBitsPerSecondValue.isUndefined()) {
        result.audioBitsPerSecond = convert<IDLUnsignedLong>(lexicalGlobalObject, audioBitsPerSecondValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bitsPerSecondValue;
    if (isNullOrUndefined)
        bitsPerSecondValue = jsUndefined();
    else {
        bitsPerSecondValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitsPerSecond"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitsPerSecondValue.isUndefined()) {
        result.bitsPerSecond = convert<IDLUnsignedLong>(lexicalGlobalObject, bitsPerSecondValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue mimeTypeValue;
    if (isNullOrUndefined)
        mimeTypeValue = jsUndefined();
    else {
        mimeTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mimeType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mimeTypeValue.isUndefined()) {
        result.mimeType = convert<IDLDOMString>(lexicalGlobalObject, mimeTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue videoBitsPerSecondValue;
    if (isNullOrUndefined)
        videoBitsPerSecondValue = jsUndefined();
    else {
        videoBitsPerSecondValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "videoBitsPerSecond"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!videoBitsPerSecondValue.isUndefined()) {
        result.videoBitsPerSecond = convert<IDLUnsignedLong>(lexicalGlobalObject, videoBitsPerSecondValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaRecorderPrototypeFunctionStart(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaRecorderPrototypeFunctionStop(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaRecorderPrototypeFunctionRequestData(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMediaRecorderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRecorderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaRecorderState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaRecorderStream(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaRecorderOnstop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRecorderOnstop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaRecorderOndataavailable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRecorderOndataavailable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaRecorderOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRecorderOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaRecorderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaRecorderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaRecorderPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaRecorderPrototype>(vm.heap)) JSMediaRecorderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaRecorderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaRecorderPrototype, JSMediaRecorderPrototype::Base);

using JSMediaRecorderConstructor = JSDOMConstructor<JSMediaRecorder>;

template<> EncodedJSValue JSC_HOST_CALL JSMediaRecorderConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSMediaRecorderConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaRecorder");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto stream = convert<IDLInterface<MediaStream>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "stream", "MediaRecorder", nullptr, "MediaStream"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<MediaRecorder::Options>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = MediaRecorder::create(document, *stream, WTFMove(options));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<MediaRecorder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSMediaRecorderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaRecorderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaRecorder::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaRecorder"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaRecorderConstructor::s_info = { "MediaRecorder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRecorderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaRecorderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRecorderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRecorderConstructor) } },
    { "state", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRecorderState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "stream", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRecorderStream), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onstop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRecorderOnstop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRecorderOnstop) } },
    { "ondataavailable", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRecorderOndataavailable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRecorderOndataavailable) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRecorderOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRecorderOnerror) } },
    { "start", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaRecorderPrototypeFunctionStart), (intptr_t) (0) } },
    { "stop", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaRecorderPrototypeFunctionStop), (intptr_t) (0) } },
    { "requestData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaRecorderPrototypeFunctionRequestData), (intptr_t) (0) } },
};

const ClassInfo JSMediaRecorderPrototype::s_info = { "MediaRecorderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRecorderPrototype) };

void JSMediaRecorderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaRecorder::info(), JSMediaRecorderPrototypeTableValues, *this);
}

const ClassInfo JSMediaRecorder::s_info = { "MediaRecorder", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRecorder) };

JSMediaRecorder::JSMediaRecorder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaRecorder>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSMediaRecorder::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, MediaRecorder>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSMediaRecorder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaRecorderPrototype::create(vm, &globalObject, JSMediaRecorderPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSMediaRecorder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaRecorder>(vm, globalObject);
}

JSValue JSMediaRecorder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaRecorderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMediaRecorder* IDLAttribute<JSMediaRecorder>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaRecorder*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMediaRecorder* IDLOperation<JSMediaRecorder>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMediaRecorder*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMediaRecorderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaRecorderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaRecorder::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaRecorderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaRecorderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaRecorderStateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MediaRecorder::RecordingState>>(lexicalGlobalObject, throwScope, impl.state());
    return result;
}

EncodedJSValue jsMediaRecorderState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorderStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "state");
}

static inline JSValue jsMediaRecorderStreamGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<MediaStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.stream());
    return result;
}

EncodedJSValue jsMediaRecorderStream(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorderStreamGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "stream");
}

static inline JSValue jsMediaRecorderOnstopGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().stopEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaRecorderOnstop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorderOnstopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onstop");
}

static inline bool setJSMediaRecorderOnstopSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().stopEvent, value);
    return true;
}

bool setJSMediaRecorderOnstop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorderOnstopSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstop");
}

static inline JSValue jsMediaRecorderOndataavailableGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dataavailableEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaRecorderOndataavailable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorderOndataavailableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondataavailable");
}

static inline bool setJSMediaRecorderOndataavailableSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dataavailableEvent, value);
    return true;
}

bool setJSMediaRecorderOndataavailable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorderOndataavailableSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondataavailable");
}

static inline JSValue jsMediaRecorderOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaRecorderOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorderOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSMediaRecorderOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSMediaRecorderOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorderOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSC::EncodedJSValue jsMediaRecorderPrototypeFunctionStartBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaRecorder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto timeslice = callFrame->argument(0).isUndefined() ? Optional<Converter<IDLLong>::ReturnType>() : Optional<Converter<IDLLong>::ReturnType>(convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.startRecording(WTFMove(timeslice)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaRecorderPrototypeFunctionStart(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaRecorder>::call<jsMediaRecorderPrototypeFunctionStartBody>(*lexicalGlobalObject, *callFrame, "start");
}

static inline JSC::EncodedJSValue jsMediaRecorderPrototypeFunctionStopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaRecorder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.stopRecording();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaRecorderPrototypeFunctionStop(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaRecorder>::call<jsMediaRecorderPrototypeFunctionStopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

static inline JSC::EncodedJSValue jsMediaRecorderPrototypeFunctionRequestDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaRecorder>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.requestData();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaRecorderPrototypeFunctionRequestData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaRecorder>::call<jsMediaRecorderPrototypeFunctionRequestDataBody>(*lexicalGlobalObject, *callFrame, "requestData");
}

void JSMediaRecorder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaRecorder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaRecorderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsMediaRecorder = jsCast<JSMediaRecorder*>(handle.slot()->asCell());
    if (jsMediaRecorder->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsMediaRecorder->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaRecorderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaRecorder = static_cast<JSMediaRecorder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaRecorder->wrapped(), jsMediaRecorder);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaRecorder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13MediaRecorderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaRecorder>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MediaRecorder@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13MediaRecorderE[2];
#endif

    // If this fails MediaRecorder does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MediaRecorder>::value, "MediaRecorder is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MediaRecorder has subclasses. If MediaRecorder has subclasses that get passed
    // to toJS() we currently require MediaRecorder you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MediaRecorder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaRecorder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaRecorder* JSMediaRecorder::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaRecorder*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
